/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.adapter.EMARHttpCallback;
import com.hyphenate.cloud.CustomMultiPartEntity;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.cloud.HttpClientConfig;
import com.hyphenate.util.EMLog;
import internal.org.apache.http.entity.mime.HttpMultipartMode;
import internal.org.apache.http.entity.mime.content.FileBody;
import internal.org.apache.http.entity.mime.content.StringBody;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.ByteArrayBuffer;

public class EMARHttpAPI {
    public static final String TAG = "EMARHttpAPI";
    public static String Method_GET = "GET";
    public static String Method_POST = "POST";
    public static String Method_PUT = "PUT";
    public static String Method_DELETE = "DELETE";
    public static int REQUEST_FAILED_CODE = 408;
    public static int REQUEST_AUTHENTICATION_FAILED = 400;
    public static int HIGH_SPEED_DOWNLOAD_BUF_SIZE = 30720;
    final boolean tokenRetrieved = false;

    public static int upload(String string, String string2, String string3, Map<String, String> map, StringBuilder stringBuilder, final EMARHttpCallback eMARHttpCallback) {
        String string4 = EMClient.getInstance().getOptions().getAppKey();
        String string5 = EMClient.getInstance().getCurrentUser();
        File file = new File(string);
        int n = REQUEST_FAILED_CODE;
        EMLog.d(TAG, "upload");
        CustomMultiPartEntity customMultiPartEntity = new CustomMultiPartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName("UTF-8"), null);
        try {
            if (string4 != null) {
                customMultiPartEntity.addPart("app", new StringBody(string4));
            }
            if (string5 != null) {
                customMultiPartEntity.addPart("id", new StringBody(string5));
            }
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
            return n;
        }
        String string6 = EMARHttpAPI.getMimeType(file);
        String string7 = string;
        if (string.indexOf("/") >= 0) {
            string7 = string.substring(string.lastIndexOf("/") + 1);
        }
        if (string3 != null && !string3.isEmpty()) {
            EMLog.d(TAG, "upload, set filename: " + string3);
            string7 = string3;
        }
        customMultiPartEntity.addPart("file", new FileBody(file, string7, string6, "UTF-8"));
        final long l = customMultiPartEntity.getContentLength();
        final boolean[] blArray = new boolean[]{false};
        customMultiPartEntity.setListener(new CustomMultiPartEntity.ProgressListener(){

            @Override
            public void transferred(long l2) {
                int n = (int)((float)l2 / (float)l * 100.0f);
                if (n != 100 && eMARHttpCallback != null) {
                    eMARHttpCallback.onProgress(l, l2);
                }
            }

            @Override
            public void onConnectionResetException() {
                blArray[0] = true;
            }
        });
        String string8 = HttpClientConfig.getFileRemoteUrl(string2);
        HttpPost httpPost = new HttpPost(string8);
        httpPost.setEntity((HttpEntity)customMultiPartEntity);
        if (map != null) {
            for (Map.Entry<String, String> basicHttpParams2 : map.entrySet()) {
                httpPost.addHeader(basicHttpParams2.getKey(), basicHttpParams2.getValue());
            }
        }
        httpPost.addHeader("filename", file.getName());
        DefaultHttpClient defaultHttpClient = HttpClientConfig.getDefaultHttpClient(string2, 300000);
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        basicHttpParams.setParameter("http.protocol.element-charset", (Object)"UTF-8");
        defaultHttpClient.setParams((HttpParams)basicHttpParams);
        HttpResponse httpResponse = null;
        try {
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            n = httpResponse.getStatusLine().getStatusCode();
            if (blArray[0] && n != 413) {
                EMLog.e(TAG, "Connection reset but not 413 return default code");
                return REQUEST_FAILED_CODE;
            }
            switch (n) {
                case 200: {
                    try {
                        ByteArrayBuffer exception = EMARHttpAPI.getResponseContent(httpResponse);
                        EMLog.d(TAG, "getBackupInfo result:" + new String(exception.buffer(), 0, exception.length()));
                        stringBuilder.append(new String(exception.buffer(), 0, exception.length()));
                        break;
                    }
                    catch (Exception connectTimeoutException) {
                        EMLog.e(TAG, "json parse exception remotefilepath:" + string2);
                    }
                }
            }
        }
        catch (ConnectTimeoutException iOException) {
            EMLog.e(TAG, "ConnectTimeoutException");
        }
        catch (IOException exception) {
            if (httpResponse != null) {
                n = httpResponse.getStatusLine().getStatusCode();
            }
            EMLog.e(TAG, exception.getMessage());
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
        }
        return n;
    }

    public static int download(String string, String string2, Map<String, String> map, EMARHttpCallback eMARHttpCallback) {
        int n = REQUEST_FAILED_CODE;
        if (string == null || string.length() <= 0) {
            EMLog.e(TAG, "invalid remoteUrl");
            return n;
        }
        string = HttpClientConfig.getFileRemoteUrl(string);
        string = EMARHttpAPI.processUrl(string);
        EMLog.d(TAG, "download file: remote url : " + string + " , local file : " + string2);
        File file = new File(string2);
        EMLog.d(TAG, "local exists:" + file.exists());
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        DefaultHttpClient defaultHttpClient = HttpClientConfig.getDefaultHttpClient(string, 300000);
        try {
            HttpGet httpGet = new HttpGet(string);
            EMARHttpAPI.processHeaders(httpGet, map);
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
            n = httpResponse.getStatusLine().getStatusCode();
            switch (n) {
                case 200: {
                    long l = EMARHttpAPI.onDownloadCompleted(httpResponse, eMARHttpCallback, string2);
                    if (l <= 0L) {
                        return REQUEST_FAILED_CODE;
                    }
                    if (eMARHttpCallback != null) {
                        EMLog.e(TAG, "download successfully");
                    }
                    return n;
                }
                case 401: {
                    long l = EMHttpClient.getInstance().chatConfig().o();
                    if (System.currentTimeMillis() - l <= 600000L) {
                        if (eMARHttpCallback != null) {
                            EMLog.e(TAG, "unauthorized file");
                        }
                        return n;
                    }
                    break;
                }
                default: {
                    EMLog.e(TAG, "error response code is :" + n);
                    return n;
                }
            }
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null && (string3 = exception.toString()) == null) {
                string3 = "failed to download file";
            }
            EMLog.e(TAG, string3);
            return n;
        }
        return n;
    }

    public static int httpExecute(String string, Map<String, String> map, String string2, String string3, StringBuilder stringBuilder) {
        int n = REQUEST_FAILED_CODE;
        try {
            HttpResponse httpResponse = EMARHttpAPI._httpExecute(string, map, string2, string3);
            ByteArrayBuffer byteArrayBuffer = EMARHttpAPI.getResponseContent(httpResponse);
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append(new String(byteArrayBuffer.buffer(), 0, byteArrayBuffer.length()));
            n = httpResponse.getStatusLine().getStatusCode();
            EMLog.d(TAG, "httpExecute code: " + n);
            return n;
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            EMLog.e(TAG, "ConnectTimeoutException");
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
            exception.printStackTrace();
        }
        EMLog.e(TAG, "can't catch exceptions");
        return n;
    }

    private static HttpResponse _httpExecute(String string, Map<String, String> map, String string2, String string3) throws ClientProtocolException, IOException, KeyStoreException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, ConnectTimeoutException {
        Object object;
        HttpResponse httpResponse = null;
        int n = HttpClientConfig.getTimeout(map);
        DefaultHttpClient defaultHttpClient = HttpClientConfig.getDefaultHttpClient(string, n);
        HttpGet httpGet = null;
        if (string3.equals(Method_POST)) {
            object = new HttpPost(string);
            object.setEntity((HttpEntity)new StringEntity(string2, "UTF-8"));
            httpGet = object;
        } else if (string3.equals(Method_PUT)) {
            object = new HttpPut(string);
            object.setEntity((HttpEntity)new StringEntity(string2, "UTF-8"));
            httpGet = object;
        } else if (string3.equals(Method_GET)) {
            httpGet = new HttpGet(string);
        } else if (string3.equals(Method_DELETE)) {
            httpGet = new HttpDelete(string);
        }
        if (httpGet != null) {
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    httpGet.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
        }
        return httpResponse;
    }

    private static ByteArrayBuffer getResponseContent(HttpResponse httpResponse) throws Exception {
        InputStream inputStream = null;
        int n = HIGH_SPEED_DOWNLOAD_BUF_SIZE;
        byte[] byArray = new byte[n];
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n);
        long l = 0L;
        try {
            inputStream = httpResponse.getEntity().getContent();
            while ((l = (long)inputStream.read(byArray)) != -1L) {
                byteArrayBuffer.append(byArray, 0, (int)l);
            }
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            throw illegalStateException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return byteArrayBuffer;
    }

    private static String getMimeType(File file) {
        String string = file.getName();
        if (string.endsWith(".3gp") || string.endsWith(".amr")) {
            return "audio/3gp";
        }
        if (string.endsWith(".jpe") || string.endsWith(".jpeg") || string.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (string.endsWith(".amr")) {
            return "audio/amr";
        }
        if (string.endsWith(".mp4")) {
            return "video/mp4";
        }
        return "application/octet-stream";
    }

    private static long onDownloadCompleted(HttpResponse httpResponse, EMARHttpCallback eMARHttpCallback, String string) throws IOException, IllegalStateException {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return 0L;
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        int n = 0;
        int n2 = 0;
        long l = httpEntity.getContentLength();
        try {
            inputStream = httpEntity.getContent();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            throw illegalStateException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        File file = new File(string);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            inputStream.close();
            throw fileNotFoundException;
        }
        int n3 = HIGH_SPEED_DOWNLOAD_BUF_SIZE;
        byte[] byArray = new byte[n3];
        long l2 = 0L;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                int n4 = (int)((l2 += (long)n) * 100L / l);
                EMLog.d(TAG, n4 + "");
                if (n4 == 100 || n4 > n2 + 5) {
                    n2 = n4;
                    if (eMARHttpCallback != null) {
                        eMARHttpCallback.onProgress(l, l2);
                    }
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            long l3 = file.length();
            return l3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            ((OutputStream)fileOutputStream).close();
            inputStream.close();
        }
    }

    private static String processUrl(String string) {
        if (string.contains("+")) {
            string = string.replaceAll("\\+", "%2B");
        }
        if (string.contains("#")) {
            string = string.replaceAll("#", "%23");
        }
        return string;
    }

    private static void processHeaders(HttpGet httpGet, Map<String, String> map) {
        httpGet.addHeader("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
        httpGet.addHeader("Accept", "application/octet-stream");
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey().equals("Authorization") || entry.getKey().equals("Accept")) continue;
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }
}

