/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.graphics.BitmapFactory;
import android.util.Log;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMConversationListener;
import com.hyphenate.EMMessageListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMGroupReadAck;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.adapter.EMAChatManager;
import com.hyphenate.chat.adapter.EMAChatManagerListener;
import com.hyphenate.chat.adapter.EMAConversation;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAGroupReadAck;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.chat.core.EMAdvanceDebugManager;
import com.hyphenate.cloud.EMCloudOperationCallback;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.notification.core.a;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.ImageUtils;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EMChatManager {
    EMAChatManager emaObject;
    private static final String TAG = "EMChatManager";
    private static final String INTERNAL_ACTION_PREFIX = "em_";
    EMClient mClient;
    Map<String, EMConversation.MessageCache> caches = new Hashtable<String, EMConversation.MessageCache>();
    private List<EMMessageListener> messageListeners = Collections.synchronizedList(new ArrayList());
    private List<EMConversationListener> conversationListeners = Collections.synchronizedList(new ArrayList());
    EMAChatManagerListener chatManagerListenerImpl = new EMAChatManagerListener(){
        private final Object lockObj = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<EMMessageListener> cloneSyncedList(List<EMMessageListener> list) {
            if (list == null) {
                return new ArrayList<EMMessageListener>();
            }
            Object object = this.lockObj;
            synchronized (object) {
                return list.subList(0, list.size());
            }
        }

        @Override
        public void onReceiveMessages(final List<EMAMessage> list) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Iterator<EMMessageListener> iterator : list) {
                        arrayList.add(new EMMessage((EMAMessage)((Object)iterator)));
                    }
                    ArrayList arrayList2 = new ArrayList();
                    for (EMMessage object : arrayList) {
                        EMConversation eMConversation = EMChatManager.this.getConversation(object.conversationId(), EMConversation.msgType2ConversationType(object.getFrom(), object.getChatType()), false);
                        if (eMConversation == null) continue;
                        if (object.getType() != EMMessage.Type.CMD) {
                            eMConversation.getCache().addMessage(object);
                        }
                        arrayList2.add(object);
                    }
                    if (arrayList2.size() <= 0) {
                        return;
                    }
                    try {
                        for (EMMessageListener eMMessageListener : this.cloneSyncedList(EMChatManager.this.messageListeners)) {
                            eMMessageListener.onMessageReceived(arrayList2);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveCmdMessages(final List<EMAMessage> list) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (EMAMessage object : list) {
                        EMMessage eMMessage = new EMMessage(object);
                        String string = ((EMCmdMessageBody)eMMessage.getBody()).action();
                        if (EMChatManager.this.isAdvanceDebugMessage(string)) {
                            EMAdvanceDebugManager.a().a(eMMessage, EMAdvanceDebugManager.Type.valueOf(string));
                            continue;
                        }
                        arrayList.add(eMMessage);
                    }
                    try {
                        for (EMMessageListener eMMessageListener : this.cloneSyncedList(EMChatManager.this.messageListeners)) {
                            eMMessageListener.onCmdMessageReceived(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onMessageStatusChanged(final EMAMessage eMAMessage, EMAError eMAError) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    try {
                        EMMessage eMMessage = new EMMessage(eMAMessage);
                        for (EMMessageListener eMMessageListener : this.cloneSyncedList(EMChatManager.this.messageListeners)) {
                            eMMessageListener.onMessageChanged(eMMessage, null);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onMessageAttachmentsStatusChanged(EMAMessage eMAMessage, EMAError eMAError) {
            try {
                EMMessage eMMessage = new EMMessage(eMAMessage);
                for (EMMessageListener eMMessageListener : this.cloneSyncedList(EMChatManager.this.messageListeners)) {
                    eMMessageListener.onMessageChanged(eMMessage, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void onReceiveRecallMessages(final List<EMAMessage> list) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (EMAMessage object : list) {
                        arrayList.add(new EMMessage(object));
                        EMChatManager.this.getConversation(object.conversationId()).getCache().removeMessage(object.msgId());
                    }
                    try {
                        for (EMMessageListener eMMessageListener : this.cloneSyncedList(EMChatManager.this.messageListeners)) {
                            eMMessageListener.onMessageRecalled(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveHasReadAcks(final List<EMAMessage> list) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (EMAMessage object : list) {
                        arrayList.add(new EMMessage(object));
                    }
                    try {
                        for (EMMessageListener eMMessageListener : this.cloneSyncedList(EMChatManager.this.messageListeners)) {
                            eMMessageListener.onMessageRead(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveHasDeliveredAcks(final List<EMAMessage> list) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (EMAMessage object : list) {
                        arrayList.add(new EMMessage(object));
                    }
                    try {
                        for (EMMessageListener eMMessageListener : this.cloneSyncedList(EMChatManager.this.messageListeners)) {
                            eMMessageListener.onMessageDelivered(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onUpdateConversationList(List<EMAConversation> list) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onUpdateConversationList");
                    List list = EMChatManager.this.conversationListeners;
                    synchronized (list) {
                        try {
                            for (EMConversationListener eMConversationListener : EMChatManager.this.conversationListeners) {
                                eMConversationListener.onCoversationUpdate();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onReceivePrivateMessages(final List<EMAMessage> list) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onPrivateMessages");
                    for (EMAMessage eMAMessage : list) {
                        EMMessage eMMessage = new EMMessage(eMAMessage);
                        a.a().a(eMMessage);
                    }
                }
            });
        }

        @Override
        public void onReceiveReadAcksForGroupMessage(final List<EMAGroupReadAck> list) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onReceiveReadAcksForGroupMessage");
                    ArrayList<EMGroupReadAck> arrayList = new ArrayList<EMGroupReadAck>();
                    for (EMAGroupReadAck object : list) {
                        arrayList.add(new EMGroupReadAck(object));
                    }
                    try {
                        for (EMMessageListener eMMessageListener : this.cloneSyncedList(EMChatManager.this.messageListeners)) {
                            eMMessageListener.onGroupMessageRead(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onUpdateGroupAcks() {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onUpdateGroupAcks");
                    try {
                        for (EMMessageListener eMMessageListener : this.cloneSyncedList(EMChatManager.this.messageListeners)) {
                            eMMessageListener.onReadAckForGroupMessageUpdated();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    };
    private static final int LIST_SIZE = 512;

    protected EMChatManager() {
    }

    protected EMChatManager(EMClient eMClient, EMAChatManager eMAChatManager) {
        this.mClient = eMClient;
        this.emaObject = eMAChatManager;
        this.emaObject.addListener(this.chatManagerListenerImpl);
    }

    private boolean isAdvanceDebugMessage(String string) {
        if (string.startsWith(INTERNAL_ACTION_PREFIX)) {
            try {
                EMAdvanceDebugManager.Type.valueOf(string);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public void sendMessage(final EMMessage eMMessage) {
        eMMessage.makeCallbackStrong();
        boolean bl = eMMessage.getType() != EMMessage.Type.CMD;
        final EMConversation eMConversation = this.getConversation(eMMessage.conversationId(), EMConversation.msgType2ConversationType(eMMessage.getTo(), eMMessage.getChatType()), bl);
        if (eMConversation != null) {
            boolean bl2;
            boolean bl3 = bl2 = eMConversation.getCache().getMessage(eMMessage.getMsgId()) != null;
            if (!bl2) {
                long l = System.currentTimeMillis();
                EMMessage eMMessage2 = eMConversation.getLastMessage();
                if (eMMessage2 != null) {
                    l = l < eMMessage2.getMsgTime() ? eMMessage2.getMsgTime() : l;
                }
                eMMessage.setMsgTime(l + 1L);
                eMConversation.getCache().addMessage(eMMessage);
            }
        }
        this.mClient.executeOnSendQueue(new Runnable(){

            @Override
            public void run() {
                class HandleError {
                    final /* synthetic */ EMMessage val$msg;

                    HandleError(int n, String string) {
                        this.val$msg = eMMessage;
                        EMMessage.EMCallbackHolder eMCallbackHolder = this.val$msg.messageStatusCallBack;
                        if (eMCallbackHolder != null) {
                            eMCallbackHolder.onError(n, string);
                        }
                    }
                }
                try {
                    Object object;
                    String string = null;
                    if (eMMessage.getType() == EMMessage.Type.IMAGE) {
                        Object object2;
                        eMMessage.setStatus(EMMessage.Status.INPROGRESS);
                        object = (EMImageMessageBody)eMMessage.getBody();
                        if (object == null) {
                            new HandleError(EMChatManager.this, 1, "Message body can not be null", eMMessage);
                            return;
                        }
                        Object object3 = ((EMFileMessageBody)object).getLocalUrl();
                        File file = new File((String)object3);
                        if (!file.exists() || !file.canRead()) {
                            new HandleError(EMChatManager.this, 401, "File not exists or can not be read", eMMessage);
                            return;
                        }
                        if (!((EMImageMessageBody)object).isSendOriginalImage() && !((String)(object2 = ImageUtils.getScaledImage(EMChatManager.this.mClient.getContext(), (String)object3))).equals(object3)) {
                            string = object3;
                            File file2 = new File((String)object2);
                            long l = new File((String)object3).length();
                            long l2 = file2.length();
                            if (l == 0L) {
                                EMLog.d(EMChatManager.TAG, "original image size:" + l);
                                new HandleError(EMChatManager.this, 401, "original image size is 0", eMMessage);
                                return;
                            }
                            EMLog.d(EMChatManager.TAG, "original image size:" + l + " scaled image size:" + l2 + " ratio:" + (int)(l2 / l) + "%");
                            object3 = object2;
                            ((EMFileMessageBody)object).setLocalUrl((String)object3);
                        }
                        object2 = ImageUtils.getBitmapOptions((String)object3);
                        int n = ((BitmapFactory.Options)object2).outWidth;
                        int n2 = ((BitmapFactory.Options)object2).outHeight;
                        ((EMImageMessageBody)object).setSize(n, n2);
                        ((EMFileMessageBody)object).setFileName(new File((String)object3).getName());
                    } else if (eMMessage.getType() == EMMessage.Type.VIDEO) {
                        eMMessage.setStatus(EMMessage.Status.INPROGRESS);
                        object = (EMVideoMessageBody)eMMessage.getBody();
                        if (object == null) {
                            new HandleError(EMChatManager.this, 1, "Message body can not be null", eMMessage);
                            return;
                        }
                        String string2 = ((EMFileMessageBody)object).getLocalUrl();
                        File file = new File(string2);
                        if (!file.exists() || !file.canRead()) {
                            new HandleError(EMChatManager.this, 401, "File not exists or can not be read", eMMessage);
                            return;
                        }
                        BitmapFactory.Options options = ImageUtils.getBitmapOptions(((EMVideoMessageBody)object).getLocalThumb());
                        int n = options.outWidth;
                        int n3 = options.outHeight;
                        ((EMVideoMessageBody)object).setThumbnailSize(n, n3);
                    }
                    object = eMMessage.getMsgId();
                    EMChatManager.this.setMessageSendCallback(eMMessage, eMConversation, (String)object, string);
                    EMChatManager.this.emaObject.sendMessage((EMAMessage)eMMessage.emaObject);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HandleError(EMChatManager.this, 1, "send message failed", eMMessage);
                }
            }
        });
    }

    private void setMessageSendCallback(final EMMessage eMMessage, final EMConversation eMConversation, final String string, final String string2) {
        if (eMMessage == null) {
            return;
        }
        eMMessage.setInnerCallback(new EMCallBack(){

            @Override
            public void onSuccess() {
                if (eMConversation != null) {
                    eMConversation.getCache().removeMessage(string);
                    eMConversation.getCache().addMessage(eMMessage);
                }
                if (string2 != null && eMMessage.getBody() instanceof EMImageMessageBody) {
                    File file;
                    String string3 = ((EMImageMessageBody)eMMessage.getBody()).getLocalUrl();
                    EMLog.d(EMChatManager.TAG, "origin: + " + string2 + ", scale:" + string3);
                    if (string3 != null && !string3.equals(string2) && (file = new File(string3)).exists()) {
                        file.delete();
                    }
                    ((EMImageMessageBody)eMMessage.getBody()).setLocalUrl(string2);
                    EMChatManager.this.updateMessage(eMMessage);
                }
            }

            @Override
            public void onProgress(int n, String string3) {
            }

            @Override
            public void onError(int n, String string3) {
            }
        });
    }

    public void ackMessageRead(String string, String string2) throws HyphenateException {
        EMOptions eMOptions = EMClient.getInstance().getChatConfigPrivate().b();
        if (!eMOptions.getRequireAck()) {
            EMLog.d(TAG, "chat option reqire ack set to false. skip send out ask msg read");
            return;
        }
        EMAMessage eMAMessage = this.emaObject.getMessage(string2);
        if (eMAMessage != null) {
            this.emaObject.sendReadAckForMessage(eMAMessage);
        } else {
            EMAMessage eMAMessage2 = EMAMessage.createReceiveMessage("", EMMessage.self(), null, EMMessage.ChatType.Chat.ordinal());
            eMAMessage2.setMsgId(string2);
            eMAMessage2.setFrom(string);
            this.emaObject.sendReadAckForMessage(eMAMessage2);
        }
    }

    public void ackGroupMessageRead(String string, String string2, String string3) throws HyphenateException {
        EMOptions eMOptions = EMClient.getInstance().getChatConfigPrivate().b();
        if (!eMOptions.getRequireAck()) {
            EMLog.d(TAG, "chat option reqire ack set to false. skip send out ask msg read");
            return;
        }
        EMAMessage eMAMessage = this.emaObject.getMessage(string2);
        if (eMAMessage != null) {
            if (eMAMessage.isNeedGroupAck()) {
                this.emaObject.sendReadAckForGroupMessage(eMAMessage, string3);
            } else {
                EMLog.d(TAG, "normal group message, do not ack it");
            }
        }
    }

    public void recallMessage(EMMessage eMMessage) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.recallMessage((EMAMessage)eMMessage.emaObject, eMAError);
        this.handleError(eMAError);
        this.getConversation(eMMessage.getTo()).getCache().removeMessage(eMMessage.getMsgId());
    }

    public void aysncRecallMessage(final EMMessage eMMessage, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatManager.this.recallMessage(eMMessage);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EMMessage getMessage(String string) {
        Object object = this.caches;
        synchronized (object) {
            for (EMConversation.MessageCache messageCache : this.caches.values()) {
                EMMessage eMMessage = messageCache.getMessage(string);
                if (eMMessage == null) continue;
                return eMMessage;
            }
        }
        object = this.emaObject.getMessage(string);
        if (object == null) {
            return null;
        }
        EMMessage eMMessage = new EMMessage((EMAMessage)object);
        return eMMessage;
    }

    public EMConversation getConversation(String string) {
        EMAConversation eMAConversation = this.emaObject.conversationWithType(string, EMAConversation.EMAConversationType.CHAT, false);
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(string, EMAConversation.EMAConversationType.GROUPCHAT, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(string, EMAConversation.EMAConversationType.CHATROOM, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(string, EMAConversation.EMAConversationType.DISCUSSIONGROUP, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(string, EMAConversation.EMAConversationType.HELPDESK, false);
        }
        return eMAConversation == null ? null : new EMConversation(eMAConversation);
    }

    public EMConversation getConversation(String string, EMConversation.EMConversationType eMConversationType) {
        return this.getConversation(string, eMConversationType, false);
    }

    public EMConversation getConversation(String string, EMConversation.EMConversationType eMConversationType, boolean bl) {
        EMAConversation.EMAConversationType eMAConversationType = EMAConversation.EMAConversationType.CHAT;
        if (eMConversationType == EMConversation.EMConversationType.Chat) {
            eMAConversationType = EMAConversation.EMAConversationType.CHAT;
        } else if (eMConversationType == EMConversation.EMConversationType.GroupChat) {
            eMAConversationType = EMAConversation.EMAConversationType.GROUPCHAT;
        } else if (eMConversationType == EMConversation.EMConversationType.ChatRoom) {
            eMAConversationType = EMAConversation.EMAConversationType.CHATROOM;
        } else if (eMConversationType == EMConversation.EMConversationType.DiscussionGroup) {
            eMAConversationType = EMAConversation.EMAConversationType.DISCUSSIONGROUP;
        } else if (eMConversationType == EMConversation.EMConversationType.HelpDesk) {
            eMAConversationType = EMAConversation.EMAConversationType.HELPDESK;
        }
        EMAConversation eMAConversation = this.emaObject.conversationWithType(string, eMAConversationType, bl);
        if (eMAConversation == null) {
            return null;
        }
        Log.d((String)TAG, (String)("convID:" + eMAConversation.conversationId()));
        return new EMConversation(eMAConversation);
    }

    public void markAllConversationsAsRead() {
        List<EMAConversation> list = this.emaObject.loadAllConversationsFromDB();
        for (EMAConversation eMAConversation : list) {
            eMAConversation.markAllMessagesAsRead(true);
        }
    }

    @Deprecated
    public int getUnreadMsgsCount() {
        return this.getUnreadMessageCount();
    }

    public int getUnreadMessageCount() {
        List<EMAConversation> list = this.emaObject.getConversations();
        int n = 0;
        for (EMAConversation eMAConversation : list) {
            if (eMAConversation._getType() == EMAConversation.EMAConversationType.CHATROOM) continue;
            n += eMAConversation.unreadMessagesCount();
        }
        return n;
    }

    public void saveMessage(EMMessage eMMessage) {
        EMMessage.ChatType chatType = eMMessage.getChatType();
        EMConversation.EMConversationType eMConversationType = EMConversation.EMConversationType.Chat;
        switch (chatType) {
            case Chat: {
                eMConversationType = EMConversation.EMConversationType.Chat;
                break;
            }
            case GroupChat: {
                eMConversationType = EMConversation.EMConversationType.GroupChat;
                break;
            }
            case ChatRoom: {
                eMConversationType = EMConversation.EMConversationType.ChatRoom;
            }
        }
        String string = eMMessage.getTo();
        if (eMConversationType == EMConversation.EMConversationType.Chat && eMMessage.direct() == EMMessage.Direct.RECEIVE) {
            string = eMMessage.getFrom();
        }
        if (eMMessage.getType() == EMMessage.Type.CMD) {
            return;
        }
        EMConversation eMConversation = this.getConversation(string, eMConversationType, true);
        eMConversation.insertMessage(eMMessage);
    }

    public boolean updateMessage(EMMessage eMMessage) {
        String string;
        String string2 = string = eMMessage.direct() == EMMessage.Direct.RECEIVE ? eMMessage.getFrom() : eMMessage.getTo();
        if (eMMessage.getType() == EMMessage.Type.CMD) {
            return false;
        }
        EMConversation eMConversation = this.getConversation(eMMessage.conversationId(), EMConversation.msgType2ConversationType(string, eMMessage.getChatType()), true);
        return eMConversation.updateMessage(eMMessage);
    }

    public void downloadAttachment(EMMessage eMMessage) {
        if (eMMessage == null) {
            return;
        }
        eMMessage.makeCallbackStrong();
        this.emaObject.downloadMessageAttachments((EMAMessage)eMMessage.emaObject);
    }

    public void downloadThumbnail(EMMessage eMMessage) {
        eMMessage.makeCallbackStrong();
        this.emaObject.downloadMessageThumbnail((EMAMessage)eMMessage.emaObject);
    }

    public synchronized void importMessages(List<EMMessage> list) {
        ArrayList<EMAMessage> arrayList = new ArrayList<EMAMessage>();
        for (EMMessage eMMessage : list) {
            arrayList.add((EMAMessage)eMMessage.emaObject);
        }
        EMClient.getInstance().getChatConfigPrivate().c(arrayList);
    }

    public List<EMConversation> getConversationsByType(EMConversation.EMConversationType eMConversationType) {
        List<EMAConversation> list = this.emaObject.getConversations();
        ArrayList<EMConversation> arrayList = new ArrayList<EMConversation>();
        for (EMAConversation eMAConversation : list) {
            if (eMConversationType.ordinal() != eMAConversation._getType().ordinal()) continue;
            arrayList.add(new EMConversation(eMAConversation));
        }
        return arrayList;
    }

    @Deprecated
    public void downloadFile(String string, String string2, Map<String, String> map, final EMCallBack eMCallBack) {
        EMHttpClient.getInstance().downloadFile(string, string2, map, new EMCloudOperationCallback(){

            @Override
            public void onSuccess(String string) {
                if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }

            @Override
            public void onError(String string) {
                if (eMCallBack != null) {
                    eMCallBack.onError(1, string);
                }
            }

            @Override
            public void onProgress(int n) {
                if (eMCallBack != null) {
                    eMCallBack.onProgress(n, null);
                }
            }
        });
    }

    public Map<String, EMConversation> getAllConversations() {
        List<EMAConversation> list = this.emaObject.getConversations();
        Hashtable<String, EMConversation> hashtable = new Hashtable<String, EMConversation>();
        for (EMAConversation eMAConversation : list) {
            hashtable.put(eMAConversation.conversationId(), new EMConversation(eMAConversation));
        }
        return hashtable;
    }

    public void loadAllConversations() {
        this.emaObject.loadAllConversationsFromDB();
    }

    public boolean deleteConversation(String string, boolean bl) {
        EMConversation eMConversation = this.getConversation(string);
        if (eMConversation == null) {
            return false;
        }
        if (!bl) {
            eMConversation.clear();
        } else {
            eMConversation.clearAllMessages();
        }
        this.emaObject.removeConversation(string, bl);
        return true;
    }

    public void addMessageListener(EMMessageListener eMMessageListener) {
        if (eMMessageListener == null) {
            return;
        }
        if (!this.messageListeners.contains(eMMessageListener)) {
            this.messageListeners.add(eMMessageListener);
        }
    }

    public void removeMessageListener(EMMessageListener eMMessageListener) {
        if (eMMessageListener == null) {
            return;
        }
        this.messageListeners.remove(eMMessageListener);
    }

    public void addConversationListener(EMConversationListener eMConversationListener) {
        if (!this.conversationListeners.contains(eMConversationListener)) {
            this.conversationListeners.add(eMConversationListener);
        }
    }

    public void removeConversationListener(EMConversationListener eMConversationListener) {
        if (eMConversationListener == null) {
            return;
        }
        this.conversationListeners.remove(eMConversationListener);
    }

    @Deprecated
    public void setMessageListened(EMMessage eMMessage) {
        this.setVoiceMessageListened(eMMessage);
    }

    public void setVoiceMessageListened(EMMessage eMMessage) {
        eMMessage.setListened(true);
        this.updateMessage(eMMessage);
    }

    void onLogout() {
        this.caches.clear();
    }

    synchronized void loadAllConversationsFromDB() {
        this.emaObject.loadAllConversationsFromDB();
    }

    public boolean updateParticipant(String string, String string2) {
        return this.emaObject.updateParticipant(string, string2);
    }

    public EMCursorResult<EMGroupReadAck> fetchGroupReadAcks(String string, int n, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMGroupReadAck> eMCursorResult = new EMCursorResult<EMGroupReadAck>();
        EMMessage eMMessage = this.getMessage(string);
        String string3 = null;
        if (eMMessage.getChatType() != EMMessage.ChatType.GroupChat || !eMMessage.isNeedGroupAck()) {
            EMLog.e(TAG, "not group msg or don't need ack");
            return eMCursorResult;
        }
        string3 = eMMessage.conversationId();
        EMCursorResult<EMAGroupReadAck> eMCursorResult2 = this.emaObject.fetchGroupReadAcks(string, string3, eMAError, n, string2);
        this.handleError(eMAError);
        eMCursorResult.setCursor(eMCursorResult2.getCursor());
        ArrayList<EMGroupReadAck> arrayList = new ArrayList<EMGroupReadAck>();
        for (EMAGroupReadAck eMAGroupReadAck : (List)eMCursorResult2.getData()) {
            arrayList.add(new EMGroupReadAck(eMAGroupReadAck));
        }
        eMCursorResult.setData(arrayList);
        return eMCursorResult;
    }

    public void asyncFetchGroupReadAcks(final String string, final int n, final String string2, final EMValueCallBack<EMCursorResult<EMGroupReadAck>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatManager.this.fetchGroupReadAcks(string, n, string2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMCursorResult<EMMessage> fetchHistoryMessages(String string, EMConversation.EMConversationType eMConversationType, int n, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAMessage> eMCursorResult = this.emaObject.fetchHistoryMessages(string, eMConversationType.ordinal(), n, string2, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMMessage> eMCursorResult2 = new EMCursorResult<EMMessage>();
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
        for (EMAMessage eMAMessage : (List)eMCursorResult.getData()) {
            arrayList.add(new EMMessage(eMAMessage));
        }
        eMCursorResult2.setData(arrayList);
        return eMCursorResult2;
    }

    public void asyncFetchHistoryMessage(final String string, final EMConversation.EMConversationType eMConversationType, final int n, final String string2, final EMValueCallBack<EMCursorResult<EMMessage>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatManager.this.fetchHistoryMessages(string, eMConversationType, n, string2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    public List<EMMessage> searchMsgFromDB(EMMessage.Type type, long l, int n, String string, EMConversation.EMSearchDirection eMSearchDirection) {
        EMAConversation.EMASearchDirection eMASearchDirection = eMSearchDirection == EMConversation.EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = this.emaObject.searchMessages(type.ordinal(), l, n, string, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(String string, long l, int n, String string2, EMConversation.EMSearchDirection eMSearchDirection) {
        EMAConversation.EMASearchDirection eMASearchDirection = eMSearchDirection == EMConversation.EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = this.emaObject.searchMessages(string, l, n, string2, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }
}

