/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.objects;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.superrtc.GlUtil;
import com.superrtc.program.WaterSignSProgram;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class FBOFrameRect {
    private static final float[] FRONT_FULL_RECTANGLE_COORDS = new float[]{1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    private static final float[] BACK_FULL_RECTANGLE_COORDS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] FULL_RECTANGLE_TEX_COORDS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private FloatBuffer mVertexArray;
    private FloatBuffer mTexCoordArray;
    private int mCoordsPerVertex;
    private int mCoordsPerTexture;
    private int mVertexCount;
    private int mVertexStride;
    private int mTexCoordStride;
    public float[] mProjectionMatrix = new float[16];
    public float[] mViewMatrix = new float[16];
    public float[] mModelMatrix = new float[16];
    public float[] mMVPMatrix = new float[16];
    private WaterSignSProgram mProgram;

    private float[] getFinalMatrix() {
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mModelMatrix, (int)0);
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mMVPMatrix, (int)0);
        return this.mMVPMatrix;
    }

    public void setCameraInfo(boolean bl) {
        if (bl) {
            this.mVertexArray = this.createFloatBuffer(FRONT_FULL_RECTANGLE_COORDS);
            this.mCoordsPerVertex = 2;
            this.mCoordsPerTexture = 2;
            this.mVertexCount = FRONT_FULL_RECTANGLE_COORDS.length / this.mCoordsPerVertex;
        } else {
            this.mVertexArray = this.createFloatBuffer(BACK_FULL_RECTANGLE_COORDS);
            this.mCoordsPerVertex = 2;
            this.mCoordsPerTexture = 2;
            this.mVertexCount = BACK_FULL_RECTANGLE_COORDS.length / this.mCoordsPerVertex;
        }
        this.mTexCoordArray = this.createFloatBuffer(FULL_RECTANGLE_TEX_COORDS);
        this.mTexCoordStride = 8;
        this.mVertexStride = 8;
        Matrix.setIdentityM((float[])this.mProjectionMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mModelMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
    }

    private FloatBuffer createFloatBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public void setShaderProgram(WaterSignSProgram waterSignSProgram) {
        this.mProgram = waterSignSProgram;
    }

    public void drawFrame(int n) {
        GLES20.glUseProgram((int)this.mProgram.getShaderProgramId());
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n);
        GLES20.glUniform1i((int)this.mProgram.sTextureLoc, (int)0);
        GlUtil.checkGlError("GL_TEXTURE_2D sTexture");
        GLES20.glUniformMatrix4fv((int)this.mProgram.uMVPMatrixLoc, (int)1, (boolean)false, (float[])this.getFinalMatrix(), (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv uMVPMatrixLoc");
        GLES20.glEnableVertexAttribArray((int)this.mProgram.aPositionLoc);
        GLES20.glVertexAttribPointer((int)this.mProgram.aPositionLoc, (int)this.mCoordsPerVertex, (int)5126, (boolean)false, (int)this.mVertexStride, (Buffer)this.mVertexArray);
        GlUtil.checkGlError("VAO aPositionLoc");
        GLES20.glEnableVertexAttribArray((int)this.mProgram.aTextureCoordLoc);
        GLES20.glVertexAttribPointer((int)this.mProgram.aTextureCoordLoc, (int)this.mCoordsPerTexture, (int)5126, (boolean)false, (int)this.mTexCoordStride, (Buffer)this.mTexCoordArray);
        GlUtil.checkGlError("VAO aTextureCoordLoc");
        GLES20.glDrawArrays((int)5, (int)0, (int)this.mVertexCount);
        GLES20.glDisableVertexAttribArray((int)this.mProgram.aPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.mProgram.aTextureCoordLoc);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glUseProgram((int)0);
    }
}

