/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.JavaI420Buffer;
import com.superrtc.RefCountDelegate;
import com.superrtc.VideoFrame;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class NV12Buffer
implements VideoFrame.Buffer {
    private final int width;
    private final int height;
    private final int stride;
    private final int sliceHeight;
    private final ByteBuffer buffer;
    private final RefCountDelegate refCountDelegate;

    public NV12Buffer(int n, int n2, int n3, int n4, ByteBuffer byteBuffer, @Nullable Runnable runnable) {
        this.width = n;
        this.height = n2;
        this.stride = n3;
        this.sliceHeight = n4;
        this.buffer = byteBuffer;
        this.refCountDelegate = new RefCountDelegate(runnable);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)this.cropAndScale(0, 0, this.width, this.height, this.width, this.height);
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n, int n2, int n3, int n4, int n5, int n6) {
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n5, n6);
        NV12Buffer.nativeCropAndScale(n, n2, n3, n4, n5, n6, this.buffer, this.width, this.height, this.stride, this.sliceHeight, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV());
        return javaI420Buffer;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, ByteBuffer var6, int var7, int var8, int var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14, ByteBuffer var15, int var16);
}

