/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.FBOobjects;

import android.opengl.GLES20;

public class FrameBuffer {
    private int mWidth = 0;
    private int mHeight = 0;
    private int frameBufferId = 0;
    private int renderBufferId = 0;
    private int textureId = 0;

    public int getTextureId() {
        return this.textureId;
    }

    public boolean isInstantiation() {
        return this.mWidth != 0 || this.mHeight != 0;
    }

    public boolean setup(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        int[] nArray = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            int n3 = GLES20.glGetError();
            throw new RuntimeException("Could not create a new frame buffer object, glErrorString : " + GLES20.glGetString((int)n3));
        }
        this.frameBufferId = nArray[0];
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return true;
    }

    public void reSize(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        this.end();
        this.release();
        this.setup(n, n2);
    }

    public boolean begin() {
        if (this.textureId == 0) {
            this.textureId = this.createFBOTexture(this.mWidth, this.mHeight, 6408);
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBufferId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.textureId, (int)0);
        return true;
    }

    private int createFBOTexture(int n, int n2, int n3) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            int n4 = GLES20.glGetError();
            throw new RuntimeException("Could not create a new texture buffer object, glErrorString : " + GLES20.glGetString((int)n4));
        }
        GLES20.glBindTexture((int)3553, (int)nArray[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)3553, (int)0, (int)n3, (int)n, (int)n2, (int)0, (int)n3, (int)5121, null);
        return nArray[0];
    }

    public void end() {
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public void release() {
        this.mWidth = 0;
        this.mHeight = 0;
        GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.frameBufferId}, (int)0);
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.textureId}, (int)0);
        this.frameBufferId = 0;
        this.textureId = 0;
    }
}

