package com.hyphenate.push.platform;

import android.content.Context;

import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushType;

public abstract class IPush {
    private static final String TAG = "IPush";

    private String notifierName;

    public void register(Context context, EMPushConfig config) {
        notifierName = onGetNotifierName(config);
        onRegister(context, config);
    }

    public void unregister(Context context) {
        onUnregister(context);
    }

    public String getNotifierName() {
        return notifierName;
    }

    public abstract EMPushType getPushType();

    public abstract void onRegister(Context context, EMPushConfig config);

    public abstract void onUnregister(Context context);

    public abstract String onGetNotifierName(EMPushConfig config);
}
