/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.exceptions;

import com.hyphenate.EMError;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;

public class EMExceptionUtils {
    public static int fromExceptionToErrorCode(Exception e){
    	int error = EMError.GENERAL_ERROR;
    	if (e instanceof NoSuchAlgorithmException) {
			error = EMError.MESSAGE_ENCRYPTION_ERROR;
		} else if (e instanceof UnrecoverableKeyException) {
			error = EMError.MESSAGE_ENCRYPTION_ERROR;
		} else if (e instanceof KeyManagementException) {
			error = EMError.MESSAGE_ENCRYPTION_ERROR;
		}else if (e.getMessage().contains("User removed")){
			error = EMError.USER_REMOVED;
		}else if (e.getMessage().contains("conflict")){
			error = EMError.USER_LOGIN_ANOTHER_DEVICE;
		}
    	
    	return error;
    }
}
