/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.cloud;

import android.support.annotation.NonNull;

import com.hyphenate.util.EMLog;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

import internal.org.apache.http.entity.mime.HttpMultipartMode;
import internal.org.apache.http.entity.mime.MultipartEntity;


public class CustomMultiPartEntity extends MultipartEntity{
    private ProgressListener listener;
    
    public CustomMultiPartEntity(final ProgressListener listener)
    {
        super();
        this.listener = listener;
    }
 
    public CustomMultiPartEntity(final HttpMultipartMode mode, final ProgressListener listener)
    {
        super(mode);
        this.listener = listener;
    }
 
    public CustomMultiPartEntity(HttpMultipartMode mode, final String boundary, final Charset charset, final ProgressListener listener)
    {
        super(mode, boundary, charset);
        this.listener = listener;
    }
    
    public void setListener(final ProgressListener listener) {
    	this.listener = listener;
    }
 
    @Override
    public void writeTo(final OutputStream outstream) throws IOException
    {
        try {
            super.writeTo(new CountingOutputStream(outstream, this.listener));
        } catch (IOException e) {
            if (e.getMessage() != null && e.getMessage().contains("Connection reset")) {
                EMLog.e("CustomMultiPartEntity", "WriteToException: Connection reset");
                if (listener != null) {
                    listener.onConnectionResetException();
                }
            } else {
                throw e;
            }
        }
    }
 
    public interface ProgressListener
    {
        void transferred(long num);
        void onConnectionResetException();
    }
 
    public static class CountingOutputStream extends FilterOutputStream
    {
 
        private final ProgressListener listener;
        private long transferred;
 
        public CountingOutputStream(final OutputStream out, final ProgressListener listener)
        {
            super(out);
            this.listener = listener;
            this.transferred = 0;
        }
 
        public void write(@NonNull byte[] b, int off, int len) throws IOException
        {
            out.write(b, off, len);
            this.transferred += len;
            this.listener.transferred(this.transferred);
        }
 
        public void write(int b) throws IOException
        {
            out.write(b);
            this.transferred++;
            this.listener.transferred(this.transferred);
        }
    }
}
