package com.hyphenate.chat;


import android.view.View;

/**
 * Created by lzan13 on 2017/8/16.
 * \~chinese
 * 本地推流配置信息类
 *
 * \~english
 * Local publish stream config
 */
public class EMStreamParam {

    /**
     * \~chinese
     * 推流配置名称
     *
     * \~english
     * local publish stream name
     */
    protected String name;

    /**
     * \~chinese
     * 是否关闭视频
     *
     * \~english
     * Whether to turn off the video
     */
    protected boolean videoOff;

    /**
     * \~chinese
     * 是否静音
     *
     * \~english
     * Whether mute
     */
    protected boolean audioOff;

    /**
     * \~chinese
     * 使用后置摄像头 默认为 false
     *
     * \~english
     * Use back camera, default false
     */
    protected boolean useBackCamera;

    /**
     * \~chinese
     * 视频宽度
     *
     * \~english
     * Video width
     */
    protected int videoWidth;

    /**
     * \~chinese
     * 视频高度
     *
     * \~english
     * Video height
     */
    protected int videoHeight;

    /**
     * \~chinese
     * 扩展字段
     *
     * \~english
     * extension
     */
    protected String extension;

    /**
     * \~chinese
     * 分享的 view
     *
     * \~english
     * Share view
     */
    protected View shareView;

    /**
     * |~chinese
     * 推送 stream 类型
     *
     * \~english
     * Publish stream type
     */
    protected EMConferenceStream.StreamType streamType;

    /**
     *  \~chinese
     *  最大视频码率
     *  范围 50 &#60; videoKbps &#60; 5000, 默认0, 0为自适应
     *  建议设置为0
     *
     *  \~english
     *  Video kbps
     *  range: 50 &#60; videoKbps &#60; 5000. Default value is 0, which is adaptive bitrate streaming.
     *  recommend use default value
     */
    protected int maxVideoKbps;

    /**
     * \~chinese
     * 设置最小的网络带宽
     *
     * \~english
     * config minimum of bit rate
     */
    protected int minVideoKbps;

    /**
     * \~chinese
     * 设置最大音频比特率，取值范围 6 ~ 510
     * @param maxAudioKbps 最大音频码率
     *
     * \~english
     * set audio bitrate, 6 ~ 510
     * @param maxAudioKbps max audio bitrate
     */
    protected int maxAudioKbps;

    /**
     * \~chinese
     * 设置音频采样频率，需要在第一次通话之前设置
     * 参考值8000Hz、11025Hz、22050Hz、16000Hz、44100Hz、48000Hz
     *
     * \~english
     * config audio sample rate
     * optional values: 8000Hz, 11025Hz, 22050Hz, 16000Hz, 44100Hz
     */
    protected int audioSampleRate;

    /**
     * \~chinese
     * 开启或关闭自动调节分辨率
     *
     * \~english
     * enable/disable auto adjust resolution
     */
    protected boolean enableFixedVideoResolution;

    /**
     * \~chinese
     * 开启或关闭用户自定义数据
     *
     * \~english
     * enable/disable external data
     */
    protected boolean usingExternalSource;

    public EMStreamParam() {
        name = "AndroidNormal";
        videoOff = false;
        audioOff = false;
        useBackCamera = false;
        videoWidth = 0;
        videoHeight = 0;
        extension = "";
        shareView = null;
        streamType = EMConferenceStream.StreamType.NORMAL;
        maxVideoKbps = 0;
        minVideoKbps = 0;
        maxAudioKbps = 0;
        audioSampleRate = 0;
        enableFixedVideoResolution = false;
        usingExternalSource = false;
    }

    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }


    public boolean isVideoOff() {
        return videoOff;
    }

    public void setVideoOff(boolean videoOff) {
        this.videoOff = videoOff;
    }

    public boolean isAudioOff() {
        return audioOff;
    }

    public void setAudioOff(boolean audioOff) {
        this.audioOff = audioOff;
    }

    public void setUseBackCamera(boolean useBackCamera) {
        this.useBackCamera = useBackCamera;
    }

    public boolean isUseBackCamera() {
        return useBackCamera;
    }

    public int getVideoWidth() {
        return videoWidth;
    }

    public void setVideoWidth(int videoWidth) {
        this.videoWidth = videoWidth;
    }

    public int getVideoHeight() {
        return videoHeight;
    }

    public void setVideoHeight(int videoHeight) {
        this.videoHeight = videoHeight;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public View getShareView() {
        return shareView;
    }

    public void setShareView(View shareView) {
        this.shareView = shareView;
    }

    public EMConferenceStream.StreamType getStreamType() {
        return streamType;
    }

    public void setStreamType(EMConferenceStream.StreamType streamType) {
        this.streamType = streamType;
    }

    public int getMaxVideoKbps() {
        return maxVideoKbps;
    }

    public void setMaxVideoKbps(int maxVideoKbps) {
        this.maxVideoKbps = maxVideoKbps;
    }

    public int getMinVideoKbps() {
        return minVideoKbps;
    }

    public void setMinVideoKbps(int minVideoKbps) {
        this.minVideoKbps = minVideoKbps;
    }

    public int getMaxAudioKbps() {
        return maxAudioKbps;
    }

    public void setMaxAudioKbps(int maxAudioKbps) {
        this.maxAudioKbps = maxAudioKbps;
    }

    public int getAudioSampleRate() {
        return audioSampleRate;
    }

    public void setAudioSampleRate(int audioSampleRate) {
        this.audioSampleRate = audioSampleRate;
    }

    public boolean isEnableFixedVideoResolution() {
        return enableFixedVideoResolution;
    }

    public void setEnableFixedVideoResolution(boolean enableFixedVideoResolution) {
        this.enableFixedVideoResolution = enableFixedVideoResolution;
    }

    public boolean isUsingExternalSource() {return usingExternalSource; }

    public void setUsingExternalSource(boolean usingExternalSource) {
        this.usingExternalSource = usingExternalSource;
    }
}

