package com.hyphenate.chat;

/**
 * 会议房间属性类
 * confrTyp   会议类型
 * isSupportVxmini  是否支持小程序
 * isRecord    是否支持录制
 * isMergeRecord  是否支持和流
 * nickName  用户昵称
 * ext     用户头像
 * maxTalkerCount   房间最多主播
 * maxVideoCount    房间最多视频
 * maxAudienceCount 房间最多观众
 */

public class EMRoomConfig {
    EMConferenceManager.EMConferenceType confrTyp = EMConferenceManager.EMConferenceType.SmallCommunication;
	private boolean isSupportMiniProgram = false;
	private boolean isRecord = false;
	private boolean isMergeRecord = false;
	private String  nickName = null;
	private String  ext = null;
	private int  maxTalkerCount = -1;
    private int  maxVideoCount = -1;
    private int  maxAudienceCount = -1;

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getExt() {
        return ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    public int getMaxTalkerCount() {
        return maxTalkerCount;
    }

    public void setMaxTalkerCount(int maxTalkerCount) {
        this.maxTalkerCount = maxTalkerCount;
    }

    public int getMaxVideoCount() {
        return maxVideoCount;
    }

    public void setMaxVideoCount(int maxVideoCount) {
        this.maxVideoCount = maxVideoCount;
    }

    public int getMaxAudienceCount() {
        return maxAudienceCount;
    }

    public void setMaxAudienceCount(int maxAudienceCount) {
        this.maxAudienceCount = maxAudienceCount;
    }

    public EMRoomConfig(){
    }

    public EMRoomConfig(EMConferenceManager.EMConferenceType confrTyp,boolean isSupportMiniProgram,boolean isRecord,boolean isMergeRecord ,
                        String  nickName , String ext, int maxTalkerCount,int maxVideoCount,int maxAudienceCount){
         this.confrTyp = confrTyp;
         this.isSupportMiniProgram = isSupportMiniProgram;
         this.isRecord = isRecord;
         this.isMergeRecord = isMergeRecord;
         this.nickName = nickName;
         this.ext = ext;
         this.maxTalkerCount = maxTalkerCount;
         this.maxVideoCount = maxVideoCount;
         this.maxAudienceCount = maxAudienceCount;
    }

    public EMConferenceManager.EMConferenceType getConfrTyp() {
        return confrTyp;
    }

    public void setConfrTyp(EMConferenceManager.EMConferenceType confrTyp) {
        this.confrTyp = confrTyp;
    }

    public boolean isSupportMiniProgram() {
        return isSupportMiniProgram;
    }

    public void setSupportMiniProgram(boolean supportMiniProgram) {
        isSupportMiniProgram = supportMiniProgram;
    }

    public boolean isRecord() {
        return isRecord;
    }

    public void setRecord(boolean record) {
        isRecord = record;
    }

    public boolean isMergeRecord() {
        return isMergeRecord;
    }

    public void setMergeRecord(boolean mergeRecord) {
        isMergeRecord = mergeRecord;
    }
}
