package com.hyphenate.chat;

import android.support.annotation.Nullable;

/**
 * Created by lzan13 on 2017/8/17.
 *
 * \~chinese
 * 多人会议实体类，保存会议信息
 *
 * \~english
 * Multi person conference entity class, save conference information
 */
public class EMConference {

    private String pubNormalId = "";
    private String pubDesktopId = "";
    private String conferenceId = "";
    private String password = "";
    private String extension = "";
    private EMConferenceManager.EMConferenceType conferenceType;
    private EMConferenceManager.EMConferenceRole conferenceRole;
    private int memberNum;
    private String[] admins;
    private String[] speakers;
    private boolean isRecordOnServer = false;

    private int audienceTotal = 0;
    private String[] talkers;

    /**
     * \~chinese
     * 获取本地推送的流 id
     * @param type 流类型
     *
     * \~english
     * Get local publish stream id
     * @param type Stream type
     */
    public String getPubStreamId(EMConferenceStream.StreamType type){
        if (type == EMConferenceStream.StreamType.DESKTOP) {
            return pubDesktopId;
        }
        return pubNormalId;
    }

    /**
     * \~chinese
     * 设置本地推送的流 id
     * @param pubStreamId 流 Id
     * @param type 流类型
     *
     * \~english
     * Set local publish normal stream id
     * @param pubStreamId Stream id
     * @param type Stream type
     */
    public void setPubStreamId(String pubStreamId, EMConferenceStream.StreamType type) {
        if(type == EMConferenceStream.StreamType.NORMAL){
            pubNormalId = pubStreamId;
        }else if (type == EMConferenceStream.StreamType.DESKTOP) {
            pubDesktopId = pubStreamId;
        }
    }

    /**
     * \~chinese
     * 获取会议 ID
     *
     * \~english
     * Get conference id
     */
    public String getConferenceId() {
        return conferenceId;
    }

    /**
     * \~chinese
     * 设置会议 ID
     *
     * \~english
     * Set conference id
     */
    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    /**
     * \~chinese
     * 获取会议密码
     *
     * \~english
     * Get conference password
     */
    public String getPassword() {
        return password;
    }

    /**
     * \~chinese
     * 设置会议密码
     *
     * \~english
     * Set conference password
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * \~chinese
     * 获取会议扩展信息
     *
     * \~english
     * Get conference support information
     */
    public String getExtension() {
        return extension;
    }

    /**
     * \~chinese
     * 设置会议扩展信息
     *
     * \~english
     * Set conference support information
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /**
     * \~chinese
     * 获取当前会议的会议类型
     *
     * @return 可参考{@link EMConferenceManager.EMConferenceType}, 如果该值未设置，则返回null。
     *
     * \~english
     * Get the current conference type
     *
     * @return See {@link EMConferenceManager.EMConferenceType}, return null is this parameters not set.
     *
     */
    @Nullable
    public EMConferenceManager.EMConferenceType getConferenceType() {
        return conferenceType;
    }

    public void setConferenceType(EMConferenceManager.EMConferenceType type) {
        this.conferenceType = type;
    }

    /**
     * \~chinese
     *
     *
     * @return
     */
    @Nullable
    public EMConferenceManager.EMConferenceRole getConferenceRole() {
        return conferenceRole;
    }

    public void setConferenceRole(EMConferenceManager.EMConferenceRole role) {
        this.conferenceRole = role;
    }

    /**
     * \~chinese
     * 获取当前会议中成员总数（包含自己）
     *
     * @return
     *
     * \~english
     * Get the total members number in this conference.(includes self)
     *
     * @return
     */
    public int getMemberNum() {
        return memberNum;
    }

    public void setMemberNum(int memberNum) {
        this.memberNum = memberNum;
    }

    /**
     * \~chinese
     * 获取当前会议中的管理员列表
     *
     * @return 管理员列表，可能返回null
     *
     * \~english
     * Get the current conference admin array.
     *
     * @return admin array, may null.
     */
    @Nullable
    public String[] getAdmins() {
        return admins;
    }

    public void setAdmins(String[] admins) {
        this.admins = admins;
    }

    /**
     * \~chinese
     * 目前该参数不可用
     *
     * @return null
     *
     * \~english
     * Useless for current.
     *
     * @return null
     */
    @Nullable
    public String[] getSpeakers() {
        return speakers;
    }

    public void setSpeakers(String[] speakers) {
        this.speakers = speakers;
    }

    /**
     * \~chinese
     * 获取当前会议中是否在服务器端录制
     *
     * @return 是否在服务器端录制
     *
     * \~english
     * Get the current conference is recorded on server or not.
     *
     * @return whether record on server .
     */
    public boolean isRecordOnServer() {
        return isRecordOnServer;
    }

    public void setRecordOnServer(boolean recordOnServer) {
        isRecordOnServer = recordOnServer;
    }


    /**
     * 获取观众人数
     */
    public void setAudienceTotal(int count){
        audienceTotal = count;
    }

    public int getAudienceTotal(){
        return audienceTotal;
    }

    /**
     * 获取主播列表
     */
    public String[] getTalkers() {
        return talkers;
    }

    public void setTalkers(String[] talkers) {
        this.talkers = talkers;
    }


    /**
     * \~chinese
     * 会议结束时，重置会议信息
     *
     * \~english
     * Exit conference reset conference information
     */
    public void reset() {
        conferenceId = "";
        password = "";
        extension = "";
        conferenceType = null;
        conferenceRole = null;
        memberNum = 0;
        admins = null;
        speakers = null;
        audienceTotal = 0;
        talkers = null;
    }
}
