/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

public interface EMCallStateChangeListener {
    
	/**
	 * define the call state
	 * @author youni
	 *
	 */
	enum CallState{
		/**
		 * call in the idle state
		 */
		IDLE("idle"),
		/**
		 * indicate an incoming call 
		 */
		RINGING("ringing"),
		/**
		 * answering the incoming call
		 */
		ANSWERING("answering"),
		/**
		 * try to reach the peers
		 */
		CONNECTING("connecting"),
		/**
		 * the peers has gotten connected but the call was not accepted by the receiver
		 */
		CONNECTED("connected"),
		/**
		 * the receiver has accepted the call
		 */
		ACCEPTED("accepted"),
		/**
		 * two peers are disconnected
		 */
		DISCONNECTED("disconnected"),
		
		VOICE_PAUSE("voice_pause"),
        VOICE_RESUME("voice_resume"),
        VIDEO_PAUSE("video_pause"),
        VIDEO_RESUME("video_resume"),
        
        NETWORK_UNSTABLE("network_unstable"),
        NETWORK_NORMAL("network_normal"),
	    NETWORK_DISCONNECTED("network_disconnected");
		
		private final String state;
		CallState(String state){
			this.state = state;
		}
		
		@Override
	    public String toString()
	    {
	        return state;
	    }
	}
	
	/**
	 * define call error
	 * in most of cases, the error was set in disconnected state
	 * @author youni
	 *
	 */
	enum CallError{
		/**
		 * indicate there is no error happened
		 */
		ERROR_NONE("error_none"),
		
		/**
		 * indicate setting up connection to the peers is failed
		 */
		ERROR_TRANSPORT("error_transport"),
		
		/**
		 * indicate the peer is not available at the moment
		 */
		ERROR_UNAVAILABLE("error_unavailable"),
		
		/**
		 * indicate the peer has rejected this call
		 */
		REJECTED("rejected"),
		
		/**
		 * indicate the error of no response from the peer for sometime
		 */
		ERROR_NORESPONSE("error_noresponse"),
		
		/**
		 * indicate the remote peer is busy
		 */
		ERROR_BUSY("busy"),
		
		/**
         * indicate no call data
         */
        ERROR_NO_DATA("error_no_data"),
		
		ERROR_LOCAL_SDK_VERSION_OUTDATED("error_local_sdk_version_outdated"),
        ERROR_REMOTE_SDK_VERSION_OUTDATED("error_remote_sdk_version_outdated"),
        ERROR_SERVICE_NOT_ENABLE("error_service_not_enable"),
		ERROR_SERVICE_ARREARAGES("error_service_arrearages"),
		ERROR_SERVICE_FORBIDDEN("error_service_forbidden");


		private final String error;
		CallError(String error){
			this.error = error;
		}
		
		@Override
	    public String toString()
	    {
	        return error;
	    }
	}

	/**
	 * the client must add the call listener in the EMChatManager to get the call state in order to update UI
	 * @param callState
	 * @param error
	 */
	void onCallStateChanged(CallState callState, CallError error);
}
