/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMACallSession;

public class EMCallSession extends EMBase<EMACallSession> {
    public enum Type
    {
        VOICE,      //voice call
        VIDEO,      //video call
    }

    public enum ConnectType
    {
        NONE,       //Initial value
        DIRECT,     //direct
        RELAY,      //relay
    }

    public enum Status
    {
        DISCONNECTED,               //Disconnected, initial value
        RINGING,                    //Ringing
        //ANSWERING,                //Answering
        //PAUSING,                  //Pausing
        CONNECTING,                 //Connecting
        CONNECTED,                  //Connected
        ACCEPTED,                   //Accepted
    }

    public enum EndReason
    {
        HANGUP(0),                     //hang up
        NORESPONSE(1),                 //no response
        REJECT(2),                     //reject
        BUSY(3),                       //busy
        FAIL(4),                       //fail
        OFFLINE(5),
        SERVICE_NOT_ENABLE(101),
        SERVICE_ARREARAGES(102),
        SERVICE_FORBIDDEN(103);

        private int value;

        EndReason(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }

    }

    enum SessionInfoType{
        PAUSE_VOICE,
        RESUME_VOICE,
        PAUSE_VIDEO,
        RESUME_VIDEO,
    }

    EMCallSession() {
    }
    
    EMCallSession(EMACallSession emaObject) {
        this.emaObject = emaObject;
    }
    
    public String getCallId() {
        return emaObject.getCallId();
    }
    
    static EndReason getEndReason(int ordinal) {
        if (ordinal == EndReason.HANGUP.getValue()) {
            return EndReason.HANGUP;
        } else if (ordinal == EndReason.NORESPONSE.getValue()) {
            return EndReason.NORESPONSE;
        } else if (ordinal == EndReason.REJECT.getValue()) {
            return EndReason.REJECT;
        } else if (ordinal == EndReason.BUSY.getValue()) {
            return EndReason.BUSY;
        } else if (ordinal == EndReason.FAIL.getValue()){
            return EndReason.FAIL;
        } else if(ordinal == EndReason.SERVICE_NOT_ENABLE.getValue()) {
            return EndReason.SERVICE_NOT_ENABLE;
        } else if(ordinal == EndReason.SERVICE_ARREARAGES.getValue()) {
            return EndReason.SERVICE_ARREARAGES;
        } else if(ordinal == EndReason.SERVICE_FORBIDDEN.getValue()) {
            return EndReason.SERVICE_FORBIDDEN;
        } else {
            return EndReason.OFFLINE;
        }
    }
    
    static SessionInfoType getSessionInfoType(int type){
        SessionInfoType _type = SessionInfoType.RESUME_VOICE;
        switch (type) {    
        case 0:
            _type = SessionInfoType.PAUSE_VOICE;
            break;
        case 1:
            _type = SessionInfoType.RESUME_VOICE;
            break;
        case 2:
            _type = SessionInfoType.PAUSE_VIDEO;
            break;
        case 3:
            _type = SessionInfoType.RESUME_VIDEO;
            break;

        default:
            break;
        }
        return _type;
    }
    
    public Type getType() {
        EMACallSession.Type type = this.emaObject.getType();
        switch (type) {
        case VOICE:
            return Type.VOICE;
        default:
            return Type.VIDEO;
        }
    }
    
    public ConnectType getConnectType() {
        EMACallSession.ConnectType type = this.emaObject.getConnectType();
        switch (type) {
        case DIRECT:
            return ConnectType.DIRECT;
        case RELAY:
            return ConnectType.RELAY;
        default:
            return ConnectType.NONE;
        }
    }
    
    String password() {
        return "12345678";
    }
    
    public String getRemoteName() {
        return this.emaObject.getRemoteName();
    }
    
    public String getExt() {
        return this.emaObject.getExt();
    }
    
    public String getLocalName() {
        return emaObject.getLocalName();
    }

    public String getServerRecordId() {return  emaObject.getServerRecordId(); }

    public boolean isRecordOnServer() { return  emaObject.isRecordOnServer(); }

//    public boolean isMergeStream() { return  emaObject.isMergeStream(); }
}
