/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sdk;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import android.view.WindowManager;
import com.superrtc.AudioSource;
import com.superrtc.AudioTrack;
import com.superrtc.Camera1Enumerator;
import com.superrtc.CameraEnumerator;
import com.superrtc.CameraVideoCapturer;
import com.superrtc.DataChannel;
import com.superrtc.DefaultVideoDecoderFactory;
import com.superrtc.DefaultVideoEncoderFactory;
import com.superrtc.EglBase;
import com.superrtc.ICameraInterface;
import com.superrtc.IceCandidate;
import com.superrtc.JavaI420Buffer;
import com.superrtc.Logging;
import com.superrtc.MediaConstraints;
import com.superrtc.MediaStream;
import com.superrtc.MediaStreamTrack;
import com.superrtc.NV21Buffer;
import com.superrtc.PeerConnection;
import com.superrtc.PeerConnectionFactory;
import com.superrtc.RendererCommon;
import com.superrtc.RtpParameters;
import com.superrtc.RtpReceiver;
import com.superrtc.RtpSender;
import com.superrtc.RtpTransceiver;
import com.superrtc.ScreenCapturerAndroid;
import com.superrtc.SdpObserver;
import com.superrtc.SessionDescription;
import com.superrtc.SoftwareVideoDecoderFactory;
import com.superrtc.SoftwareVideoEncoderFactory;
import com.superrtc.StatsReport;
import com.superrtc.SurfaceTextureHelper;
import com.superrtc.SurfaceViewRenderer;
import com.superrtc.VideoCapturer;
import com.superrtc.VideoDecoderFactory;
import com.superrtc.VideoEncoderFactory;
import com.superrtc.VideoFrame;
import com.superrtc.VideoSink;
import com.superrtc.VideoSource;
import com.superrtc.VideoTrack;
import com.superrtc.audio.AudioDeviceModule;
import com.superrtc.audio.JavaAudioDeviceModule;
import com.superrtc.externalInputAudio.ExternalInputAudioSourceWrapper;
import com.superrtc.mediamanager.RtcConnectionExt;
import com.superrtc.reporter.RtcReporterManager;
import com.superrtc.sdk.ALog;
import com.superrtc.sdk.Bandwidth;
import com.superrtc.sdk.Packetslostrate;
import com.superrtc.sdk.RtcListener;
import com.superrtc.sdk.SDPSsrcChanger;
import com.superrtc.util.CpuMonitor;
import com.superrtc.util.ExternalVideoCapturer;
import com.superrtc.util.LooperExecutor;
import com.superrtc.util.RTCCallback;
import com.superrtc.util.RtcEventLog;
import com.superrtc.watermark.Watermark;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class RtcConnection {
    public static final String VIDEO_TRACK_ID = "ARDAMSv0";
    public static final String AUDIO_TRACK_ID = "ARDAMSa0";
    public static final String VIDEO_TRACK_TYPE = "video";
    public static final String AUDIO_TRACK_TYPE = "audio";
    private static final String TAG = "RtcConnection:";
    private static final String VIDEO_CODEC_VP8 = "VP8";
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private static final String VIDEO_CODEC_H264 = "H264";
    private static final String VIDEO_CODEC_H264_BASELINE = "H264 Baseline";
    private static final String VIDEO_CODEC_H264_HIGH = "H264 High";
    private static final String AUDIO_CODEC_OPUS = "opus";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-start-bitrate";
    private static final String VIDEO_FLEXFEC_FIELDTRIAL = "WebRTC-FlexFEC-03-Advertised/Enabled/WebRTC-FlexFEC-03/Enabled/";
    private static final String VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL = "WebRTC-IntelVP8/Enabled/";
    private static final String DISABLE_WEBRTC_AGC_FIELDTRIAL = "WebRTC-Audio-MinimizeResamplingOnMobile/Enabled/";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final int HD_VIDEO_WIDTH = 640;
    private static final int HD_VIDEO_HEIGHT = 480;
    private static final int BPS_IN_KBPS = 1000;
    private static final String RTCEVENTLOG_OUTPUT_DIR_NAME = "rtc_event_log";
    private final PCObserver pcObserver = new PCObserver();
    private final SDPObserver sdpObserver = new SDPObserver();
    private final Timer statsTimer = new Timer();
    private static EglBase rootEglBase;
    private static Context appContext;
    private PeerConnectionEvents events;
    private Watermark watermark = null;
    private RtcConnectionParameters peerConnectionParameters = new RtcConnectionParameters();
    private boolean isHangup = false;
    @Nullable
    private static PeerConnectionFactory factory;
    @Nullable
    private PeerConnection peerConnection;
    @Nullable
    private AudioSource audioSource;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private VideoSource videoSource;
    private boolean videoCapturerStopped;
    private static boolean isError;
    private int videoWidth;
    private int videoHeight;
    private int videoFps;
    private MediaConstraints audioConstraints;
    private MediaConstraints sdpMediaConstraints;
    @Nullable
    private List<IceCandidate> queuedRemoteCandidates;
    private boolean isInitiator;
    @Nullable
    private SessionDescription localSdp;
    @Nullable
    private VideoCapturer videoCapturer;
    private boolean renderVideo = true;
    @Nullable
    private VideoTrack localVideoTrack;
    @Nullable
    private VideoTrack remoteVideoTrack;
    @Nullable
    private RtpSender localVideoSender;
    private boolean enableLocalAudio = true;
    @Nullable
    private AudioTrack localAudioTrack;
    @Nullable
    private AudioTrack remoteAudioTrack;
    @Nullable
    private DataChannel dataChannel;
    private boolean dataChannelEnabled;
    @Nullable
    private RtcEventLog rtcEventLog;
    private static MIRROR mirrorType;
    private int configRotation = 0;
    private boolean isForPub = false;
    private static int DEFAULT_CONFIG_MINKBPS;
    public static final String RtcKVIceServersArray = "iceServers";
    public static final String RtcConstStringURL = "url";
    public static final String RtcConstStringUserName = "username";
    public static final String RtcConstStringCredential = "credential";
    public static final String RtcKVCaptureVideoBoolean = "capVideo";
    public static final String RtcKVRecvVideoBoolean = "recvVideo";
    public static final String RtcKVCaptureAudioBoolean = "capAudio";
    public static final String RtcKVRecvAudioBoolean = "recvAudio";
    public static final String RtcCustomVideoSourceBoolean = "customVideoSrc";
    public static final String RtcKVRelayOnlyBoolean = "relayOnly";
    public static final String RtcKVVideoResolutionLevelLong = "vresL";
    public static final String RtcKVMaxVideoKbpsLong = "maxVKbps";
    public static final String RtcKVRelayVideoKbpsLong = "relayVKbps";
    public static final String RtcKVMaxAudioKbpsLong = "maxAKbps";
    public static final String RtcKVRelayAudioKbpsLong = "relayAKbps";
    public static final String RtcvideofpsLong = "videofps";
    public static final String RtcvideowidthLong = "width";
    public static final String RtcvideoheigthLong = "heigth";
    public static final String RtcKVPreferVCodecString = "prefVC";
    public static final String RtcKVPreferACodecString = "prefAC";
    public static final String RtcKVDisablePranswerBoolean = "disablePranswer";
    public static final String RtcKVLoopbackBoolean = "loopback";
    public static final String RtcKVAecDumpFileString = "aecdumpFile";
    public static final String RtcConstStringVP8 = "VP8";
    public static final String RtcConstStringVP9 = "VP9";
    public static final String RtcConstStringH264 = "H264";
    public static final String RtcConstStringOPUS = "OPUS";
    public static final String RtcConstStringG722 = "G722";
    private static LooperExecutor executor;
    private static LogListener sLogListener;
    public static int minVideoKbps;
    public static int loglevel;
    public String name = "RTC0";
    public String streamId = "";
    public String pubStreamId = "";
    public SurfaceViewRenderer localRender;
    public SurfaceViewRenderer remoteRender;
    private boolean isConnected = false;
    private ProxyVideoSink remoteProxyVideoSink = new ProxyVideoSink();
    private ProxyVideoSink localProxyVideoSink = new ProxyVideoSink();
    private final List<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
    private long localSeq = 0L;
    private int defaultCameraFacing = 1;
    private boolean enableLocalViewMirror = false;
    private Intent mediaProjectionPermissionResultData;
    private boolean localEnableDTX = false;
    private boolean remoteEnableDTX = false;
    private SDPSsrcChanger ssrcChanger = new SDPSsrcChanger("ARDAMS");
    private boolean isPranswerState;
    private LinkedList<SessionDescription> pendingSdp = new LinkedList();
    private RtpSender localAudioSender;
    private boolean enableaec = true;
    private boolean enableagc = true;
    private boolean enablens = true;
    private static int audioSampleRate;
    private static int callAudioSource;
    private static String globalVideoCodec;
    private static boolean useStereoInput;
    private static boolean use2channels;
    private String lastErrorMsg;
    private RtpReceiver audioReceiver = null;
    private CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        @Override
        public void onCameraError(String string) {
            sLogListener.onLog(loglevel, "RtcConnection:onCameraError: " + string);
            if (rtcListener != null) {
                rtcListener.onError(RtcListener.RTCError.OPEN_CAMERA_FAIL);
            }
        }

        @Override
        public void onCameraDisconnected() {
            sLogListener.onLog(loglevel, "RtcConnection:onCameraDisconnected");
        }

        @Override
        public void onCameraFreezed(String string) {
            sLogListener.onLog(loglevel, "RtcConnection:onCameraFreezed");
        }

        @Override
        public void onCameraOpening(String string) {
            sLogListener.onLog(loglevel, "RtcConnection:onCameraOpening");
        }

        @Override
        public void onFirstFrameAvailable() {
            sLogListener.onLog(loglevel, "RtcConnection:onFirstFrameAvailable");
            RtcReporterManager.getInstance().notifyInitVideoArgs(RtcConnection.this, RtcConnection.this.videoWidth, RtcConnection.this.videoHeight, RtcConnection.this.videoFps);
        }

        @Override
        public void onCameraClosed() {
            sLogListener.onLog(loglevel, "RtcConnection:onCameraClosed");
        }
    };
    private static JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback;
    private static RtcListener rtcListener;
    private static final String STAT_KEY_CONNECTION = "connection";
    private Bandwidth remoteVideoBW = new Bandwidth();
    private Bandwidth remoteAudioBW = new Bandwidth();
    private Bandwidth localVideoBW = new Bandwidth();
    private Bandwidth localAudioBW = new Bandwidth();
    private Packetslostrate packetslostrate = new Packetslostrate();
    private Packetslostrate recvpacketslostrate = new Packetslostrate();
    private String connectType = "disconn";
    private String lusevcodectype = "VP8";
    private String luseacodectype = "OPUS";
    private String rusevcodectype = "VP8";
    private String ruseacodectype = "OPUS";
    private int framesReceived = 0;
    private int videolastsendpackets = 0;
    private int videocursendpackets = 0;
    private int audiolastsendpackets = 0;
    private int audiocursendpackets = 0;
    private int videosendbytes = 0;
    private int videorecvbytes = 0;
    private int audiosendbytes = 0;
    private int audiorecvbytes = 0;
    private int videolastsendpacketsLost = 0;
    private int videocursendpacketsLost = 0;
    private int audiolastsendpacketsLost = 0;
    private int audiocursendpacketsLost = 0;
    private int videolastrecvpackets = 0;
    private int videocurrecvpackets = 0;
    private int audiolastrecvpackets = 0;
    private int audiocurrecvpackets = 0;
    private int videolastrecvpacketsLost = 0;
    private int videocurrecvpacketsLost = 0;
    private int audiolastrecvpacketsLost = 0;
    private int audiocurrecvpacketsLost = 0;
    private CpuMonitor cpuMonitor;

    @Deprecated
    public RtcConnection(String string) {
        this(string, null);
    }

    public RtcConnection(String string, PeerConnectionEvents peerConnectionEvents) {
        this.name = string;
        this.events = peerConnectionEvents;
        this.isHangup = false;
        this.enableStatsEvents(true, 2000);
        sLogListener.onLog(loglevel, string + "::: [rapi]++ RtcConnection constructor");
        if (CpuMonitor.isSupported()) {
            this.cpuMonitor = new CpuMonitor(appContext);
        }
        executor.execute(() -> sLogListener.onLog(loglevel, string + "::: [rapi]-- RtcConnection constructor"));
    }

    public static void setLocalVideoViewMirror(MIRROR mIRROR) {
        mirrorType = mIRROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void callbackLog(int n, String string) {
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            sLogListener.onLog(n, "[rtc-native] " + string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void createPeerConnection(boolean bl) {
        this.isInitiator = bl;
        sLogListener.onLog(loglevel, this.name + "::: createPeerConnection, isInitiator => " + this.isInitiator);
        boolean bl2 = this.peerConnectionParameters.videoCallEnabled = this.peerConnectionParameters.captureVideo || this.peerConnectionParameters.shareScreen || this.peerConnectionParameters.enableExternalVideoData;
        if (!TextUtils.isEmpty((CharSequence)globalVideoCodec)) {
            this.peerConnectionParameters.videoCodec = globalVideoCodec;
        }
        try {
            this.createMediaConstraintsInternal();
            this.createPeerConnectionInternal();
            this.maybeCreateAndStartRtcEventLog();
        }
        catch (Exception exception) {
            this.reportError("Failed to create peer connection: " + exception.getMessage());
            throw exception;
        }
    }

    private static void createPeerConnectionFactoryInternal(PeerConnectionFactory.Options options, boolean bl) {
        VideoDecoderFactory videoDecoderFactory;
        VideoEncoderFactory videoEncoderFactory;
        AudioDeviceModule audioDeviceModule = RtcConnection.createJavaAudioDevice();
        if (bl) {
            videoEncoderFactory = new DefaultVideoEncoderFactory(rootEglBase.getEglBaseContext(), true, true);
            videoDecoderFactory = new DefaultVideoDecoderFactory(rootEglBase.getEglBaseContext());
        } else {
            videoEncoderFactory = new SoftwareVideoEncoderFactory();
            videoDecoderFactory = new SoftwareVideoDecoderFactory();
        }
        factory = PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule(audioDeviceModule).setVideoEncoderFactory(videoEncoderFactory).setVideoDecoderFactory(videoDecoderFactory).createPeerConnectionFactory();
        audioDeviceModule.release();
    }

    private static AudioDeviceModule createJavaAudioDevice() {
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback = new JavaAudioDeviceModule.AudioTrackErrorCallback(){

            @Override
            public void onWebRtcAudioTrackInitError(String string) {
                sLogListener.onLog(loglevel, "::: onWebRtcAudioTrackInitError: " + string);
            }

            @Override
            public void onWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode audioTrackStartErrorCode, String string) {
                sLogListener.onLog(loglevel, "::: onWebRtcAudioTrackStartError: " + (Object)((Object)audioTrackStartErrorCode) + ". " + string);
            }

            @Override
            public void onWebRtcAudioTrackError(String string) {
                sLogListener.onLog(loglevel, "::: onWebRtcAudioTrackError: " + string);
            }
        };
        JavaAudioDeviceModule.Builder builder = JavaAudioDeviceModule.builder(appContext).setUseHardwareAcousticEchoCanceler(false).setUseHardwareNoiseSuppressor(true).setAudioRecordErrorCallback(audioRecordErrorCallback).setAudioTrackErrorCallback(audioTrackErrorCallback);
        if (audioSampleRate > 0) {
            builder.setSampleRate(audioSampleRate);
        }
        if (callAudioSource != -1) {
            builder.setAudioSource(callAudioSource);
        }
        if (useStereoInput) {
            builder.setUseStereoInput(true);
        }
        if (use2channels) {
            builder.setUse2channelsInput(use2channels);
        }
        return builder.createAudioDeviceModule();
    }

    private void createMediaConstraintsInternal() {
        sLogListener.onLog(loglevel, this.name + "::: createMediaConstraintsInternal");
        if (this.peerConnectionParameters.videoCallEnabled) {
            this.videoWidth = this.peerConnectionParameters.videoWidth;
            this.videoHeight = this.peerConnectionParameters.videoHeight;
            this.videoFps = this.peerConnectionParameters.videoFps;
            if (this.videoWidth == 0 || this.videoHeight == 0) {
                this.videoWidth = 640;
                this.videoHeight = 480;
            }
            if (this.videoFps == 0) {
                this.videoFps = 15;
            }
            sLogListener.onLog(loglevel, this.name + "::: Video capturing format: " + this.videoWidth + "x" + this.videoHeight + "@" + this.videoFps);
        }
        this.audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.noAudioProcessing) {
            Log.i((String)TAG, (String)"Disabling audio processing");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        if (!this.enableaec) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio AEC");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
        }
        if (!this.enableagc) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio AGC");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
        }
        if (!this.enablens) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio NS");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        sLogListener.onLog(loglevel, this.name + "::: Audio constraints: " + this.audioConstraints.toString());
        this.sdpMediaConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.loopback || this.peerConnectionParameters.receiveAudio) {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        } else {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "false"));
        }
        if (this.peerConnectionParameters.loopback || this.peerConnectionParameters.receiveVideo) {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
        } else {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "false"));
        }
        sLogListener.onLog(loglevel, this.name + "::: Sdp media constraints: " + this.sdpMediaConstraints.toString());
    }

    private void createPeerConnectionInternal() {
        DataChannel.Init init;
        sLogListener.onLog(loglevel, this.name + "::: createMediaConstraintsInternal");
        if (factory == null || this.checkError()) {
            sLogListener.onLog(loglevel, this.name + "::: Peerconnection factory is not created, factory=" + factory);
            return;
        }
        this.queuedRemoteCandidates = new ArrayList<IceCandidate>();
        PeerConnection.RTCConfiguration rTCConfiguration = new PeerConnection.RTCConfiguration(this.iceServers);
        rTCConfiguration.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
        rTCConfiguration.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rTCConfiguration.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        rTCConfiguration.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
        rTCConfiguration.keyType = PeerConnection.KeyType.ECDSA;
        rTCConfiguration.enableDtlsSrtp = !this.peerConnectionParameters.loopback;
        rTCConfiguration.sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
        if (this.peerConnectionParameters.enableRelay) {
            rTCConfiguration.iceTransportsType = PeerConnection.IceTransportsType.RELAY;
        }
        this.peerConnection = factory.createPeerConnection(rTCConfiguration, (PeerConnection.Observer)this.pcObserver);
        if (this.dataChannelEnabled) {
            init = new DataChannel.Init();
            init.ordered = this.peerConnectionParameters.dataChannelParameters.ordered;
            init.negotiated = this.peerConnectionParameters.dataChannelParameters.negotiated;
            init.maxRetransmits = this.peerConnectionParameters.dataChannelParameters.maxRetransmits;
            init.maxRetransmitTimeMs = this.peerConnectionParameters.dataChannelParameters.maxRetransmitTimeMs;
            init.id = this.peerConnectionParameters.dataChannelParameters.id;
            init.protocol = this.peerConnectionParameters.dataChannelParameters.protocol;
            this.dataChannel = this.peerConnection.createDataChannel("ApprtcDemo data", init);
        }
        Logging.enableLogToDebugOutput(Logging.Severity.LS_ERROR);
        if (!TextUtils.isEmpty((CharSequence)this.peerConnectionParameters.aecDumpFileName)) {
            sLogListener.onLog(loglevel, this.name + "::: Start aec dump: " + this.peerConnectionParameters.aecDumpFileName);
            try {
                init = ParcelFileDescriptor.open((File)new File(this.peerConnectionParameters.aecDumpFileName), (int)0x3C000000);
                factory.startAecDump(init.detachFd(), -1);
            }
            catch (IOException iOException) {
                Log.e((String)TAG, (String)"Can not open aecdump file", (Throwable)iOException);
            }
        }
        sLogListener.onLog(loglevel, this.name + "::: createMediaConstraintsInternal finish");
    }

    private void checkMediaTracksInternal() {
        if (this.peerConnection == null) {
            this.reportError("Call to add or remove media tracks, but no peerConnection exists.");
            return;
        }
        List<String> list = Collections.singletonList("ARDAMS");
        sLogListener.onLog(loglevel, this.name + "::: Add audio track.");
        this.peerConnection.addTrack(this.createAudioTrack(), list);
        this.findAudioSender();
        if (this.peerConnectionParameters.videoCallEnabled) {
            if (this.peerConnectionParameters.enableExternalVideoData) {
                sLogListener.onLog(loglevel, this.name + "::: Add external video capture.");
                this.videoCapturer = new ExternalVideoCapturer();
            } else if (this.peerConnectionParameters.shareScreen) {
                sLogListener.onLog(loglevel, this.name + "::: Add screen share capture.");
                this.changeResolution();
                this.videoCapturer = this.createScreenCapturer();
            } else if (this.peerConnectionParameters.captureVideo) {
                sLogListener.onLog(loglevel, this.name + "::: Add camera capture.");
                this.videoCapturer = this.createCameraCapturer(new Camera1Enumerator(true));
            }
            if (this.videoCapturer == null) {
                sLogListener.onLog(loglevel, this.name + "::: Video capturer create failed. Switch to audio only call.");
                this.peerConnectionParameters.videoCallEnabled = false;
            } else {
                if (this.configRotation != 0) {
                    this.videoCapturer.setRotation(this.configRotation);
                }
                this.peerConnection.addTrack(this.createVideoTrack(this.videoCapturer), list);
                this.findVideoSender();
                this.setVideoMinBitrate(DEFAULT_CONFIG_MINKBPS);
            }
        } else if (!this.peerConnectionParameters.captureVideo && this.localVideoSender != null) {
            sLogListener.onLog(loglevel, this.name + "::: Video track already exists, remove it.");
            this.peerConnection.removeTrack(this.localVideoSender);
            this.localVideoSender = null;
            if (this.localVideoTrack != null) {
                this.localVideoTrack.dispose();
                this.localVideoTrack = null;
            }
            if (this.videoSource != null) {
                this.videoSource.dispose();
                this.videoSource = null;
            }
        }
    }

    public void setIsForPub(boolean bl) {
        this.isForPub = bl;
    }

    public boolean getIsForPub() {
        return this.isForPub;
    }

    private File createRtcEventLogOutputFile() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_hhmm_ss", Locale.getDefault());
        Date date = new Date();
        String string = "event_log_" + simpleDateFormat.format(date) + ".log";
        return new File(appContext.getDir(RTCEVENTLOG_OUTPUT_DIR_NAME, 0), string);
    }

    private void maybeCreateAndStartRtcEventLog() {
        sLogListener.onLog(loglevel, this.name + "::: maybeCreateAndStartRtcEventLog");
        if (appContext == null || this.peerConnection == null) {
            return;
        }
        if (!this.peerConnectionParameters.enableRtcEventLog) {
            sLogListener.onLog(loglevel, this.name + "::: RtcEventLog is disabled.");
            return;
        }
        this.rtcEventLog = new RtcEventLog(this.peerConnection);
        File file = this.createRtcEventLogOutputFile();
        this.rtcEventLog.start(file);
        sLogListener.onLog(loglevel, this.name + "::: Start record the rtc event log to " + file.getAbsolutePath());
    }

    private void closeInternal() {
        if (this.isHangup) {
            sLogListener.onLog(loglevel, this.name + "::: peer isHangup : " + this.isHangup);
            return;
        }
        isError = false;
        this.isHangup = true;
        if (factory != null && !TextUtils.isEmpty((CharSequence)this.peerConnectionParameters.aecDumpFileName)) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, stopAecDump");
            factory.stopAecDump();
        }
        this.statsTimer.cancel();
        if (this.dataChannel != null) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, close dataChannel");
            this.dataChannel.dispose();
            this.dataChannel = null;
        }
        if (this.rtcEventLog != null) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, stop rtcEventLog");
            this.rtcEventLog.stop();
            this.rtcEventLog = null;
        }
        if (this.peerConnection != null) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, close peerConnection");
            this.peerConnection.dispose();
            this.peerConnection = null;
        }
        if (this.audioSource != null) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, close audioSource");
            this.audioSource.dispose();
            this.audioSource = null;
        }
        if (this.videoCapturer != null) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, stop videoCapturer");
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            this.videoCapturerStopped = true;
            this.videoCapturer.dispose();
            this.videoCapturer = null;
        }
        if (this.videoSource != null) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, stop videoSource");
            this.videoSource.dispose();
            this.videoSource = null;
        }
        if (this.surfaceTextureHelper != null) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, stop surfaceTextureHelper");
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        this.localProxyVideoSink.setTarget(null);
        this.localProxyVideoSink = null;
        this.remoteProxyVideoSink.setTarget(null);
        this.remoteProxyVideoSink = null;
        if (this.localRender != null) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, stop localRender");
            this.localRender.release();
            this.localRender = null;
        }
        if (this.remoteRender != null) {
            sLogListener.onLog(loglevel, this.name + "::: closeInternal, stop remoteRender");
            this.remoteRender.release();
            this.remoteRender = null;
        }
        sLogListener.onLog(loglevel, this.name + "::: closeInternal, report onPeerConnectionClosed");
        this.events.onPeerConnectionClosed(this);
        this.releaseExternalAudio();
        this.isConnected = false;
    }

    public boolean isHDVideo() {
        return this.peerConnectionParameters.videoCallEnabled && this.videoWidth * this.videoHeight >= 921600;
    }

    private void getStats() {
        if (this.peerConnection == null || this.checkError() || this.isHangup) {
            return;
        }
        boolean bl = this.peerConnection.getStats(statsReportArray -> {
            this.events.onPeerConnectionStatsReady(this, this.convert(statsReportArray));
            RtcReporterManager.getInstance().notifyStatsReport(this, statsReportArray);
        }, null);
        if (!bl) {
            Log.e((String)TAG, (String)"getStats() returns false!");
        }
    }

    public void enableStatsEvents(boolean bl, int n) {
        if (bl) {
            try {
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        RtcConnection.this.getStats();
                    }
                }, 0L, (long)n);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Can not schedule statistics timer", (Throwable)exception);
            }
        } else {
            this.statsTimer.cancel();
        }
    }

    public void setMute(boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setMute: " + bl);
        executor.execute(() -> {
            boolean bl2 = this.enableLocalAudio = !bl;
            if (this.localAudioTrack != null) {
                this.localAudioTrack.setEnabled(this.enableLocalAudio);
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setMute: ");
                RtcReporterManager.getInstance().notifySetMute(this, bl, this.enableLocalAudio ? 1 : 0);
            } else {
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setMute but localAudioTrack is null.");
                RtcReporterManager.getInstance().notifySetMute(this, bl, -1);
            }
        });
    }

    public void muteRemoteAudio(boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ muteRemoteAudio: " + bl);
        executor.execute(() -> {
            if (this.remoteAudioTrack != null) {
                this.remoteAudioTrack.setEnabled(!bl);
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- muteRemoteAudio: ");
            } else {
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- muteRemoteAudio but remoteAudioTrack is null.");
            }
        });
    }

    public void muteRemoteVideo(boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ muteRemoteVideo: " + bl);
        executor.execute(() -> {
            if (this.remoteVideoTrack != null) {
                this.remoteVideoTrack.setEnabled(!bl);
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- muteRemoteVideo: ");
            } else {
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- muteRemoteVideo but remoteVideoTrack is null.");
            }
        });
    }

    public void setVideoEnabled(boolean bl) {
        executor.execute(() -> {
            this.renderVideo = bl;
            if (this.localVideoTrack != null) {
                this.localVideoTrack.setEnabled(this.renderVideo);
            }
            if (this.remoteVideoTrack != null) {
                this.remoteVideoTrack.setEnabled(this.renderVideo);
            }
        });
    }

    public void createOffer() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ createOffer");
        executor.execute(() -> {
            if (!this.checkError()) {
                if (this.isHangup) {
                    sLogListener.onLog(loglevel, this.name + "::: skip createOffer because of conn is already hangup!");
                    return;
                }
                this.createPeerConnection(true);
                if (this.peerConnection == null) {
                    this.reportError("PeerConnection create failed.");
                    return;
                }
                this.checkMediaTracksInternal();
                this.peerConnection.createOffer(this.sdpObserver, this.sdpMediaConstraints);
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- createOffer finish with constraints: " + this.sdpMediaConstraints);
            }
        });
    }

    public void createAnswer() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ createAnswer");
        executor.execute(() -> {
            if (this.peerConnection != null && !this.checkError()) {
                this.isPranswerState = false;
                this.checkMediaTracksInternal();
                this.peerConnection.createAnswer(this.sdpObserver, this.sdpMediaConstraints);
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- createAnswer finish with constraints: " + this.sdpMediaConstraints);
            }
        });
    }

    public void addRemoteIceCandidate(String string) throws Exception {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ addRemoteIceCandidate: " + string);
        RtcContent rtcContent = RtcContent.fromJson(string);
        IceCandidate iceCandidate = RtcConnection.content2Candidate(rtcContent);
        if (iceCandidate == null) {
            return;
        }
        executor.execute(() -> {
            this.addRemoteIceCandidateInternal(iceCandidate);
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- addRemoteIceCandidate: ");
        });
    }

    private void addRemoteIceCandidateInternal(IceCandidate iceCandidate) {
        if (this.peerConnection != null && !this.checkError()) {
            if (this.queuedRemoteCandidates != null) {
                this.queuedRemoteCandidates.add(iceCandidate);
            } else {
                this.peerConnection.addIceCandidate(iceCandidate);
            }
        }
    }

    public void removeRemoteIceCandidates(IceCandidate[] iceCandidateArray) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ removeRemoteIceCandidates: ");
        executor.execute(() -> {
            if (this.peerConnection == null || this.checkError()) {
                return;
            }
            this.drainCandidates();
            this.peerConnection.removeIceCandidates(iceCandidateArray);
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- removeRemoteIceCandidates: ");
        });
    }

    public void setRemoteDescription(String string) throws JSONException {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setRemoteDescription: " + string);
        RtcContent rtcContent = RtcContent.fromJson(string);
        SessionDescription sessionDescription = RtcConnection.content2Sdp(rtcContent);
        if (sessionDescription == null) {
            return;
        }
        executor.execute(() -> {
            this.setRemoteDescriptionInternal(sessionDescription);
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setRemoteDescription: ");
        });
    }

    private void setRemoteDescriptionInternal(SessionDescription sessionDescription) {
        if (this.peerConnection == null || this.checkError()) {
            return;
        }
        String string = sessionDescription.description;
        string = RtcConnection.preferCodec(string, this.peerConnectionParameters.audioCodec, true);
        string = RtcConnection.preferCodec(string, RtcConnection.getSdpVideoCodecName(this.peerConnectionParameters), false);
        if (this.peerConnectionParameters.audioStartBitrate > 0) {
            string = RtcConnection.setStartBitrate(AUDIO_CODEC_OPUS, false, string, this.peerConnectionParameters.audioStartBitrate);
        }
        string = this.filterRemoteSDP(string);
        SessionDescription sessionDescription2 = new SessionDescription(sessionDescription.type, string);
        this.peerConnection.setRemoteDescription(this.sdpObserver, sessionDescription2);
    }

    private void processPendingSdpInternal() {
        SessionDescription sessionDescription;
        while ((sessionDescription = this.removePendingSdp()) != null) {
            if (sessionDescription.type == SessionDescription.Type.OFFER) {
                if (this.isInitiator) {
                    sLogListener.onLog(loglevel, this.name + "::: Got sdp offer but isInitiator, drop it");
                    continue;
                }
                if (this.peerConnection == null) {
                    this.createPeerConnection(false);
                }
                if (this.peerConnection == null) {
                    this.reportError("PeerConnection create failed.");
                    return;
                }
                if (this.peerConnection.signalingState() == PeerConnection.SignalingState.STABLE) {
                    if (this.peerConnection.getRemoteDescription() == null) {
                        this.isPranswerState = true;
                        this.setRemoteDescriptionInternal(sessionDescription);
                        sLogListener.onLog(loglevel, this.name + "::: create PRANSWER : sdpMediaConstraints=" + this.sdpMediaConstraints);
                        this.peerConnection.createAnswer(this.sdpObserver, this.sdpMediaConstraints);
                        continue;
                    }
                    this.isPranswerState = false;
                    this.setRemoteDescriptionInternal(sessionDescription);
                    Log.i((String)TAG, (String)(this.name + "::: Create ANSWER : sdpMediaConstraints=" + this.sdpMediaConstraints));
                    this.peerConnection.createAnswer(this.sdpObserver, this.sdpMediaConstraints);
                    continue;
                }
                sLogListener.onLog(loglevel, this.name + "::: Got offer at wrong state " + (Object)((Object)this.peerConnection.signalingState()));
                continue;
            }
            if (sessionDescription.type == SessionDescription.Type.PRANSWER || sessionDescription.type == SessionDescription.Type.ANSWER) {
                if (!this.isInitiator) {
                    sLogListener.onLog(loglevel, this.name + "::: Got " + (Object)((Object)sessionDescription.type) + " but NOT isInitiator, drop it " + this.isInitiator);
                    continue;
                }
                if (this.peerConnection == null) {
                    sLogListener.onLog(loglevel, this.name + "::: Got " + (Object)((Object)sessionDescription.type) + " but NOT pc null, drop it");
                    continue;
                }
                if (this.peerConnection.signalingState() == PeerConnection.SignalingState.HAVE_LOCAL_OFFER || this.peerConnection.signalingState() == PeerConnection.SignalingState.HAVE_REMOTE_PRANSWER) {
                    this.setRemoteDescriptionInternal(sessionDescription);
                    continue;
                }
                sLogListener.onLog(loglevel, this.name + "::: Got " + (Object)((Object)sessionDescription.type) + " at wrong state " + (Object)((Object)this.peerConnection.signalingState()));
                continue;
            }
            sLogListener.onLog(loglevel, this.name + "::: Unknown sdp type " + (Object)((Object)sessionDescription.type));
        }
    }

    public void stopCapture() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ stopCapture");
        executor.execute(() -> {
            if (this.videoCapturer != null && !this.videoCapturerStopped) {
                try {
                    this.videoCapturer.stopCapture();
                }
                catch (InterruptedException interruptedException) {
                    sLogListener.onLog(loglevel, this.name + "::: [rapi]-- stopCapture error: " + interruptedException.getMessage());
                }
            }
            this.videoCapturerStopped = true;
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- stopCapture");
            RtcReporterManager.getInstance().notifyStopCapture(this, this.videoCapturerStopped);
        });
    }

    public void startCapture() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ startCapture, videoCapturer=" + this.videoCapturer + ", videoCapturerStopped=" + this.videoCapturerStopped);
        executor.execute(() -> {
            if (this.videoCapturer != null && this.videoCapturerStopped) {
                this.videoCapturer.startCapture(this.videoWidth, this.videoHeight, this.videoFps);
            }
            this.videoCapturerStopped = false;
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- startCapture");
            RtcReporterManager.getInstance().notifyStartCapture(this, this.videoCapturerStopped);
        });
    }

    public void setVideoMaxBitrate(@Nullable Integer n) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setVideoMaxBitrate: " + n);
        executor.execute(() -> {
            if (this.peerConnection == null || this.localVideoSender == null || this.checkError()) {
                sLogListener.onLog(loglevel, this.name + "::: setVideoMaxBitrate, something error, peerConnection=" + this.peerConnection + ", localVideoSender=" + this.localVideoSender);
                return;
            }
            RtpParameters rtpParameters = this.localVideoSender.getParameters();
            if (rtpParameters.encodings.size() == 0) {
                sLogListener.onLog(loglevel, this.name + "::: setVideoMaxBitrate, RtpParameters are not ready.");
                return;
            }
            for (RtpParameters.Encoding encoding : rtpParameters.encodings) {
                encoding.maxBitrateBps = n == null ? null : Integer.valueOf(n * 1000);
            }
            if (!this.localVideoSender.setParameters(rtpParameters)) {
                sLogListener.onLog(loglevel, this.name + "::: setVideoMaxBitrate, RtpSender.setParameters failed.");
            }
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setVideoMaxBitrate: ");
        });
    }

    public void setVideoMinBitrate(@Nullable Integer n) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setVideoMinBitrate: " + n);
        executor.execute(() -> {
            if (this.peerConnection == null || this.localVideoSender == null || this.checkError()) {
                sLogListener.onLog(loglevel, this.name + "::: setVideoMinBitrate, something error, peerConnection=" + this.peerConnection + ", localVideoSender=" + this.localVideoSender);
                return;
            }
            RtpParameters rtpParameters = this.localVideoSender.getParameters();
            if (rtpParameters.encodings.size() == 0) {
                sLogListener.onLog(loglevel, this.name + "::: setVideoMinBitrate, RtpParameters are not ready.");
                return;
            }
            for (RtpParameters.Encoding encoding : rtpParameters.encodings) {
                encoding.minBitrateBps = n == null ? DEFAULT_CONFIG_MINKBPS * 1000 : n * 1000;
            }
            if (!this.localVideoSender.setParameters(rtpParameters)) {
                sLogListener.onLog(loglevel, this.name + "::: setVideoMinBitrate, RtpSender.setParameters failed.");
            }
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setVideoMinBitrate: ");
        });
    }

    private void reportError(String string) {
        sLogListener.onLog(loglevel, "::: reportError: " + string);
        executor.execute(() -> {
            if (!isError) {
                this.lastErrorMsg = string;
                if (!this.isHangup) {
                    this.events.onPeerConnectionError(this, string);
                }
                isError = true;
            }
        });
    }

    private boolean checkError() {
        if (isError) {
            sLogListener.onLog(loglevel, this.name + "::: checkError: " + this.lastErrorMsg);
        }
        return isError;
    }

    @Nullable
    private AudioTrack createAudioTrack() {
        boolean bl = this.peerConnectionParameters.captureAudio && this.enableLocalAudio;
        this.audioSource = factory.createAudioSource(this.audioConstraints);
        this.localAudioTrack = factory.createAudioTrack(AUDIO_TRACK_ID, this.audioSource);
        this.localAudioTrack.setEnabled(bl);
        return this.localAudioTrack;
    }

    @Nullable
    private VideoTrack createVideoTrack(VideoCapturer videoCapturer) {
        this.surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", rootEglBase.getEglBaseContext());
        this.surfaceTextureHelper.setWatermark(this.watermark);
        this.videoSource = factory.createVideoSource(videoCapturer.isScreencast());
        videoCapturer.initialize(this.surfaceTextureHelper, appContext, this.videoSource.getCapturerObserver());
        if (!this.videoCapturerStopped) {
            videoCapturer.startCapture(this.videoWidth, this.videoHeight, this.videoFps);
        }
        this.localVideoTrack = factory.createVideoTrack(VIDEO_TRACK_ID, this.videoSource);
        this.localVideoTrack.setEnabled(this.renderVideo);
        Log.i((String)TAG, (String)"createVideoTrack: add localProxyVideoSink");
        this.localVideoTrack.addSink(this.localProxyVideoSink);
        return this.localVideoTrack;
    }

    private void findAudioSender() {
        for (RtpSender rtpSender : this.peerConnection.getSenders()) {
            String string;
            if (rtpSender.track() == null || !(string = rtpSender.track().kind()).equals(AUDIO_TRACK_TYPE)) continue;
            sLogListener.onLog(loglevel, this.name + "::: Found audio sender.");
            this.localAudioSender = rtpSender;
        }
    }

    private void findVideoSender() {
        for (RtpSender rtpSender : this.peerConnection.getSenders()) {
            String string;
            if (rtpSender.track() == null || !(string = rtpSender.track().kind()).equals(VIDEO_TRACK_TYPE)) continue;
            sLogListener.onLog(loglevel, this.name + "::: Found video sender.");
            this.localVideoSender = rtpSender;
        }
    }

    @Nullable
    private void findRemoteTracks() {
        MediaStreamTrack mediaStreamTrack;
        List<RtpTransceiver> list = this.peerConnection.getTransceivers();
        for (RtpTransceiver rtpTransceiver : list) {
            mediaStreamTrack = rtpTransceiver.getReceiver().track();
            if (!(mediaStreamTrack instanceof VideoTrack)) continue;
            this.remoteVideoTrack = (VideoTrack)mediaStreamTrack;
            break;
        }
        for (RtpTransceiver rtpTransceiver : list) {
            mediaStreamTrack = rtpTransceiver.getReceiver().track();
            if (!(mediaStreamTrack instanceof AudioTrack)) continue;
            this.remoteAudioTrack = (AudioTrack)mediaStreamTrack;
            break;
        }
    }

    private static String getSdpVideoCodecName(PeerConnectionParameters peerConnectionParameters) {
        switch (peerConnectionParameters.videoCodec) {
            case "VP8": {
                return "VP8";
            }
            case "VP9": {
                return "VP9";
            }
            case "H264 High": 
            case "H264 Baseline": {
                return "H264";
            }
        }
        return "VP8";
    }

    private static String setStartBitrate(String string, boolean bl, String string2, int n) {
        Matcher matcher;
        int n2;
        String[] stringArray = string2.split("\r\n");
        int n3 = -1;
        boolean bl2 = false;
        String string3 = null;
        String string4 = "^a=rtpmap:(\\d+) " + string + "(/\\d+)+[\r]?$";
        Pattern pattern = Pattern.compile(string4);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            matcher = pattern.matcher(stringArray[n2]);
            if (!matcher.matches()) continue;
            string3 = matcher.group(1);
            n3 = n2;
            break;
        }
        if (string3 == null) {
            Log.w((String)TAG, (String)("No rtpmap for " + string + " codec"));
            return string2;
        }
        Log.i((String)TAG, (String)("Found " + string + " rtpmap " + string3 + " at " + stringArray[n3]));
        string4 = "^a=fmtp:" + string3 + " \\w+=\\d+.*[\r]?$";
        pattern = Pattern.compile(string4);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            matcher = pattern.matcher(stringArray[n2]);
            if (!matcher.matches()) continue;
            Log.i((String)TAG, (String)("Found " + string + " " + stringArray[n2]));
            if (bl) {
                int n4 = n2;
                stringArray[n4] = stringArray[n4] + "; x-google-start-bitrate=" + n;
            } else {
                int n5 = n2;
                stringArray[n5] = stringArray[n5] + "; maxaveragebitrate=" + n * 1000;
            }
            Log.i((String)TAG, (String)("Update remote SDP line: " + stringArray[n2]));
            bl2 = true;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int k = 0; k < stringArray.length; ++k) {
            stringBuilder.append(stringArray[k]).append("\r\n");
            if (bl2 || k != n3) continue;
            String string5 = bl ? "a=fmtp:" + string3 + " " + VIDEO_CODEC_PARAM_START_BITRATE + "=" + n : "a=fmtp:" + string3 + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + n * 1000;
            Log.i((String)TAG, (String)("Add remote SDP line: " + string5));
            stringBuilder.append(string5).append("\r\n");
        }
        return stringBuilder.toString();
    }

    private static int findMediaDescriptionLine(boolean bl, String[] stringArray) {
        String string = bl ? "m=audio " : "m=video ";
        for (int k = 0; k < stringArray.length; ++k) {
            if (!stringArray[k].startsWith(string)) continue;
            return k;
        }
        return -1;
    }

    private static String joinString(Iterable<? extends CharSequence> iterable, String string, boolean bl) {
        Iterator<? extends CharSequence> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(string).append(iterator.next());
        }
        if (bl) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Nullable
    private static String movePayloadTypesToFront(List<String> list, String string) {
        List<String> list2 = Arrays.asList(string.split(" "));
        if (list2.size() <= 3) {
            Log.e((String)TAG, (String)("Wrong SDP media description format: " + string));
            return null;
        }
        List<String> list3 = list2.subList(0, 3);
        ArrayList<String> arrayList = new ArrayList<String>(list2.subList(3, list2.size()));
        arrayList.removeAll(list);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(list3);
        arrayList2.addAll(list);
        arrayList2.addAll(arrayList);
        return RtcConnection.joinString(arrayList2, " ", false);
    }

    private static String preferCodec(String string, String string2, boolean bl) {
        String[] stringArray = string.split("\r\n");
        int n = RtcConnection.findMediaDescriptionLine(bl, stringArray);
        if (n == -1) {
            Log.w((String)TAG, (String)("No mediaDescription line, so can't prefer " + string2));
            return string;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^a=rtpmap:(\\d+) " + string2 + "(/\\d+)+[\r]?$");
        for (String string3 : stringArray) {
            Matcher matcher = pattern.matcher(string3);
            if (!matcher.matches()) continue;
            arrayList.add(matcher.group(1));
        }
        if (arrayList.isEmpty()) {
            Log.w((String)TAG, (String)("No payload types with name " + string2));
            return string;
        }
        String string4 = RtcConnection.movePayloadTypesToFront(arrayList, stringArray[n]);
        if (string4 == null) {
            return string;
        }
        Log.i((String)TAG, (String)("Change media description from: " + stringArray[n] + " to " + string4));
        stringArray[n] = string4;
        return RtcConnection.joinString(Arrays.asList(stringArray), "\r\n", true);
    }

    private void drainCandidates() {
        if (this.queuedRemoteCandidates != null) {
            Log.i((String)TAG, (String)("Add " + this.queuedRemoteCandidates.size() + " remote candidates"));
            for (IceCandidate iceCandidate : this.queuedRemoteCandidates) {
                this.peerConnection.addIceCandidate(iceCandidate);
            }
            this.queuedRemoteCandidates = null;
        }
    }

    private void switchCameraInternal(CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        if (this.videoCapturer instanceof CameraVideoCapturer) {
            if (!this.peerConnectionParameters.videoCallEnabled || this.checkError()) {
                Log.e((String)TAG, (String)("Failed to switch camera. Video: " + this.peerConnectionParameters.videoCallEnabled));
                return;
            }
            Log.i((String)TAG, (String)"Switch camera");
            CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
            cameraVideoCapturer.switchCamera(cameraSwitchHandler);
        } else {
            Log.i((String)TAG, (String)"Will not switch camera, video caputurer is not a camera");
        }
    }

    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ switchCamera, callback=" + cameraSwitchHandler);
        executor.execute(() -> this.switchCameraInternal(new CameraVideoCapturer.CameraSwitchHandler(){

            @Override
            public void onCameraSwitchDone(boolean bl) {
                RtcConnection.this.enableLocalViewMirror = bl;
                RtcConnection.this.updateLocalVideoViewMirror();
                if (cameraSwitchHandler != null) {
                    cameraSwitchHandler.onCameraSwitchDone(bl);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- switchCamera finish");
            }

            @Override
            public void onCameraSwitchError(String string) {
                if (cameraSwitchHandler != null) {
                    cameraSwitchHandler.onCameraSwitchError(string);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- switchCamera error: " + string);
            }
        }));
    }

    public void changeVideoResolution(int n, int n2) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ changeVideoResolution: ");
        executor.execute(() -> {
            this.changeCaptureFormatInternal(n, n2, 15);
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- changeVideoResolution: " + n + "x" + n2 + "@" + 15);
        });
    }

    private void changeCaptureFormatInternal(int n, int n2, int n3) {
        if (!this.peerConnectionParameters.videoCallEnabled || this.checkError() || this.videoCapturer == null) {
            sLogListener.onLog(loglevel, this.name + "::: Failed to change capture format. Video: " + this.peerConnectionParameters.videoCallEnabled);
            return;
        }
        this.videoSource.adaptOutputFormat(n, n2, n3);
    }

    public void setEnableExternalVideoData(boolean bl) {
        this.peerConnectionParameters.enableExternalVideoData = bl;
    }

    public void inputExternalVideoData(byte[] byArray, FORMAT fORMAT, int n, int n2, int n3, long l) {
        Object object;
        Object object2;
        if (!(this.videoCapturer instanceof ExternalVideoCapturer)) {
            return;
        }
        if (fORMAT == FORMAT.NV21) {
            assert (byArray.length == n * n2 * 3 / 2);
            object2 = new NV21Buffer(byArray, n, n2, null);
        } else if (fORMAT == FORMAT.I420) {
            assert (byArray.length == n * n2 * 3 / 2);
            object = JavaI420Buffer.allocate(n, n2);
            ByteBuffer byteBuffer = ((JavaI420Buffer)object).getDataY();
            ByteBuffer byteBuffer2 = ((JavaI420Buffer)object).getDataU();
            ByteBuffer byteBuffer3 = ((JavaI420Buffer)object).getDataV();
            byteBuffer.put(byArray, 0, byteBuffer.capacity());
            byteBuffer2.put(byArray, byteBuffer.capacity(), byteBuffer2.capacity());
            byteBuffer3.put(byArray, byteBuffer.capacity() + byteBuffer2.capacity(), byteBuffer3.capacity());
            object2 = object;
        } else {
            throw new IllegalArgumentException("Unsupported external video data format.");
        }
        object = (ExternalVideoCapturer)this.videoCapturer;
        ((ExternalVideoCapturer)object).inputExternalVideoData(new VideoFrame((VideoFrame.Buffer)object2, n3, l));
    }

    public void setWaterMark(Watermark watermark) {
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.setWatermark(watermark);
        } else {
            this.watermark = watermark;
        }
    }

    public int inputExternalAudioData(byte[] byArray, int n) {
        ExternalInputAudioSourceWrapper.getInstance();
        return ExternalInputAudioSourceWrapper.writeExternalAudioBuffer(byArray, n);
    }

    public int releaseExternalAudio() {
        ExternalInputAudioSourceWrapper.getInstance();
        return ExternalInputAudioSourceWrapper.releaseExternalAudio();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLogListener(LogListener logListener) {
        Log.i((String)TAG, (String)"::: [rapi]++ registerLogListener");
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            Log.i((String)TAG, (String)"::: [rapi]-- registerLogListener");
            if (logListener != null) {
                sLogListener = logListener;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getVersion() {
        return "rtc-71";
    }

    public static void initGlobal(Context context, LooperExecutor looperExecutor) {
        RtcConnection.initGlobal(context, false, looperExecutor);
    }

    public static void initGlobal(Context context, boolean bl, LooperExecutor looperExecutor) {
        sLogListener.onLog(loglevel, "::: [rapi]++ initGlobal, useVideoCodecHw=" + bl + ", rtc sdk version " + RtcConnection.getVersion());
        if (factory != null) {
            throw new IllegalStateException("PeerConnectionFactory has already been constructed");
        }
        appContext = context.getApplicationContext();
        if (looperExecutor == null) {
            executor = new LooperExecutor();
            executor.requestStart();
        } else {
            executor = looperExecutor;
        }
        rootEglBase = EglBase.create();
        executor.execute(() -> {
            PeerConnectionFactory.initialize(PeerConnectionFactory.InitializationOptions.builder(appContext).setFieldTrials("").setEnableInternalTracer(true).createInitializationOptions());
            PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
            RtcConnection.createPeerConnectionFactoryInternal(options, bl);
            sLogListener.onLog(loglevel, "::: [rapi]-- initGlobal, peer connection factory created.");
        });
    }

    public void setViews(SurfaceViewRenderer surfaceViewRenderer, SurfaceViewRenderer surfaceViewRenderer2) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setViews, localRender = " + surfaceViewRenderer + ", remoteRender = " + surfaceViewRenderer2);
        executor.execute(() -> {
            if (this.isHangup) {
                sLogListener.onLog(loglevel, this.name + "::: skip setViews because of conn is already hangup!");
                return;
            }
            if (this.localRender != null) {
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setViews, localRender already exists, release it first on ui thread.");
                this.localRender.release();
            }
            if (this.remoteRender != null) {
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setViews, remoteRender already exists, release it first on ui thread.");
                this.remoteRender.release();
            }
            this.localRender = surfaceViewRenderer;
            this.remoteRender = surfaceViewRenderer2;
            if (this.localRender != null) {
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setViews, init localRender on ui thread.");
                this.localRender.init(rootEglBase.getEglBaseContext(), null);
                this.updateLocalVideoViewMirror();
            }
            if (this.remoteRender != null) {
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setViews, init remoteRender on ui thread.");
                this.remoteRender.init(rootEglBase.getEglBaseContext(), null);
            }
            this.localProxyVideoSink.setTarget(surfaceViewRenderer);
            this.remoteProxyVideoSink.setTarget(surfaceViewRenderer2);
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setViews finish");
        });
    }

    public void setIceServer(String string, String string2, String string3) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setIceServer, params: " + string + " - " + string2 + " - " + string3);
        executor.execute(() -> {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(RtcConstStringURL, (Object)string);
                jSONObject.put(RtcConstStringUserName, (Object)string2);
                jSONObject.put(RtcConstStringCredential, (Object)string3);
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)jSONObject);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put(RtcKVIceServersArray, (Object)jSONArray);
                this.setConfigureInternal(jSONObject2.toString());
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setIceServer");
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setIceServer error: " + jSONException.getMessage());
            }
        });
    }

    public void setConfigure(String string) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setConfigure: " + string);
        executor.execute(() -> {
            this.setConfigureInternal(string);
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setConfigure: ");
        });
    }

    public void setCameraFacing(int n) {
        this.defaultCameraFacing = n;
        this.enableLocalViewMirror = n == 1;
        sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setCameraFacing, facing: " + n + ", enableLocalViewMirror: " + this.enableLocalViewMirror);
    }

    public int getCameraFacing() {
        return this.defaultCameraFacing;
    }

    public void screenShare(Intent intent) {
        if (intent == null) {
            return;
        }
        this.peerConnectionParameters.captureVideo = false;
        this.peerConnectionParameters.shareScreen = true;
        this.peerConnectionParameters.enableExternalVideoData = false;
        this.mediaProjectionPermissionResultData = intent;
        sLogListener.onLog(loglevel, this.name + "::: [rapi]-- screenShare: " + intent);
    }

    public void hangup() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ hangup");
        executor.execute(() -> {
            this.closeInternal();
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- hangup");
        });
    }

    public void setenableaec(boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setenableaec:" + bl);
        executor.execute(() -> {
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setenableaec");
            this.enableaec = bl;
        });
    }

    public void setenableagc(boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setenableagc:" + bl);
        executor.execute(() -> {
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setenableagc");
            this.enableagc = bl;
        });
    }

    public void setenablens(boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setenablens:" + bl);
        executor.execute(() -> {
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setenablens");
            this.enablens = bl;
        });
    }

    @Deprecated
    public void switchCamera() {
        this.switchCamera(null);
    }

    @Deprecated
    public void setListener(Listener listener) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setListener");
        executor.execute(() -> {
            if (this.isHangup) {
                sLogListener.onLog(loglevel, this.name + "::: skip setListener because of conn is already hangup!");
                return;
            }
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setListener");
            this.events = new Listener.ListenerAdapter(listener);
        });
    }

    public void setListener(PeerConnectionEvents peerConnectionEvents) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setListener");
        executor.execute(() -> {
            if (this.isHangup) {
                sLogListener.onLog(loglevel, this.name + "::: skip setListener because of conn is already hangup!");
                return;
            }
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setListener");
            this.events = peerConnectionEvents;
        });
    }

    public void answer() {
        this.createAnswer();
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setStatsEnable(boolean bl) {
        this.enableStatsEvents(bl, 10000);
    }

    public String setRemoteJson(String string) throws Exception {
        sLogListener.onLog(loglevel, this.name + "::: remote json: " + string);
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setRemoteJson");
        RtcContent rtcContent = RtcContent.fromJson(string);
        SessionDescription sessionDescription = RtcConnection.content2Sdp(rtcContent);
        if (sessionDescription != null) {
            this.addPendingSdp(sessionDescription);
            executor.execute(() -> {
                sLogListener.onLog(loglevel, "setRemoteJson remote sdp start -0- name: " + this.name);
                if (this.isHangup) {
                    sLogListener.onLog(loglevel, this.name + "::: skip setRemoteJson because of conn is already hangup!");
                    return;
                }
                this.processPendingSdpInternal();
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setRemoteJson remote sdp");
            });
            return rtcContent.type;
        }
        IceCandidate iceCandidate = RtcConnection.content2Candidate(rtcContent);
        if (iceCandidate != null) {
            executor.execute(() -> {
                sLogListener.onLog(loglevel, this.name + "::: setRemoteJson remote candidate start -0- name: " + this.name);
                this.addRemoteIceCandidateInternal(iceCandidate);
                sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setRemoteJson remote candidate");
            });
            return rtcContent.type;
        }
        throw new Exception("unknown type " + rtcContent.type);
    }

    public static void setDocDirectory(String string) {
    }

    public static boolean startRecordPlayout() {
        return true;
    }

    public static String stopRecordPlayout() {
        return "";
    }

    public static void enableFixedVideoResolution(boolean bl) {
    }

    public void takeCameraPicture(final RTCCallback rTCCallback) {
        if (this.videoCapturer instanceof CameraVideoCapturer) {
            ((CameraVideoCapturer)this.videoCapturer).takeCameraPicture(new ICameraInterface.ITakeCallback(){

                @Override
                public void onTaken(@Nullable Bitmap bitmap) {
                    block4: {
                        try {
                            String string = Environment.getExternalStorageState().equals("mounted") ? appContext.getExternalFilesDir("").getAbsolutePath() + "/RTC_Camera_picture.jpg" : appContext.getFilesDir().getPath() + "/RTC_Camera_picture.jpg";
                            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
                            if (!bitmap.isRecycled()) {
                                bitmap.recycle();
                            }
                            if (rTCCallback != null) {
                                rTCCallback.onDone(string);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (rTCCallback == null) break block4;
                            rTCCallback.onError(101, Log.getStackTraceString((Throwable)exception));
                        }
                    }
                }

                @Override
                public void onError(int n, String string) {
                    if (rTCCallback != null) {
                        rTCCallback.onError(n, string);
                    }
                }
            });
        }
    }

    public static void setCallAudioSource(int n) {
        callAudioSource = n;
    }

    public void setMaxVideoFrameRate(int n) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setMaxVideoFrameRate: " + n);
        executor.execute(() -> {
            if (this.peerConnection == null || this.localVideoSender == null || this.checkError()) {
                sLogListener.onLog(loglevel, this.name + "::: setMaxVideoFrameRate, something error, peerConnection=" + this.peerConnection + ", localVideoSender=" + this.localVideoSender);
                return;
            }
            if (this.isHangup) {
                sLogListener.onLog(loglevel, this.name + "::: skip setMaxVideoFrameRate because of conn is already hangup!");
                return;
            }
            RtpParameters rtpParameters = this.localVideoSender.getParameters();
            if (rtpParameters.encodings.size() == 0) {
                sLogListener.onLog(loglevel, this.name + "::: setMaxVideoFrameRate, RtpParameters are not ready.");
                return;
            }
            for (RtpParameters.Encoding encoding : rtpParameters.encodings) {
                encoding.maxFramerate = n;
            }
            if (!this.localVideoSender.setParameters(rtpParameters)) {
                sLogListener.onLog(loglevel, this.name + "::: setMaxVideoFrameRate, RtpSender.setParameters failed.");
            }
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- setMaxVideoFrameRate: ");
        });
    }

    public static void setMinVideoKbps(int n) {
        minVideoKbps = n > 0 ? n : DEFAULT_CONFIG_MINKBPS;
    }

    public static void setAudioSampleRate(int n) {
        if (n > 0) {
            audioSampleRate = n;
        }
    }

    public static void setUseStereoInput(boolean bl) {
        useStereoInput = bl;
    }

    public static void setUse2channels(boolean bl) {
        use2channels = bl;
    }

    public void setRotation(int n) {
        if (n % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.configRotation = n;
        this.checkVideoCapturerConfigRotation();
    }

    public static void setGlobalVideoCodec(String string) {
        globalVideoCodec = string;
    }

    private void checkVideoCapturerConfigRotation() {
        if (this.videoCapturer != null && this.configRotation != 0) {
            this.videoCapturer.setRotation(this.configRotation);
        }
    }

    private void switchVideo(boolean bl) {
        executor.execute(() -> {
            if (this.isHangup) {
                sLogListener.onLog(loglevel, this.name + "::: skip switchVideo because of conn is already hangup!");
                return;
            }
            this.peerConnectionParameters.captureVideo = bl;
            this.checkMediaTracksInternal();
        });
    }

    private void switchAudio(boolean bl) {
        executor.execute(() -> {
            if (this.isHangup) {
                sLogListener.onLog(loglevel, this.name + "::: skip switchAudio because of conn is already hangup!");
                return;
            }
            this.peerConnectionParameters.captureAudio = bl;
            this.checkMediaTracksInternal();
        });
    }

    public static Map<String, Map<Integer, Integer>> getAudioVolumeOfRTCMap(Map<String, RtcConnectionExt> map) {
        HashMap<String, Map<Integer, Integer>> hashMap = new HashMap<String, Map<Integer, Integer>>();
        for (String string : map.keySet()) {
            RtcConnectionExt rtcConnectionExt = map.get(string);
            Map<Integer, Integer> map2 = rtcConnectionExt.getAudioVolume();
            if (map2 == null) continue;
            hashMap.put(string, map2);
        }
        return hashMap;
    }

    public Map<Integer, Integer> getAudioVolume() {
        Object object;
        if (this.audioReceiver == null && this.peerConnection != null) {
            object = this.peerConnection.getReceivers();
            Iterator<RtpReceiver> iterator = object.iterator();
            while (iterator.hasNext()) {
                RtpReceiver rtpReceiver = iterator.next();
                if (rtpReceiver.getMediaType() != RtpReceiver.MediaType.MEDIA_TYPE_AUDIO) continue;
                this.audioReceiver = rtpReceiver;
                break;
            }
        }
        object = null;
        if (this.audioReceiver != null) {
            object = (Map)this.audioReceiver.getEMSources();
        }
        return object;
    }

    private void changeResolution() {
        WindowManager windowManager = (WindowManager)appContext.getSystemService("window");
        Point point = new Point();
        if (Build.VERSION.SDK_INT > 16) {
            windowManager.getDefaultDisplay().getRealSize(point);
        } else {
            windowManager.getDefaultDisplay().getSize(point);
        }
        float f2 = point.x > point.y ? (float)point.y / (float)point.x : (float)point.x / (float)point.y;
        this.videoWidth = (int)((float)this.videoHeight * f2);
        sLogListener.onLog(loglevel, this.name + "::: Change the video resolution based on real screen ratio: " + this.videoWidth + "x" + this.videoHeight);
    }

    public void updateLocalVideoViewMirror() {
        boolean bl = this.getVideoViewMirror();
        sLogListener.onLog(loglevel, this.name + "::: [rapi]-- updateLocalVideoViewMirror, localRender: " + this.localRender + ", mirror: " + bl);
        if (this.localRender != null) {
            this.localRender.setMirror(bl);
        }
    }

    private boolean getVideoViewMirror() {
        boolean bl;
        switch (mirrorType) {
            case ON: {
                bl = true;
                break;
            }
            case OFF: {
                bl = false;
                break;
            }
            default: {
                bl = this.enableLocalViewMirror;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingSdp(SessionDescription sessionDescription) {
        LinkedList<SessionDescription> linkedList = this.pendingSdp;
        synchronized (linkedList) {
            this.pendingSdp.addLast(sessionDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionDescription removePendingSdp() {
        LinkedList<SessionDescription> linkedList = this.pendingSdp;
        synchronized (linkedList) {
            if (this.pendingSdp.isEmpty()) {
                return null;
            }
            return this.pendingSdp.removeFirst();
        }
    }

    private static SessionDescription content2Sdp(RtcContent rtcContent) {
        if (rtcContent.type.equalsIgnoreCase(RtcContent.TYPE_OFFER) || rtcContent.type.equalsIgnoreCase(RtcContent.TYPE_ANSWER) || rtcContent.type.equalsIgnoreCase(RtcContent.TYPE_PRANSWER)) {
            return new SessionDescription(SessionDescription.Type.valueOf(rtcContent.type.toUpperCase()), rtcContent.sdp);
        }
        return null;
    }

    private static IceCandidate content2Candidate(RtcContent rtcContent) {
        if (rtcContent.type.equalsIgnoreCase("candidate")) {
            IceCandidate iceCandidate = new IceCandidate(rtcContent.sdpMid, rtcContent.mlineindex, rtcContent.candidate);
            return iceCandidate;
        }
        return null;
    }

    private String preferCandidates(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\r\n");
        for (int k = 0; k < stringArray.length; ++k) {
            String string2 = stringArray[k];
            stringBuilder.append(string2).append("\r\n");
        }
        return stringBuilder.toString();
    }

    @Nullable
    private VideoCapturer createCameraCapturer(CameraEnumerator cameraEnumerator) {
        String[] stringArray = cameraEnumerator.getDeviceNames();
        if (stringArray.length == 0) {
            Log.e((String)TAG, (String)"No camera found in this device.");
            return null;
        }
        if (this.defaultCameraFacing == 1) {
            Logging.d(TAG, "Looking for front facing cameras.");
            for (String string : stringArray) {
                if (!cameraEnumerator.isFrontFacing(string)) continue;
                Logging.d(TAG, "Creating front facing camera capturer.");
                CameraVideoCapturer cameraVideoCapturer = cameraEnumerator.createCapturer(string, this.cameraEventsHandler);
                if (cameraVideoCapturer == null) continue;
                return cameraVideoCapturer;
            }
            CameraVideoCapturer object = cameraEnumerator.createCapturer(stringArray[0], this.cameraEventsHandler);
            if (object != null) {
                return object;
            }
        } else if (this.defaultCameraFacing == 0) {
            Logging.d(TAG, "Looking for back facing cameras.");
            for (String string : stringArray) {
                if (!cameraEnumerator.isBackFacing(string)) continue;
                Logging.d(TAG, "Creating back facing camera capturer.");
                CameraVideoCapturer cameraVideoCapturer = cameraEnumerator.createCapturer(string, this.cameraEventsHandler);
                if (cameraVideoCapturer == null) continue;
                return cameraVideoCapturer;
            }
            CameraVideoCapturer cameraVideoCapturer = cameraEnumerator.createCapturer(stringArray[0], this.cameraEventsHandler);
            if (cameraVideoCapturer != null) {
                return cameraVideoCapturer;
            }
        }
        return null;
    }

    @Nullable
    private VideoCapturer createScreenCapturer() {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        return new ScreenCapturerAndroid(this.mediaProjectionPermissionResultData, new MediaProjection.Callback(){

            public void onStop() {
                Log.e((String)RtcConnection.TAG, (String)"User revoked permission to capture the screen.");
            }
        });
    }

    private void setConfigureInternal(String string) {
        try {
            JSONArray jSONArray;
            Object object;
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has(RtcKVCaptureVideoBoolean)) {
                object = jSONObject.get(RtcKVCaptureVideoBoolean);
                this.peerConnectionParameters.captureVideo = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVRecvVideoBoolean)) {
                object = jSONObject.get(RtcKVRecvVideoBoolean);
                this.peerConnectionParameters.receiveVideo = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVPreferVCodecString)) {
                this.peerConnectionParameters.videoCodec = jSONObject.getString(RtcKVPreferVCodecString);
            }
            if (jSONObject.has(RtcKVCaptureAudioBoolean)) {
                object = jSONObject.get(RtcKVCaptureAudioBoolean);
                this.peerConnectionParameters.captureAudio = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVRecvAudioBoolean)) {
                object = jSONObject.get(RtcKVRecvAudioBoolean);
                this.peerConnectionParameters.receiveAudio = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVPreferACodecString)) {
                this.peerConnectionParameters.audioCodec = jSONObject.getString(RtcKVPreferACodecString);
            }
            if (jSONObject.has(RtcvideowidthLong)) {
                this.peerConnectionParameters.videoWidth = jSONObject.getInt(RtcvideowidthLong);
            }
            if (jSONObject.has(RtcvideoheigthLong)) {
                this.peerConnectionParameters.videoHeight = jSONObject.getInt(RtcvideoheigthLong);
            }
            if (jSONObject.has(RtcvideofpsLong)) {
                this.peerConnectionParameters.videoFps = jSONObject.getInt(RtcvideofpsLong);
            }
            if (jSONObject.has(RtcKVMaxVideoKbpsLong)) {
                this.peerConnectionParameters.videoMaxBitrate = jSONObject.getInt(RtcKVMaxVideoKbpsLong);
                if (this.peerConnectionParameters.videoMaxBitrate < 0) {
                    this.peerConnectionParameters.videoMaxBitrate = 0;
                }
            }
            if (jSONObject.has(RtcKVRelayVideoKbpsLong)) {
                this.peerConnectionParameters.relayVideoMaxKbps = jSONObject.getInt(RtcKVRelayVideoKbpsLong);
            }
            if (jSONObject.has(RtcKVMaxAudioKbpsLong)) {
                this.peerConnectionParameters.audioMaxKbps = jSONObject.getInt(RtcKVMaxAudioKbpsLong);
            }
            if (jSONObject.has(RtcKVRelayAudioKbpsLong)) {
                this.peerConnectionParameters.relayAudioMaxKbps = jSONObject.getInt(RtcKVRelayAudioKbpsLong);
            }
            if (jSONObject.has(RtcKVLoopbackBoolean)) {
                object = jSONObject.get(RtcKVLoopbackBoolean);
                this.peerConnectionParameters.loopback = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVDisablePranswerBoolean)) {
                object = jSONObject.get(RtcKVDisablePranswerBoolean);
                this.peerConnectionParameters.disablePranswer = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVRelayOnlyBoolean)) {
                object = jSONObject.get(RtcKVRelayOnlyBoolean);
                this.peerConnectionParameters.enableRelay = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVAecDumpFileString)) {
                this.peerConnectionParameters.aecDumpFileName = jSONObject.getString(RtcKVAecDumpFileString);
            }
            if (jSONObject.has(RtcCustomVideoSourceBoolean)) {
                int n = jSONObject.optInt(RtcCustomVideoSourceBoolean);
                this.peerConnectionParameters.enableExternalVideoData = n != 0;
            }
            if ((jSONArray = jSONObject.optJSONArray(RtcKVIceServersArray)) != null) {
                this.iceServers.clear();
                for (int k = 0; k < jSONArray.length(); ++k) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(k);
                    this.iceServers.add(new PeerConnection.IceServer(jSONObject2.optString(RtcConstStringURL), jSONObject2.optString(RtcConstStringUserName), jSONObject2.optString(RtcConstStringCredential)));
                }
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private String filterRemoteSDP(String string) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = string.split("\n")) {
            while (string2.endsWith("\r")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            if (this.peerConnectionParameters.audioMaxKbps > 0 && string2.contains("a=mid:audio")) {
                stringBuilder.append(string2 + "\r\n");
                stringBuilder.append(String.format("b=AS:%d\r\n", this.peerConnectionParameters.audioMaxKbps));
                string2 = null;
            } else if (this.peerConnectionParameters.relayVideoMaxKbps > 0 && string2.contains("a=mid:video")) {
                stringBuilder.append(string2 + "\r\n");
                stringBuilder.append(String.format("b=AS:%d\r\n", this.peerConnectionParameters.relayVideoMaxKbps));
                string2 = null;
            } else if (this.peerConnectionParameters.videoMaxBitrate > 0 && string2.contains("a=mid:video")) {
                stringBuilder.append(string2 + "\r\n");
                stringBuilder.append(String.format("b=AS:%d\r\n", this.peerConnectionParameters.videoMaxBitrate));
                string2 = null;
            } else if (this.peerConnectionParameters.videoStartBitrate > 0 && string2.contains("a=rtpmap:")) {
                String[] stringArray2 = string2.split(" ");
                if (stringArray2.length > 1) {
                    String string3 = stringArray2[1];
                    if (string3.contains("VP8") || string3.contains("VP9") || string3.contains("H264")) {
                        String string4 = stringArray2[0];
                        String string5 = string4.substring(9);
                        stringBuilder.append(string2 + "\r\n");
                        stringBuilder.append(String.format("a=fmtp:%s %s=%d\r\n", string5, VIDEO_CODEC_PARAM_START_BITRATE, this.peerConnectionParameters.videoStartBitrate));
                        string2 = null;
                    }
                    if (this.localEnableDTX && this.remoteEnableDTX && string2.contains("CN/")) {
                        string2 = null;
                    }
                }
            } else if (this.peerConnectionParameters.videoStartBitrate > 0 && string2.contains(VIDEO_CODEC_PARAM_START_BITRATE)) {
                string2 = null;
            } else if (this.localEnableDTX && string2.contains("usedtx=1")) {
                this.remoteEnableDTX = true;
            }
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            stringBuilder.append(string2 + "\r\n");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLocalSeq() {
        RtcConnection rtcConnection = this;
        synchronized (rtcConnection) {
            ++this.localSeq;
            return this.localSeq;
        }
    }

    public static void setRtcListener(RtcListener rtcListener) {
        RtcConnection.rtcListener = rtcListener;
    }

    public void interestAt(int n, int n2, int n3, int n4, boolean bl) {
        if (this.videoCapturer instanceof CameraVideoCapturer) {
            this.handleFocus(n, n2, n3, n4);
        }
    }

    public void zoomWithFactor(Float f2) {
        if (this.videoCapturer instanceof CameraVideoCapturer) {
            this.handleZoom(f2);
        }
    }

    public void handleZoom(Float f2) {
        executor.execute(() -> {
            if (this.videoCapturer instanceof CameraVideoCapturer) {
                CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
                cameraVideoCapturer.handleZoom(f2);
            }
        });
    }

    public void handleFocus(int n, int n2, int n3, int n4) {
        if (this.localRender == null) {
            return;
        }
        int n5 = this.localRender.getWidth();
        int n6 = this.localRender.getHeight();
        executor.execute(() -> {
            if (this.videoCapturer instanceof CameraVideoCapturer) {
                CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
                cameraVideoCapturer.handleFocusMetering(n, n2, n5, n6, n3, n4);
            }
        });
    }

    public void handleManualFocus(float f2, float f3, int n, int n2) {
        if (this.localRender == null) {
            return;
        }
        int n3 = this.localRender.getWidth();
        int n4 = this.localRender.getHeight();
        RendererCommon.ScalingType scalingType = this.localRender.getScalingType();
        executor.execute(() -> {
            if (this.videoCapturer instanceof CameraVideoCapturer) {
                CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
                cameraVideoCapturer.handleManualFocus((int)f2, (int)f3, n3, n4, n, n2, scalingType);
            }
        });
    }

    public void handleManualZoom(boolean bl, int n) {
        if (this.localRender == null) {
            return;
        }
        executor.execute(() -> {
            if (this.videoCapturer instanceof CameraVideoCapturer) {
                CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
                cameraVideoCapturer.handleManualZoom(bl, n);
            }
        });
    }

    public void handleFlashLight(boolean bl) {
        if (this.localRender == null) {
            return;
        }
        executor.execute(() -> {
            if (this.videoCapturer instanceof CameraVideoCapturer) {
                CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
                cameraVideoCapturer.handleFlashLight(bl);
            }
        });
    }

    private static String appendStatString(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        return string + "," + string2;
    }

    private static void addState(Map<String, String> map, String string, String string2) {
        map.put(string, RtcConnection.appendStatString(map.get(string), string2));
    }

    private static String makeStatLine(Map<String, String> map, String string, String string2) {
        if (map.get(string) != null) {
            return string2 + string + ": " + map.get(string) + "\r\n";
        }
        return "";
    }

    private static Map<String, String> convertStatMap(StatsReport.Value[] valueArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (StatsReport.Value value : valueArray) {
            hashMap.put(value.name, value.value);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReportString() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            jSONObject.put("conn", (Object)this.connectType);
            jSONObject.put("lvcodec", (Object)this.lusevcodectype);
            jSONObject.put("lacodec", (Object)this.luseacodectype);
            jSONObject.put("rvcodec", (Object)this.rusevcodectype);
            jSONObject.put("racodec", (Object)this.ruseacodectype);
            jSONObject.put("sentVB", this.videosendbytes);
            jSONObject.put("sentAB", this.audiosendbytes);
            jSONObject.put("recvVB", this.videorecvbytes);
            jSONObject.put("recvAB", this.audiorecvbytes);
            jSONObject.put("sentVP", this.videolastsendpackets);
            jSONObject.put("sentAP", this.audiolastsendpackets);
            jSONObject.put("recvVP", this.videolastrecvpackets);
            jSONObject.put("recvAP", this.audiolastrecvpackets);
            jSONObject.put("os", (Object)"a");
            if (this.remoteRender != null) {
                this.framesReceived = this.remoteRender.getFrameReceived();
            }
            jSONObject.put("rvfrm", this.framesReceived);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return "ReportString: " + this.name + ": " + jSONObject.toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    private RtcStatistics convert(StatsReport[] statsReportArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        HashMap<String, String> hashMap5 = new HashMap<String, String>();
        RtcStatistics rtcStatistics = new RtcStatistics();
        for (StatsReport statsReport : statsReportArray) {
            String string;
            String string2;
            Map<String, String> map = RtcConnection.convertStatMap(statsReport.values);
            if (statsReport.type.equals("googCandidatePair")) {
                if (!map.get("googActiveConnection").equals("true")) continue;
                string2 = map.get("googLocalCandidateType");
                string = map.get("googRemoteCandidateType");
                if (string2 != null && string2.equals("relay") || string != null && string.equals("relay")) {
                    RtcConnection.addState(hashMap, STAT_KEY_CONNECTION, "relay");
                    rtcStatistics.connectionType = this.connectType = "relay";
                    continue;
                }
                RtcConnection.addState(hashMap, STAT_KEY_CONNECTION, "direct");
                rtcStatistics.connectionType = this.connectType = "direct";
                continue;
            }
            if (statsReport.type.equals("ssrc")) {
                int n;
                int n2;
                string2 = map.get("googCodecName");
                if (map.get("googFrameWidthReceived") != null) {
                    this.rusevcodectype = string2;
                    string = map.get("googFrameWidthReceived");
                    String string3 = map.get("googFrameHeightReceived");
                    hashMap3.put("vcodec", string2);
                    hashMap3.put("vsize", string + "x" + string3);
                    hashMap3.put("vfps", map.get("googFrameRateDecoded"));
                    hashMap3.put("vlost", map.get("packetsLost"));
                    hashMap3.put("vbytes", map.get("bytesReceived"));
                    this.remoteVideoBW.update(map.get("bytesReceived"));
                    if (map.containsKey("bytesReceived")) {
                        this.videorecvbytes = Integer.parseInt(map.get("bytesReceived"));
                    }
                    if (map.containsKey("packetsReceived")) {
                        this.videocurrecvpackets = Integer.parseInt(map.get("packetsReceived"));
                    }
                    n2 = this.videocurrecvpackets - this.videolastrecvpackets;
                    this.videolastrecvpackets = this.videocurrecvpackets;
                    if (map.containsKey("packetsLost")) {
                        this.videocurrecvpacketsLost = Integer.parseInt(map.get("packetsLost"));
                    }
                    n = this.videocurrecvpacketsLost - this.videolastrecvpacketsLost;
                    this.videolastrecvpacketsLost = this.videocurrecvpacketsLost;
                    this.recvpacketslostrate.addvideopackslost(n2, n);
                    rtcStatistics.remoteVideoPacketsLostrate = this.recvpacketslostrate.getvideopackslostrate();
                    hashMap5.put("vsize", string + "x" + string3);
                    hashMap5.put("vfps", map.get("googFrameRateReceived"));
                    hashMap5.put("vlost", map.get("packetsLost"));
                    if (map.containsKey("googFrameWidthReceived")) {
                        rtcStatistics.remoteWidth = Integer.parseInt(map.get("googFrameWidthReceived"));
                    }
                    if (map.containsKey("googFrameHeightReceived")) {
                        rtcStatistics.remoteHeight = Integer.parseInt(map.get("googFrameHeightReceived"));
                    }
                    if (map.containsKey("googFrameRateReceived")) {
                        rtcStatistics.remoteFps = Integer.parseInt(map.get("googFrameRateReceived"));
                    }
                    if (!map.containsKey("packetsLost")) continue;
                    rtcStatistics.remoteVideoPacketsLost = Integer.parseInt(map.get("packetsLost"));
                    continue;
                }
                if (map.get("googFrameWidthSent") != null) {
                    string = map.get("googFrameWidthSent");
                    String string4 = map.get("googFrameHeightSent");
                    this.lusevcodectype = string2;
                    hashMap2.put("vlcodec", string2);
                    hashMap2.put("vinsize", map.get("googFrameWidthInput") + "x" + map.get("googFrameHeightInput"));
                    hashMap2.put("vsize", string + "x" + string4);
                    hashMap2.put("vfps", map.get("googFrameRateInput") + "/" + map.get("googFrameRateSent"));
                    hashMap2.put("vlost", map.get("packetsLost"));
                    hashMap2.put("vrtt", map.get("googRtt"));
                    hashMap2.put("vbytes", map.get("bytesSent"));
                    this.localVideoBW.update(map.get("bytesSent"));
                    if (map.containsKey("bytesSent")) {
                        this.videosendbytes = Integer.parseInt(map.get("bytesSent"));
                    }
                    if (map.containsKey("packetsSent")) {
                        this.videocursendpackets = Integer.parseInt(map.get("packetsSent"));
                    }
                    n2 = this.videocursendpackets - this.videolastsendpackets;
                    this.videolastsendpackets = this.videocursendpackets;
                    if (map.containsKey("packetsLost")) {
                        this.videocursendpacketsLost = Integer.parseInt(map.get("packetsLost"));
                    }
                    n = this.videocursendpacketsLost - this.videolastsendpacketsLost;
                    this.videolastsendpacketsLost = this.videocursendpacketsLost;
                    this.packetslostrate.addvideopackslost(n2, n);
                    rtcStatistics.localVideoPacketsLostrate = this.packetslostrate.getvideopackslostrate();
                    hashMap4.put("vsize", string + "x" + string4);
                    hashMap4.put("vfps", map.get("googFrameRateInput") + "/" + map.get("googFrameRateSent"));
                    hashMap4.put("vlost", map.get("packetsLost"));
                    hashMap4.put("vrtt", map.get("googRtt"));
                    if (map.containsKey("googFrameWidthInput")) {
                        rtcStatistics.localCaptureWidth = Integer.parseInt(map.get("googFrameWidthInput"));
                    }
                    if (map.containsKey("googFrameHeightInput")) {
                        rtcStatistics.localCaptureHeight = Integer.parseInt(map.get("googFrameHeightInput"));
                    }
                    if (map.containsKey("googFrameWidthSent")) {
                        rtcStatistics.localEncodedWidth = Integer.parseInt(map.get("googFrameWidthSent"));
                    }
                    if (map.containsKey("googFrameHeightSent")) {
                        rtcStatistics.localEncodedHeight = Integer.parseInt(map.get("googFrameHeightSent"));
                    }
                    if (map.containsKey("googFrameRateInput")) {
                        rtcStatistics.localCaptureFps = Integer.parseInt(map.get("googFrameRateInput"));
                    }
                    if (map.containsKey("googFrameRateSent")) {
                        rtcStatistics.localEncodedFps = Integer.parseInt(map.get("googFrameRateSent"));
                    }
                    if (map.containsKey("packetsLost")) {
                        rtcStatistics.localVideoPacketsLost = Integer.parseInt(map.get("packetsLost"));
                    }
                    if (!map.containsKey("googRtt")) continue;
                    rtcStatistics.localVideoRtt = Integer.parseInt(map.get("googRtt"));
                    continue;
                }
                if (map.get("bytesReceived") != null) {
                    this.ruseacodectype = string2;
                    hashMap3.put("acodec", string2);
                    hashMap3.put("alost", map.get("packetsLost"));
                    hashMap3.put("abytes", map.get("bytesReceived"));
                    this.remoteAudioBW.update(map.get("bytesReceived"));
                    if (map.containsKey("bytesReceived")) {
                        this.audiorecvbytes = Integer.parseInt(map.get("bytesReceived"));
                    }
                    if (map.containsKey("packetsReceived")) {
                        this.audiocurrecvpackets = Integer.parseInt(map.get("packetsReceived"));
                    }
                    int n3 = this.audiocurrecvpackets - this.audiolastrecvpackets;
                    this.audiolastrecvpackets = this.audiocurrecvpackets;
                    if (map.containsKey("packetsLost")) {
                        this.audiocurrecvpacketsLost = Integer.parseInt(map.get("packetsLost"));
                    }
                    int n4 = this.audiocurrecvpacketsLost - this.audiolastrecvpacketsLost;
                    this.audiolastrecvpacketsLost = this.audiocurrecvpacketsLost;
                    this.recvpacketslostrate.addaudiopackslost(n3, n4);
                    rtcStatistics.remoteAudioPacketsLostrate = this.recvpacketslostrate.getaudiopackslostrate();
                    hashMap5.put("alost", map.get("packetsLost"));
                    hashMap5.put("artt", map.get("googRtt"));
                    if (!map.containsKey("packetsLost")) continue;
                    rtcStatistics.remoteAudioPacketsLost = Integer.parseInt(map.get("packetsLost"));
                    continue;
                }
                if (map.get("bytesSent") == null) continue;
                this.luseacodectype = string2;
                hashMap2.put("acodec", string2);
                hashMap2.put("alost", map.get("packetsLost"));
                hashMap2.put("abytes", map.get("bytesSent"));
                this.localAudioBW.update(map.get("bytesSent"));
                hashMap4.put("alost", map.get("packetsLost"));
                hashMap4.put("abytes", map.get("bytesSent"));
                hashMap4.put("abytes", map.get("bytesSent"));
                hashMap4.put("artt", map.get("googRtt"));
                if (map.containsKey("bytesSent")) {
                    this.audiosendbytes = Integer.parseInt(map.get("bytesSent"));
                }
                if (map.containsKey("packetsSent")) {
                    this.audiocursendpackets = Integer.parseInt(map.get("packetsSent"));
                }
                int n5 = this.audiocursendpackets - this.audiolastsendpackets;
                this.audiolastsendpackets = this.audiocursendpackets;
                if (map.containsKey("packetsLost")) {
                    this.audiocursendpacketsLost = Integer.parseInt(map.get("packetsLost"));
                    rtcStatistics.localAudioPacketsLost = Integer.parseInt(map.get("packetsLost"));
                }
                int n6 = this.audiocursendpacketsLost - this.audiolastsendpacketsLost;
                this.audiolastsendpacketsLost = this.audiocursendpacketsLost;
                this.packetslostrate.addaudiopackslost(n5, n6);
                rtcStatistics.localAudioPacketsLostrate = this.packetslostrate.getaudiopackslostrate();
                if (!map.containsKey("googRtt")) continue;
                rtcStatistics.localAudioRtt = Integer.parseInt(map.get("googRtt"));
                continue;
            }
            if (!statsReport.type.equals("VideoBwe")) continue;
            hashMap2.put("vbr", map.get("googActualEncBitrate") + "/" + map.get("googTargetEncBitrate"));
            if (map.containsKey("googActualEncBitrate") && map.containsKey("googTargetEncBitrate")) {
                hashMap4.put("vbr", Integer.parseInt(map.get("googActualEncBitrate")) / 1000 + "/" + Integer.parseInt(map.get("googTargetEncBitrate")) / 1000);
            }
            if (map.containsKey("googActualEncBitrate")) {
                rtcStatistics.localVideoActualBps = Integer.parseInt(map.get("googActualEncBitrate")) / 1000;
            }
            if (!map.containsKey("googTargetEncBitrate")) continue;
            rtcStatistics.localVideoTargetBps = Integer.parseInt(map.get("googTargetEncBitrate")) / 1000;
        }
        if (hashMap.get(STAT_KEY_CONNECTION) == null) {
            hashMap.put(STAT_KEY_CONNECTION, "disconnect");
        }
        String string = "";
        String string5 = "";
        String string6 = string + RtcConnection.makeStatLine(hashMap, STAT_KEY_CONNECTION, "");
        string5 = string5 + RtcConnection.makeStatLine(hashMap, STAT_KEY_CONNECTION, "");
        if (this.cpuMonitor != null) {
            String string7 = string6 + "CPU%: " + this.cpuMonitor.getCpuUsageCurrent() + "/" + this.cpuMonitor.getCpuUsageAverage();
        }
        if (hashMap2.size() > 0) {
            void var8_12;
            hashMap2.put("vbps", String.valueOf(this.localVideoBW.getBitrateString()));
            hashMap2.put("abps", String.valueOf(this.localAudioBW.getBitrateString()));
            hashMap4.put("abps", String.valueOf(this.localAudioBW.getBitrateString()));
            rtcStatistics.localAudioBps = Integer.parseInt(this.localAudioBW.getBitrateString());
            String string21 = (String)var8_12 + "\r\n";
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vlcodec", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vinsize", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vsize", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vfps", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vrtt", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vlost", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vbytes", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vbps", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vbr", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "acodec", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "alost", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "abytes", "");
            string21 = string21 + RtcConnection.makeStatLine(hashMap2, "abps", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap2, "vlcodec", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vsize", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vfps", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vrtt", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vlost", "");
            string5 = string5 + "vlostrate: " + rtcStatistics.localVideoPacketsLostrate + "\r\n";
            string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vbr", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap4, "alost", "");
            string5 = string5 + "alostrate: " + rtcStatistics.localAudioPacketsLostrate + "\r\n";
            string5 = string5 + RtcConnection.makeStatLine(hashMap4, "artt", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap4, "abps", "");
        }
        if (hashMap3.size() > 0) {
            void var8_27;
            hashMap3.put("vbps", String.valueOf(this.remoteVideoBW.getBitrateString()));
            hashMap3.put("abps", String.valueOf(this.remoteAudioBW.getBitrateString()));
            hashMap5.put("vbps", String.valueOf(this.remoteVideoBW.getBitrateString()));
            hashMap5.put("abps", String.valueOf(this.remoteAudioBW.getBitrateString()));
            rtcStatistics.remoteVideoBps = Integer.parseInt(this.remoteVideoBW.getBitrateString());
            rtcStatistics.remoteAudioBps = Integer.parseInt(this.remoteAudioBW.getBitrateString());
            String string33 = (String)var8_27 + "\r\n";
            string33 = string33 + "remote:\r\n";
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vcodec", "");
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vsize", "");
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vfps", "");
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vlost", "");
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vbytes", "");
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vbps", "");
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "acodec", "");
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "alost", "");
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "abytes", "");
            string33 = string33 + RtcConnection.makeStatLine(hashMap3, "abps", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vcodec", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vsize", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vfps", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vlost", "");
            string5 = string5 + "vlostrate: " + rtcStatistics.remoteVideoPacketsLostrate + "\r\n";
            string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vbps", "");
            string5 = string5 + RtcConnection.makeStatLine(hashMap5, "alost", "");
            string5 = string5 + "alostrate: " + rtcStatistics.remoteAudioPacketsLostrate + "\r\n";
            string5 = string5 + RtcConnection.makeStatLine(hashMap5, "abps", "");
        }
        rtcStatistics.fullStatsString = string5;
        return rtcStatistics;
    }

    static {
        mirrorType = MIRROR.AUTO;
        DEFAULT_CONFIG_MINKBPS = 80;
        sLogListener = (n, string) -> Log.i((String)TAG, (String)string);
        minVideoKbps = DEFAULT_CONFIG_MINKBPS;
        loglevel = 6;
        audioSampleRate = 16000;
        callAudioSource = -1;
        useStereoInput = false;
        use2channels = false;
        audioRecordErrorCallback = new JavaAudioDeviceModule.AudioRecordErrorCallback(){

            @Override
            public void onWebRtcAudioRecordInitError(String string) {
                sLogListener.onLog(loglevel, "::: onWebRtcAudioRecordInitError: " + string);
                if (rtcListener != null) {
                    rtcListener.onError(RtcListener.RTCError.OPEN_MIC_FAIL);
                }
            }

            @Override
            public void onWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode audioRecordStartErrorCode, String string) {
                sLogListener.onLog(loglevel, "::: onWebRtcAudioRecordStartError: " + (Object)((Object)audioRecordStartErrorCode) + ". " + string);
                if (rtcListener != null) {
                    rtcListener.onError(RtcListener.RTCError.OPEN_MIC_FAIL);
                }
            }

            @Override
            public void onWebRtcAudioRecordError(String string) {
                sLogListener.onLog(loglevel, "::: onWebRtcAudioRecordError: " + string);
                if (rtcListener != null) {
                    rtcListener.onError(RtcListener.RTCError.OPEN_MIC_FAIL);
                }
            }
        };
    }

    public static class RtcStatistics {
        public String connectionType = "disconnect";
        public int localCaptureWidth = 0;
        public int localCaptureHeight = 0;
        public int localCaptureFps = 0;
        public int localEncodedWidth = 0;
        public int localEncodedHeight = 0;
        public int localEncodedFps = 0;
        public int localVideoActualBps = 0;
        public int localVideoTargetBps = 0;
        public int localVideoPacketsLost = 0;
        public int localVideoPacketsLostrate = 0;
        public int localVideoRtt = 0;
        public int localAudioPacketsLost = 0;
        public int localAudioPacketsLostrate = 0;
        public int localAudioBps = 0;
        public int localAudioRtt = 0;
        public int remoteWidth = 0;
        public int remoteHeight = 0;
        public int remoteFps = 0;
        public int remoteVideoPacketsLost = 0;
        public int remoteVideoPacketsLostrate = 0;
        public int remoteVideoBps = 0;
        public int remoteAudioPacketsLost = 0;
        public int remoteAudioPacketsLostrate = 0;
        public int remoteAudioBps = 0;
        public String fullStatsString = "fullStats";
    }

    public static interface LogListener {
        public void onLog(int var1, String var2);
    }

    public static interface Listener {
        public void onLocalSdp(RtcConnection var1, String var2);

        public void onLocalCandidate(RtcConnection var1, String var2);

        public void onConnected(RtcConnection var1);

        public void onConnectionsetup(RtcConnection var1);

        public void onDisconnected(RtcConnection var1);

        public void onCandidateCompleted(RtcConnection var1);

        public void onClosed(RtcConnection var1);

        public void onStats(RtcConnection var1, RtcStatistics var2);

        public void onError(RtcConnection var1, String var2);

        public static class ListenerAdapter
        implements PeerConnectionEvents {
            private Listener listener;

            public ListenerAdapter(Listener listener) {
                this.listener = listener;
            }

            @Override
            public void onLocalDescription(RtcConnection rtcConnection, String string) {
                if (this.listener != null) {
                    this.listener.onLocalSdp(rtcConnection, string);
                }
            }

            @Override
            public void onIceCandidate(RtcConnection rtcConnection, String string) {
                if (this.listener != null) {
                    this.listener.onLocalCandidate(rtcConnection, string);
                }
            }

            @Override
            public void onIceCandidatesRemoved(RtcConnection rtcConnection, IceCandidate[] iceCandidateArray) {
            }

            @Override
            public void onIceConnected(RtcConnection rtcConnection) {
                if (this.listener != null) {
                    this.listener.onConnectionsetup(rtcConnection);
                }
            }

            @Override
            public void onIceReconnected(RtcConnection rtcConnection) {
                if (this.listener != null) {
                    this.listener.onConnected(rtcConnection);
                }
            }

            @Override
            public void onIceDisconnected(RtcConnection rtcConnection) {
                if (this.listener != null) {
                    this.listener.onDisconnected(rtcConnection);
                }
            }

            @Override
            public void onCandidateCompleted(RtcConnection rtcConnection) {
                if (this.listener != null) {
                    this.listener.onCandidateCompleted(rtcConnection);
                }
            }

            @Override
            public void onPeerConnectionClosed(RtcConnection rtcConnection) {
                if (this.listener != null) {
                    this.listener.onClosed(rtcConnection);
                }
            }

            @Override
            public void onPeerConnectionStatsReady(RtcConnection rtcConnection, RtcStatistics rtcStatistics) {
                if (this.listener != null) {
                    this.listener.onStats(rtcConnection, rtcStatistics);
                }
            }

            @Override
            public void onPeerConnectionError(RtcConnection rtcConnection, String string) {
                if (this.listener != null) {
                    this.listener.onError(rtcConnection, string);
                }
            }
        }
    }

    public static class RtcContent {
        private static final String TYPE_OFFER = SessionDescription.Type.OFFER.name();
        private static final String TYPE_ANSWER = SessionDescription.Type.ANSWER.name();
        private static final String TYPE_PRANSWER = SessionDescription.Type.PRANSWER.name();
        private static final String TYPE_CANDIDATE = "candidate";
        String type;
        int mlineindex;
        String candidate;
        String sdp;
        long seq;
        String sdpMid;

        public boolean isSdp() {
            if (this.type == null) {
                return false;
            }
            return this.type.equalsIgnoreCase(TYPE_OFFER) || this.type.equalsIgnoreCase(TYPE_ANSWER) || this.type.equalsIgnoreCase(TYPE_PRANSWER);
        }

        public static RtcContent fromJson(String string) throws JSONException {
            RtcContent rtcContent = new RtcContent();
            JSONTokener jSONTokener = new JSONTokener(string);
            JSONObject jSONObject = (JSONObject)jSONTokener.nextValue();
            rtcContent.type = jSONObject.optString("type");
            rtcContent.mlineindex = jSONObject.optInt("mlineindex", -1);
            rtcContent.candidate = jSONObject.optString(TYPE_CANDIDATE, null);
            rtcContent.sdp = jSONObject.optString("sdp", null);
            rtcContent.seq = jSONObject.optLong("seq", -1L);
            rtcContent.sdpMid = jSONObject.optString("mid", "0");
            return rtcContent;
        }

        protected static String candidate2Json(IceCandidate iceCandidate, long l, String string) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("type", (Object)TYPE_CANDIDATE);
                jSONObject.put("mlineindex", iceCandidate.sdpMLineIndex);
                jSONObject.put("mid", (Object)iceCandidate.sdpMid);
                jSONObject.put(TYPE_CANDIDATE, (Object)iceCandidate.sdp);
                jSONObject.put("connId", (Object)string);
                jSONObject.put("seq", l);
                String string2 = jSONObject.toString();
                return string2;
            }
            catch (JSONException jSONException) {
                ALog.i(RtcConnection.TAG, "Exception: " + jSONException.getMessage());
                jSONException.printStackTrace();
                return null;
            }
        }

        protected static String SDP2Json(SessionDescription sessionDescription, long l, String string) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("type", (Object)sessionDescription.type.toString().toLowerCase());
                jSONObject.put("sdp", (Object)sessionDescription.description);
                jSONObject.put("seq", l);
                jSONObject.put("connId", (Object)string);
                String string2 = jSONObject.toString();
                return string2;
            }
            catch (JSONException jSONException) {
                ALog.i(RtcConnection.TAG, "Exception: " + jSONException.getMessage());
                jSONException.printStackTrace();
                return null;
            }
        }
    }

    public static class RtcConnectionParameters
    extends PeerConnectionParameters {
        public boolean receiveVideo;
        public boolean receiveAudio;
        public boolean captureVideo;
        public boolean captureAudio;
        public boolean shareScreen;
        public int relayVideoMaxKbps;
        public int videoStartBitrate;
        public int audioMaxKbps = 24;
        public int relayAudioMaxKbps = 24;
        public boolean disablePranswer;
        public boolean enableRelay;
        public String aecDumpFileName;
        private boolean enableExternalVideoData;
        private boolean enableExternalAudioData;

        public RtcConnectionParameters() {
            this.videoCallEnabled = true;
            this.videoCodec = "H264";
            this.audioCodec = RtcConnection.AUDIO_CODEC_OPUS;
            this.audioStartBitrate = 8;
            this.videoFps = 15;
            this.videoMaxBitrate = 1500;
            this.videoCodecHwAcceleration = true;
            this.receiveVideo = true;
            this.receiveAudio = true;
            this.captureVideo = true;
            this.captureAudio = true;
            this.shareScreen = false;
            this.videoStartBitrate = 120;
        }
    }

    private static class ProxyVideoSink
    implements VideoSink {
        private VideoSink target;

        private ProxyVideoSink() {
        }

        @Override
        public synchronized void onFrame(VideoFrame videoFrame) {
            if (this.target == null) {
                Logging.d(RtcConnection.TAG, "Dropping frame in proxy because target is null." + this.target);
                return;
            }
            this.target.onFrame(videoFrame);
        }

        public synchronized void setTarget(VideoSink videoSink) {
            this.target = videoSink;
        }
    }

    private class SDPObserver
    implements SdpObserver {
        private SDPObserver() {
        }

        @Override
        public void onCreateSuccess(SessionDescription sessionDescription) {
            executor.execute(() -> {
                sLogListener.onLog(loglevel, "create local sdp success start -0-");
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip set local because of conn is already hangup!");
                    return;
                }
                String string = sessionDescription.description;
                string = RtcConnection.preferCodec(string, RtcConnection.AUDIO_CODEC_ISAC, true);
                string = RtcConnection.preferCodec(string, RtcConnection.getSdpVideoCodecName(RtcConnection.this.peerConnectionParameters), false);
                string = RtcConnection.this.preferCandidates(string);
                string = RtcConnection.this.ssrcChanger.changeSSRC(string);
                SessionDescription.Type type = sessionDescription.type;
                if (RtcConnection.this.isPranswerState && !((RtcConnection)RtcConnection.this).peerConnectionParameters.disablePranswer) {
                    string = string.replaceAll("a=recvonly", "a=inactive");
                    string = RtcConnection.this.ssrcChanger.processPranswer(string);
                    type = SessionDescription.Type.PRANSWER;
                }
                SessionDescription sessionDescription2 = new SessionDescription(type, string);
                RtcConnection.this.localSdp = sessionDescription2;
                sLogListener.onLog(loglevel, "::: Start to set local sdp to " + RtcConnection.this.peerConnection + ", sdp: " + (Object)((Object)sessionDescription2.type) + " - " + sessionDescription2.description);
                if (RtcConnection.this.peerConnection != null && !RtcConnection.this.checkError()) {
                    RtcConnection.this.peerConnection.setLocalDescription(RtcConnection.this.sdpObserver, sessionDescription2);
                }
            });
        }

        @Override
        public void onSetSuccess() {
            executor.execute(() -> {
                if (RtcConnection.this.peerConnection == null || RtcConnection.this.checkError()) {
                    return;
                }
                if (RtcConnection.this.isInitiator) {
                    if (RtcConnection.this.peerConnection.getRemoteDescription() == null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Local SDP set succesfully");
                        if (!RtcConnection.this.isHangup) {
                            RtcConnection.this.events.onLocalDescription(RtcConnection.this, RtcContent.SDP2Json(RtcConnection.this.localSdp, RtcConnection.this.getLocalSeq(), "connectionId"));
                            sLogListener.onLog(loglevel, "::: Set local sdp:" + ((RtcConnection)RtcConnection.this).localSdp.description);
                        }
                    } else {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Remote SDP set succesfully");
                        RtcConnection.this.drainCandidates();
                    }
                } else if (RtcConnection.this.peerConnection.getLocalDescription() != null) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Local SDP set succesfully");
                    if (!RtcConnection.this.isHangup) {
                        RtcConnection.this.events.onLocalDescription(RtcConnection.this, RtcContent.SDP2Json(RtcConnection.this.localSdp, RtcConnection.this.getLocalSeq(), "connectionId"));
                    }
                    RtcConnection.this.drainCandidates();
                } else {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Remote SDP set succesfully");
                }
            });
        }

        @Override
        public void onCreateFailure(String string) {
            RtcConnection.this.reportError("createSDP error: " + string);
        }

        @Override
        public void onSetFailure(String string) {
            RtcConnection.this.reportError("setSDP error: " + string);
        }
    }

    private class PCObserver
    implements PeerConnection.Observer {
        private PCObserver() {
        }

        @Override
        public void onIceCandidate(IceCandidate iceCandidate) {
            Log.i((String)RtcConnection.TAG, (String)("onIceCandidate: " + iceCandidate.toString()));
            executor.execute(() -> {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onIceCandidate");
                RtcConnection.this.events.onIceCandidate(RtcConnection.this, RtcContent.candidate2Json(iceCandidate, RtcConnection.this.getLocalSeq(), "connectionId"));
            });
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] iceCandidateArray) {
            executor.execute(() -> {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onIceCandidatesRemoved");
                RtcConnection.this.events.onIceCandidatesRemoved(RtcConnection.this, iceCandidateArray);
            });
        }

        @Override
        public void onSignalingChange(PeerConnection.SignalingState signalingState) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onSignalingChange: " + (Object)((Object)signalingState));
        }

        @Override
        public void onIceConnectionChange(PeerConnection.IceConnectionState iceConnectionState) {
            executor.execute(() -> {
                if (iceConnectionState == PeerConnection.IceConnectionState.CONNECTED) {
                    if (!RtcConnection.this.isConnected) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onIceConnected");
                        if (!RtcConnection.this.isHangup) {
                            RtcConnection.this.events.onIceConnected(RtcConnection.this);
                        }
                        RtcConnection.this.isConnected = true;
                    } else {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onIceReconnected");
                        if (!RtcConnection.this.isHangup) {
                            RtcConnection.this.events.onIceReconnected(RtcConnection.this);
                        }
                    }
                } else if (iceConnectionState == PeerConnection.IceConnectionState.DISCONNECTED) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onIceDisconnected");
                    if (!RtcConnection.this.isHangup) {
                        RtcConnection.this.events.onIceDisconnected(RtcConnection.this);
                    }
                } else if (iceConnectionState == PeerConnection.IceConnectionState.FAILED) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onIceConnectFailed");
                    RtcConnection.this.reportError("ICE connection failed.");
                }
            });
        }

        @Override
        public void onIceGatheringChange(PeerConnection.IceGatheringState iceGatheringState) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onIceGatheringChange: " + (Object)((Object)iceGatheringState));
            if (iceGatheringState == PeerConnection.IceGatheringState.COMPLETE) {
                executor.execute(() -> {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onCandidateCompleted");
                    if (!RtcConnection.this.isHangup) {
                        RtcConnection.this.events.onCandidateCompleted(RtcConnection.this);
                    }
                });
            }
        }

        @Override
        public void onIceConnectionReceivingChange(boolean bl) {
            sLogListener.onLog(loglevel, "onIceConnectionReceivingChange: " + bl);
        }

        @Override
        public void onAddStream(MediaStream mediaStream) {
            executor.execute(() -> {
                sLogListener.onLog(loglevel, "onAddStream: ");
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip onAddStream because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.peerConnection == null) {
                    sLogListener.onLog(loglevel, "onAddStream, but peerConnection is null.");
                    return;
                }
                RtcConnection.this.findRemoteTracks();
                if (RtcConnection.this.remoteVideoTrack == null) {
                    sLogListener.onLog(loglevel, "onAddStream, but remoteVideoTrack is null.");
                    return;
                }
                RtcConnection.this.remoteVideoTrack.setEnabled(RtcConnection.this.renderVideo);
                RtcConnection.this.remoteVideoTrack.addSink(RtcConnection.this.remoteProxyVideoSink);
            });
        }

        @Override
        public void onRemoveStream(MediaStream mediaStream) {
            executor.execute(() -> {
                sLogListener.onLog(loglevel, "onRemoveStream: ");
                if (RtcConnection.this.peerConnection == null) {
                    return;
                }
                RtcConnection.this.remoteVideoTrack = null;
                if (mediaStream.videoTracks.size() == 0) {
                    return;
                }
                mediaStream.videoTracks.get(0).dispose();
            });
        }

        @Override
        public void onDataChannel(final DataChannel dataChannel) {
            Log.i((String)RtcConnection.TAG, (String)("New Data channel " + dataChannel.label()));
            if (!RtcConnection.this.dataChannelEnabled) {
                return;
            }
            dataChannel.registerObserver(new DataChannel.Observer(){

                @Override
                public void onBufferedAmountChange(long l) {
                    Log.i((String)RtcConnection.TAG, (String)("Data channel buffered amount changed: " + dataChannel.label() + ": " + (Object)((Object)dataChannel.state())));
                }

                @Override
                public void onStateChange() {
                    Log.i((String)RtcConnection.TAG, (String)("Data channel state changed: " + dataChannel.label() + ": " + (Object)((Object)dataChannel.state())));
                }

                @Override
                public void onMessage(DataChannel.Buffer buffer) {
                    if (buffer.binary) {
                        Log.i((String)RtcConnection.TAG, (String)("Received binary msg over " + dataChannel));
                        return;
                    }
                    ByteBuffer byteBuffer = buffer.data;
                    byte[] byArray = new byte[byteBuffer.capacity()];
                    byteBuffer.get(byArray);
                    String string = new String(byArray, Charset.forName("UTF-8"));
                    Log.i((String)RtcConnection.TAG, (String)("Got msg: " + string + " over " + dataChannel));
                }
            });
        }

        @Override
        public void onRenegotiationNeeded() {
            sLogListener.onLog(loglevel, "onRenegotiationNeeded: ");
        }

        @Override
        public void onAddTrack(RtpReceiver rtpReceiver, MediaStream[] mediaStreamArray) {
            sLogListener.onLog(loglevel, "onAddTrack: ");
        }
    }

    public static interface PeerConnectionEvents {
        public void onLocalDescription(RtcConnection var1, String var2);

        public void onIceCandidate(RtcConnection var1, String var2);

        public void onIceCandidatesRemoved(RtcConnection var1, IceCandidate[] var2);

        public void onIceConnected(RtcConnection var1);

        public void onIceReconnected(RtcConnection var1);

        public void onIceDisconnected(RtcConnection var1);

        public void onCandidateCompleted(RtcConnection var1);

        public void onPeerConnectionClosed(RtcConnection var1);

        public void onPeerConnectionStatsReady(RtcConnection var1, RtcStatistics var2);

        public void onPeerConnectionError(RtcConnection var1, String var2);
    }

    public static class PeerConnectionParameters {
        public boolean videoCallEnabled;
        public boolean loopback;
        public boolean tracing;
        public int videoWidth;
        public int videoHeight;
        public int videoFps;
        public int videoMaxBitrate;
        public String videoCodec;
        public boolean videoCodecHwAcceleration;
        public boolean videoFlexfecEnabled;
        public int audioStartBitrate;
        public String audioCodec;
        public boolean noAudioProcessing;
        public boolean saveInputAudioToFile;
        public boolean useOpenSLES;
        public boolean disableBuiltInAEC;
        public boolean disableBuiltInAGC;
        public boolean disableBuiltInNS;
        public boolean disableWebRtcAGCAndHPF;
        public boolean enableRtcEventLog;
        protected DataChannelParameters dataChannelParameters;

        public PeerConnectionParameters(boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4, String string, boolean bl4, boolean bl5, int n5, String string2, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, DataChannelParameters dataChannelParameters) {
            this.videoCallEnabled = bl;
            this.loopback = bl2;
            this.tracing = bl3;
            this.videoWidth = n;
            this.videoHeight = n2;
            this.videoFps = n3;
            this.videoMaxBitrate = n4;
            this.videoCodec = string;
            this.videoFlexfecEnabled = bl5;
            this.videoCodecHwAcceleration = bl4;
            this.audioStartBitrate = n5;
            this.audioCodec = string2;
            this.noAudioProcessing = bl6;
            this.saveInputAudioToFile = bl8;
            this.useOpenSLES = bl9;
            this.disableBuiltInAEC = bl10;
            this.disableBuiltInAGC = bl11;
            this.disableBuiltInNS = bl12;
            this.disableWebRtcAGCAndHPF = bl13;
            this.enableRtcEventLog = bl14;
            this.dataChannelParameters = dataChannelParameters;
        }

        public PeerConnectionParameters() {
        }
    }

    public static class DataChannelParameters {
        public final boolean ordered;
        public final int maxRetransmitTimeMs;
        public final int maxRetransmits;
        public final String protocol;
        public final boolean negotiated;
        public final int id;

        public DataChannelParameters(boolean bl, int n, int n2, String string, boolean bl2, int n3) {
            this.ordered = bl;
            this.maxRetransmitTimeMs = n;
            this.maxRetransmits = n2;
            this.protocol = string;
            this.negotiated = bl2;
            this.id = n3;
        }
    }

    public static enum FORMAT {
        NV21,
        I420;

    }

    public static enum MIRROR {
        AUTO,
        ON,
        OFF;

    }
}

