/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import com.superrtc.CalledByNative;
import com.superrtc.Logging;
import com.superrtc.audio.WebRtcAudioUtils;

class WebRtcAudioManager {
    private static final String TAG = "WebRtcAudioManagerExternal";
    private static final int DEFAULT_SAMPLE_RATE_HZ = 16000;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;

    WebRtcAudioManager() {
    }

    @CalledByNative
    static AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    @CalledByNative
    static int getOutputBufferSize(Context context, AudioManager audioManager, int n, int n2) {
        return WebRtcAudioManager.isLowLatencyOutputSupported(context) ? WebRtcAudioManager.getLowLatencyFramesPerBuffer(audioManager) : WebRtcAudioManager.getMinOutputFrameSize(n, n2);
    }

    @CalledByNative
    static int getInputBufferSize(Context context, AudioManager audioManager, int n, int n2) {
        return WebRtcAudioManager.isLowLatencyInputSupported(context) ? WebRtcAudioManager.getLowLatencyFramesPerBuffer(audioManager) : WebRtcAudioManager.getMinInputFrameSize(n, n2);
    }

    private static boolean isLowLatencyOutputSupported(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private static boolean isLowLatencyInputSupported(Context context) {
        return Build.VERSION.SDK_INT >= 21 && WebRtcAudioManager.isLowLatencyOutputSupported(context);
    }

    @CalledByNative
    static int getSampleRate(AudioManager audioManager) {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Logging.d(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        int n = WebRtcAudioManager.getSampleRateForApiLevel(audioManager);
        Logging.d(TAG, "Sample rate is set to " + n + " Hz");
        return n;
    }

    private static int getSampleRateForApiLevel(AudioManager audioManager) {
        if (Build.VERSION.SDK_INT < 17) {
            return 16000;
        }
        String string = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return string == null ? 16000 : Integer.parseInt(string);
    }

    private static int getLowLatencyFramesPerBuffer(AudioManager audioManager) {
        if (Build.VERSION.SDK_INT < 17) {
            return 256;
        }
        String string = audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return string == null ? 256 : Integer.parseInt(string);
    }

    private static int getMinOutputFrameSize(int n, int n2) {
        int n3 = n2 * 2;
        int n4 = n2 == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)n, (int)n4, (int)2) / n3;
    }

    private static int getMinInputFrameSize(int n, int n2) {
        int n3 = n2 * 2;
        int n4 = n2 == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)n, (int)n4, (int)2) / n3;
    }
}

