/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.superrtc.EglBase;
import com.superrtc.GlUtil;
import com.superrtc.Logging;
import com.superrtc.NV21Buffer;
import com.superrtc.RefCounted;
import com.superrtc.RendererCommon;
import com.superrtc.TextureBufferImpl;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoFrame;
import com.superrtc.VideoSink;
import com.superrtc.YuvConverter;
import com.superrtc.watermark.Watermark;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class SurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private final Handler handler;
    private final EglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private final YuvConverter yuvConverter = new YuvConverter();
    private Watermark watermark = null;
    @Nullable
    private VideoSink listener;
    private boolean hasPendingTexture;
    private volatile boolean isTextureInUse;
    private boolean isQuitting;
    private int frameRotation;
    private int textureWidth = 0;
    private int textureHeight = 0;
    @Nullable
    private VideoSink pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            Logging.d(SurfaceTextureHelper.TAG, "Setting listener to " + SurfaceTextureHelper.this.pendingListener);
            SurfaceTextureHelper.this.listener = SurfaceTextureHelper.this.pendingListener;
            SurfaceTextureHelper.this.pendingListener = null;
            if (SurfaceTextureHelper.this.hasPendingTexture) {
                SurfaceTextureHelper.this.updateTexImage();
                SurfaceTextureHelper.this.hasPendingTexture = false;
            }
        }
    };

    public static SurfaceTextureHelper create(final String string, final EglBase.Context context) {
        HandlerThread handlerThread = new HandlerThread(string);
        handlerThread.start();
        final Handler handler = new Handler(handlerThread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<SurfaceTextureHelper>(){

            @Override
            @Nullable
            public SurfaceTextureHelper call() {
                try {
                    return new SurfaceTextureHelper(context, handler);
                }
                catch (RuntimeException runtimeException) {
                    Logging.e(SurfaceTextureHelper.TAG, string + " create failure", runtimeException);
                    return null;
                }
            }
        });
    }

    private SurfaceTextureHelper(EglBase.Context context, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException runtimeException) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw runtimeException;
        }
        this.oesTextureId = GlUtil.createExternalTextureObject();
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        SurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, surfaceTexture -> {
            this.hasPendingTexture = true;
            this.tryDeliverTextureFrame();
        }, handler);
    }

    public void setWatermark(Watermark watermark) {
        this.watermark = watermark;
    }

    public Watermark GetWatermark() {
        return this.watermark;
    }

    public void setCameraInfo(boolean bl) {
        this.yuvConverter.setCameraInfo(bl);
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener);
        }
    }

    public void startListening(VideoSink videoSink) {
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        this.pendingListener = videoSink;
        this.handler.post(this.setListenerRunnable);
    }

    public void stopListening() {
        Logging.d(TAG, "stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> {
            this.listener = null;
            this.pendingListener = null;
        });
    }

    public void setTextureSize(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Texture width must be positive, but was " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Texture height must be positive, but was " + n2);
        }
        if (this.watermark != null) {
            this.yuvConverter.setWatermark(this.watermark, n, n2);
        }
        this.surfaceTexture.setDefaultBufferSize(n, n2);
        this.handler.post(() -> {
            this.textureWidth = n;
            this.textureHeight = n2;
        });
    }

    public void setFrameRotation(int n) {
        this.handler.post(() -> {
            this.frameRotation = n;
        });
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    private void returnTextureFrame() {
        this.handler.post(() -> {
            this.isTextureInUse = false;
            if (this.isQuitting) {
                this.release();
            } else {
                this.tryDeliverTextureFrame();
            }
        });
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> {
            this.isQuitting = true;
            if (!this.isTextureInUse) {
                this.release();
            }
        });
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        Object object = EglBase.lock;
        synchronized (object) {
            this.surfaceTexture.updateTexImage();
        }
    }

    private void tryDeliverTextureFrame() {
        VideoFrame.Buffer buffer;
        RefCounted refCounted;
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || !this.hasPendingTexture || this.isTextureInUse || this.listener == null) {
            return;
        }
        this.isTextureInUse = true;
        this.hasPendingTexture = false;
        this.updateTexImage();
        float[] fArray = new float[16];
        this.surfaceTexture.getTransformMatrix(fArray);
        long l = this.surfaceTexture.getTimestamp();
        if (this.textureWidth == 0 || this.textureHeight == 0) {
            throw new RuntimeException("Texture size has not been set.");
        }
        if (this.watermark != null) {
            refCounted = this.yuvConverter.convert(this.textureWidth, this.textureHeight, fArray, this.oesTextureId);
            buffer = new NV21Buffer(((NV21Buffer)refCounted).getData(), ((NV21Buffer)refCounted).getWidth(), ((NV21Buffer)refCounted).getHeight(), this::returnTextureFrame);
        } else {
            buffer = new TextureBufferImpl(this.textureWidth, this.textureHeight, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray), this.handler, this.yuvConverter, this::returnTextureFrame);
        }
        refCounted = new VideoFrame(buffer, this.frameRotation, l);
        this.listener.onFrame((VideoFrame)refCounted);
        ((VideoFrame)refCounted).release();
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isTextureInUse || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        this.yuvConverter.release();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }
}

