/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import com.superrtc.EglBase;
import com.superrtc.GlTextureFrameBuffer;
import com.superrtc.GlUtil;
import com.superrtc.Logging;
import com.superrtc.RendererCommon;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoFrame;
import com.superrtc.VideoFrameDrawer;
import com.superrtc.VideoSink;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class EglRenderer
implements VideoSink {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 10L;
    protected final String name;
    private final Object handlerLock = new Object();
    @Nullable
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    private final Object fpsReductionLock = new Object();
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    @Nullable
    private EglBase eglBase;
    private final VideoFrameDrawer frameDrawer = new VideoFrameDrawer();
    @Nullable
    private RendererCommon.GlDrawer drawer;
    private final Matrix drawMatrix = new Matrix();
    private final Object frameLock = new Object();
    @Nullable
    private VideoFrame pendingFrame;
    private final Object layoutLock = new Object();
    private float layoutAspectRatio;
    private boolean mirror;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private final GlTextureFrameBuffer bitmapTextureFramebuffer = new GlTextureFrameBuffer(6408);
    private final Runnable logStatisticsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EglRenderer.this.logStatistics();
            Object object = EglRenderer.this.handlerLock;
            synchronized (object) {
                if (EglRenderer.this.renderThreadHandler != null) {
                    EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                    EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(10L));
                }
            }
        }
    };
    private final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation();

    public EglRenderer(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@Nullable EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(this.name + "Already initialized");
            }
            this.logD("Initializing EglRenderer");
            this.drawer = glDrawer;
            HandlerThread handlerThread = new HandlerThread(this.name + TAG);
            handlerThread.start();
            this.renderThreadHandler = new Handler(handlerThread.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, () -> {
                if (context == null) {
                    this.logD("EglBase10.create context");
                    this.eglBase = EglBase.createEgl10(nArray);
                } else {
                    this.logD("EglBase.create shared context");
                    this.eglBase = EglBase.create(context, nArray);
                }
            });
            this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            long l = System.nanoTime();
            this.resetStatistics(l);
            this.renderThreadHandler.postDelayed(this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(10L));
        }
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    private void createEglSurfaceInternal(Object object) {
        this.eglSurfaceCreationRunnable.setSurface(object);
        this.postToRenderThread(this.eglSurfaceCreationRunnable);
    }

    public int getFramesReceived() {
        return this.framesReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.logD("Releasing.");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            this.renderThreadHandler.postAtFrontOfQueue(() -> {
                this.clearSurfaceOnRenderThread(0.0f, 0.0f, 0.0f, 0.0f);
                if (this.drawer != null) {
                    this.drawer.release();
                    this.drawer = null;
                }
                this.frameDrawer.release();
                this.bitmapTextureFramebuffer.release();
                if (this.eglBase != null) {
                    this.logD("eglBase detach and release.");
                    this.eglBase.detachCurrent();
                    this.eglBase.release();
                    this.eglBase = null;
                }
                this.frameListeners.clear();
                countDownLatch.countDown();
            });
            Looper looper = this.renderThreadHandler.getLooper();
            this.renderThreadHandler.post(() -> {
                this.logD("Quitting render thread.");
                looper.quit();
            });
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                this.pendingFrame.release();
                this.pendingFrame = null;
            }
        }
        this.logD("Releasing done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long l) {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.statisticsStartTimeNs = l;
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.renderTimeNs = 0L;
            this.renderSwapBufferTimeNs = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        Object object = this.handlerLock;
        synchronized (object) {
            StackTraceElement[] stackTraceElementArray;
            Thread thread;
            Thread thread2 = thread = this.renderThreadHandler == null ? null : this.renderThreadHandler.getLooper().getThread();
            if (thread != null && (stackTraceElementArray = thread.getStackTrace()).length > 0) {
                this.logD("EglRenderer stack trace:");
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    this.logD(stackTraceElement.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean bl) {
        this.logD("setMirror: " + bl);
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float f2) {
        this.logD("setLayoutAspectRatio: " + f2);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float f2) {
        this.logD("setFpsReduction: " + f2);
        Object object = this.fpsReductionLock;
        synchronized (object) {
            long l = this.minRenderPeriodNs;
            this.minRenderPeriodNs = f2 <= 0.0f ? Long.MAX_VALUE : (long)((float)TimeUnit.SECONDS.toNanos(1L) / f2);
            if (this.minRenderPeriodNs != l) {
                this.nextFrameTimeNs = System.nanoTime();
            }
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener frameListener, float f2) {
        this.addFrameListener(frameListener, f2, null, false);
    }

    public void addFrameListener(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer) {
        this.addFrameListener(frameListener, f2, glDrawer, false);
    }

    public void addFrameListener(FrameListener frameListener, float f2, @Nullable RendererCommon.GlDrawer glDrawer, boolean bl) {
        this.postToRenderThread(() -> {
            RendererCommon.GlDrawer glDrawer2 = glDrawer == null ? this.drawer : glDrawer;
            this.frameListeners.add(new FrameListenerAndParams(frameListener, f2, glDrawer2, bl));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameListener(FrameListener frameListener) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() == this.renderThreadHandler.getLooper().getThread()) {
                throw new RuntimeException("removeFrameListener must not be called on the render thread.");
            }
            this.postToRenderThread(() -> {
                countDownLatch.countDown();
                Iterator<FrameListenerAndParams> iterator = this.frameListeners.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().listener != frameListener) continue;
                    iterator.remove();
                }
            });
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame videoFrame) {
        boolean bl;
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        Object object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            Object object3 = this.frameLock;
            synchronized (object3) {
                boolean bl2 = bl = this.pendingFrame != null;
                if (bl) {
                    this.pendingFrame.release();
                }
                this.pendingFrame = videoFrame;
                this.pendingFrame.retain();
                this.renderThreadHandler.post(this::renderFrameOnRenderThread);
            }
        }
        if (bl) {
            object2 = this.statisticsLock;
            synchronized (object2) {
                ++this.framesDropped;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEglSurface(Runnable runnable) {
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                this.renderThreadHandler.postAtFrontOfQueue(() -> {
                    if (this.eglBase != null) {
                        this.eglBase.detachCurrent();
                        this.eglBase.releaseSurface();
                    }
                    runnable.run();
                });
                return;
            }
        }
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
        }
    }

    private void clearSurfaceOnRenderThread(float f2, float f3, float f4, float f5) {
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)f2, (float)f3, (float)f4, (float)f5);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImage(float f2, float f3, float f4, float f5) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(() -> this.clearSurfaceOnRenderThread(f2, f3, f4, f5));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrameOnRenderThread() {
        float f2;
        boolean bl;
        VideoFrame videoFrame;
        Object object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame == null) {
                return;
            }
            videoFrame = this.pendingFrame;
            this.pendingFrame = null;
        }
        if (this.eglBase == null || !this.eglBase.hasSurface()) {
            this.logD("Dropping frame - No surface");
            videoFrame.release();
            return;
        }
        Object object2 = this.fpsReductionLock;
        synchronized (object2) {
            if (this.minRenderPeriodNs == Long.MAX_VALUE) {
                bl = false;
            } else if (this.minRenderPeriodNs <= 0L) {
                bl = true;
            } else {
                long l = System.nanoTime();
                if (l < this.nextFrameTimeNs) {
                    this.logD("Skipping frame rendering - fps reduction is active.");
                    bl = false;
                } else {
                    this.nextFrameTimeNs += this.minRenderPeriodNs;
                    this.nextFrameTimeNs = Math.max(this.nextFrameTimeNs, l);
                    bl = true;
                }
            }
        }
        long l = System.nanoTime();
        float f3 = (float)videoFrame.getRotatedWidth() / (float)videoFrame.getRotatedHeight();
        Object object3 = this.layoutLock;
        synchronized (object3) {
            f2 = this.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : f3;
        }
        if (f3 > f2) {
            float f4 = f2 / f3;
            float f5 = 1.0f;
        } else {
            float f6 = 1.0f;
            float f7 = f3 / f2;
        }
        this.drawMatrix.reset();
        if (bl) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(videoFrame, this.drawer, this.drawMatrix, 0, 0, this.eglBase.surfaceWidth(), this.eglBase.surfaceHeight());
            long l2 = System.nanoTime();
            this.eglBase.swapBuffers();
            long l3 = System.nanoTime();
            Object object4 = this.statisticsLock;
            synchronized (object4) {
                ++this.framesRendered;
                this.renderTimeNs += l3 - l;
                this.renderSwapBufferTimeNs += l3 - l2;
            }
        }
        this.notifyCallbacks(videoFrame, bl);
        videoFrame.release();
    }

    private void notifyCallbacks(VideoFrame videoFrame, boolean bl) {
        if (this.frameListeners.isEmpty()) {
            return;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(1.0f, -1.0f);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        Iterator<FrameListenerAndParams> iterator = this.frameListeners.iterator();
        while (iterator.hasNext()) {
            FrameListenerAndParams frameListenerAndParams = iterator.next();
            if (!bl && frameListenerAndParams.applyFpsReduction) continue;
            iterator.remove();
            int n = (int)(frameListenerAndParams.scale * (float)videoFrame.getRotatedWidth());
            int n2 = (int)(frameListenerAndParams.scale * (float)videoFrame.getRotatedHeight());
            if (n == 0 || n2 == 0) {
                frameListenerAndParams.listener.onFrame(null);
                continue;
            }
            this.bitmapTextureFramebuffer.setSize(n, n2);
            GLES20.glBindFramebuffer((int)36160, (int)this.bitmapTextureFramebuffer.getFrameBufferId());
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.bitmapTextureFramebuffer.getTextureId(), (int)0);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(videoFrame, frameListenerAndParams.drawer, this.drawMatrix, 0, 0, n, n2);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * 4);
            GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
            GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)byteBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
            Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            frameListenerAndParams.listener.onFrame(bitmap);
        }
    }

    private String averageTimeAsString(long l, int n) {
        return n <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(l / (long)n) + " \u03bcs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        DecimalFormat decimalFormat = new DecimalFormat("#.0");
        long l = System.nanoTime();
        Object object = this.statisticsLock;
        synchronized (object) {
            long l2 = l - this.statisticsStartTimeNs;
            if (l2 <= 0L) {
                return;
            }
            float f2 = (float)((long)this.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)l2;
            Logging.e(TAG, "Duration: " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms. Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered + ". Render fps: " + decimalFormat.format(f2) + ". Average render time: " + this.averageTimeAsString(this.renderTimeNs, this.framesRendered) + ". Average swapBuffer time: " + this.averageTimeAsString(this.renderSwapBufferTimeNs, this.framesRendered) + ".");
            this.resetStatistics(l);
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.name + string);
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object object) {
            this.surface = object;
        }

        @Override
        public synchronized void run() {
            if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                if (this.surface instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else if (this.surface instanceof SurfaceTexture) {
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                } else {
                    throw new IllegalStateException("Invalid surface: " + this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer, boolean bl) {
            this.listener = frameListener;
            this.scale = f2;
            this.drawer = glDrawer;
            this.applyFpsReduction = bl;
        }
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }
}

