package com.hyphenate.push;

import android.text.TextUtils;

public enum EMPushType {
    FCM("FCM"),
    MIPUSH("MI"),
    HMSPUSH("HUAWEI"),
    MEIZUPUSH("MEIZU"),
    OPPOPUSH("OPPO"),
    VIVOPUSH("VIVO"),
    NORMAL("NORMAL");

    private String name;

    EMPushType(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static EMPushType getType(String name) {
        if (TextUtils.isEmpty(name)) {
            return NORMAL;
        } else {
            EMPushType[] var1 = values();
            int var2 = var1.length;

            for (int var3 = 0; var3 < var2; ++var3) {
                EMPushType type = var1[var3];
                if (type.getName().equals(name)) {
                    return type;
                }
            }

            return NORMAL;
        }
    }
}
