/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.CalledByNative;
import com.superrtc.JniCommon;
import com.superrtc.MediaStreamTrack;
import com.superrtc.RtpReceiver;
import com.superrtc.RtpSender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RtpTransceiver {
    private long nativeRtpTransceiver;
    private RtpSender cachedSender;
    private RtpReceiver cachedReceiver;

    @CalledByNative
    protected RtpTransceiver(long l) {
        this.nativeRtpTransceiver = l;
        this.cachedSender = RtpTransceiver.nativeGetSender(l);
        this.cachedReceiver = RtpTransceiver.nativeGetReceiver(l);
    }

    public MediaStreamTrack.MediaType getMediaType() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMediaType(this.nativeRtpTransceiver);
    }

    public String getMid() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMid(this.nativeRtpTransceiver);
    }

    public RtpSender getSender() {
        return this.cachedSender;
    }

    public RtpReceiver getReceiver() {
        return this.cachedReceiver;
    }

    public boolean isStopped() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeStopped(this.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getDirection() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeDirection(this.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getCurrentDirection() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeCurrentDirection(this.nativeRtpTransceiver);
    }

    public void setDirection(RtpTransceiverDirection rtpTransceiverDirection) {
        this.checkRtpTransceiverExists();
        RtpTransceiver.nativeSetDirection(this.nativeRtpTransceiver, rtpTransceiverDirection);
    }

    public void stop() {
        this.checkRtpTransceiverExists();
        RtpTransceiver.nativeStop(this.nativeRtpTransceiver);
    }

    @CalledByNative
    public void dispose() {
        this.checkRtpTransceiverExists();
        this.cachedSender.dispose();
        this.cachedReceiver.dispose();
        JniCommon.nativeReleaseRef(this.nativeRtpTransceiver);
        this.nativeRtpTransceiver = 0L;
    }

    private void checkRtpTransceiverExists() {
        if (this.nativeRtpTransceiver == 0L) {
            throw new IllegalStateException("RtpTransceiver has been disposed.");
        }
    }

    private static native MediaStreamTrack.MediaType nativeGetMediaType(long var0);

    private static native String nativeGetMid(long var0);

    private static native RtpSender nativeGetSender(long var0);

    private static native RtpReceiver nativeGetReceiver(long var0);

    private static native boolean nativeStopped(long var0);

    private static native RtpTransceiverDirection nativeDirection(long var0);

    private static native RtpTransceiverDirection nativeCurrentDirection(long var0);

    private static native void nativeStop(long var0);

    private static native void nativeSetDirection(long var0, RtpTransceiverDirection var2);

    public static final class RtpTransceiverInit {
        private final RtpTransceiverDirection direction;
        private final List<String> streamIds;

        public RtpTransceiverInit() {
            this(RtpTransceiverDirection.SEND_RECV);
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection) {
            this(rtpTransceiverDirection, Collections.emptyList());
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection, List<String> list) {
            this.direction = rtpTransceiverDirection;
            this.streamIds = new ArrayList<String>(list);
        }

        @CalledByNative(value="RtpTransceiverInit")
        int getDirectionNativeIndex() {
            return this.direction.getNativeIndex();
        }

        @CalledByNative(value="RtpTransceiverInit")
        List<String> getStreamIds() {
            return new ArrayList<String>(this.streamIds);
        }
    }

    public static enum RtpTransceiverDirection {
        SEND_RECV(0),
        SEND_ONLY(1),
        RECV_ONLY(2),
        INACTIVE(3);

        private final int nativeIndex;

        private RtpTransceiverDirection(int n2) {
            this.nativeIndex = n2;
        }

        @CalledByNative(value="RtpTransceiverDirection")
        int getNativeIndex() {
            return this.nativeIndex;
        }

        @CalledByNative(value="RtpTransceiverDirection")
        static RtpTransceiverDirection fromNativeIndex(int n) {
            for (RtpTransceiverDirection rtpTransceiverDirection : RtpTransceiverDirection.values()) {
                if (rtpTransceiverDirection.getNativeIndex() != n) continue;
                return rtpTransceiverDirection;
            }
            throw new IllegalArgumentException("Uknown native RtpTransceiverDirection type" + n);
        }
    }
}

