/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.CalledByNative;
import com.superrtc.EncodedImage;
import com.superrtc.VideoCodecStatus;
import com.superrtc.VideoFrame;
import javax.annotation.Nullable;

public interface VideoEncoder {
    @CalledByNative
    default public long createNativeVideoEncoder() {
        return 0L;
    }

    @CalledByNative
    default public boolean isHardwareEncoder() {
        return true;
    }

    @CalledByNative
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus encode(VideoFrame var1, EncodeInfo var2);

    @CalledByNative
    public VideoCodecStatus setChannelParameters(short var1, long var2);

    @CalledByNative
    public VideoCodecStatus setRateAllocation(BitrateAllocation var1, int var2);

    @CalledByNative
    public ScalingSettings getScalingSettings();

    @CalledByNative
    public String getImplementationName();

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, CodecSpecificInfo var2);
    }

    public static class ScalingSettings {
        public final boolean on;
        @Nullable
        public final Integer low;
        @Nullable
        public final Integer high;
        public static final ScalingSettings OFF = new ScalingSettings();

        public ScalingSettings(int n, int n2) {
            this.on = true;
            this.low = n;
            this.high = n2;
        }

        private ScalingSettings() {
            this.on = false;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean bl) {
            this.on = bl;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean bl, int n, int n2) {
            this.on = bl;
            this.low = n;
            this.high = n2;
        }

        public String toString() {
            return this.on ? "[ " + this.low + ", " + this.high + " ]" : "OFF";
        }
    }

    public static class BitrateAllocation {
        public final int[][] bitratesBbs;

        @CalledByNative(value="BitrateAllocation")
        public BitrateAllocation(int[][] nArray) {
            this.bitratesBbs = nArray;
        }

        public int getSum() {
            int n = 0;
            int[][] nArray = this.bitratesBbs;
            int n2 = nArray.length;
            for (int k = 0; k < n2; ++k) {
                int[] nArray2;
                for (int n3 : nArray2 = nArray[k]) {
                    n += n3;
                }
            }
            return n;
        }
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfo {
    }

    public static class EncodeInfo {
        public final EncodedImage.FrameType[] frameTypes;

        @CalledByNative(value="EncodeInfo")
        public EncodeInfo(EncodedImage.FrameType[] frameTypeArray) {
            this.frameTypes = frameTypeArray;
        }
    }

    public static class Settings {
        public final int numberOfCores;
        public final int width;
        public final int height;
        public final int startBitrate;
        public final int maxFramerate;
        public final int numberOfSimulcastStreams;
        public final boolean automaticResizeOn;

        @CalledByNative(value="Settings")
        public Settings(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            this.numberOfCores = n;
            this.width = n2;
            this.height = n3;
            this.startBitrate = n4;
            this.maxFramerate = n5;
            this.numberOfSimulcastStreams = n6;
            this.automaticResizeOn = bl;
        }
    }
}

