/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.adapter.EMABase;
import com.hyphenate.chat.adapter.EMACallManager;
import com.hyphenate.chat.adapter.EMAChatConfig;
import com.hyphenate.chat.adapter.EMAChatManager;
import com.hyphenate.chat.adapter.EMAChatRoomManager;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMAContactManager;
import com.hyphenate.chat.adapter.EMADeviceInfo;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAGroupManager;
import com.hyphenate.chat.adapter.EMAMultiDeviceListener;
import com.hyphenate.chat.adapter.EMAPushManager;
import java.util.List;

public class EMAChatClient
extends EMABase {
    private EMAChatManager chatManager = null;
    private EMAChatRoomManager chatRoomManager = null;
    private EMACallManager callManager = null;
    private EMAGroupManager groupManager = null;
    private EMAContactManager contactManager = null;
    private EMAPushManager pushManager = null;

    public static EMAChatClient create(EMAChatConfig eMAChatConfig) {
        EMAChatClient eMAChatClient = new EMAChatClient();
        eMAChatClient.nativeHandler = EMAChatClient.native_create(eMAChatConfig);
        if (eMAChatClient.getChatManager() == null) {
            eMAChatClient.chatManager = new EMAChatManager();
            eMAChatClient.getChatManager().nativeHandler = eMAChatClient.native_getChatManager();
        }
        if (eMAChatClient.getChatRoomManager() == null) {
            eMAChatClient.chatRoomManager = new EMAChatRoomManager();
            eMAChatClient.getChatRoomManager().nativeHandler = eMAChatClient.native_getChatRoomManager();
        }
        if (eMAChatClient.getCallManager() == null) {
            eMAChatClient.callManager = new EMACallManager();
            eMAChatClient.getCallManager().nativeHandler = eMAChatClient.native_getCallManager();
        }
        if (eMAChatClient.getGroupManager() == null) {
            eMAChatClient.groupManager = new EMAGroupManager();
            eMAChatClient.getGroupManager().nativeHandler = eMAChatClient.native_getGroupManager();
        }
        if (eMAChatClient.getContactManager() == null) {
            eMAChatClient.contactManager = new EMAContactManager();
            eMAChatClient.getContactManager().nativeHandler = eMAChatClient.native_getContactManager();
        }
        if (eMAChatClient.getPushMnager() == null) {
            eMAChatClient.pushManager = new EMAPushManager();
            eMAChatClient.getPushMnager().nativeHandler = eMAChatClient.native_getPushManager();
        }
        return eMAChatClient;
    }

    public void login(String string, String string2, boolean bl, boolean bl2, EMAError eMAError) {
        this.native_login(string, string2, bl, bl2, eMAError);
    }

    public String getUserToken(boolean bl, EMAError eMAError) {
        return this.native_getUserToken(bl, eMAError);
    }

    public String getUserTokenFromServer(String string, String string2, EMAError eMAError) {
        return this.native_getUserTokenFromServer(string, string2, eMAError);
    }

    public void logout() {
        this.native_logout();
    }

    public EMAError createAccount(String string, String string2) {
        return this.native_createAccount(string, string2);
    }

    public EMAError changeAppkey(String string) {
        return this.native_changeAppkey(string);
    }

    public EMAChatManager getChatManager() {
        return this.chatManager;
    }

    public EMAChatRoomManager getChatRoomManager() {
        return this.chatRoomManager;
    }

    public EMACallManager getCallManager() {
        return this.callManager;
    }

    public EMAGroupManager getGroupManager() {
        return this.groupManager;
    }

    public EMAPushManager getPushMnager() {
        return this.pushManager;
    }

    public EMAContactManager getContactManager() {
        return this.contactManager;
    }

    public void addConnectionListener(EMAConnectionListener eMAConnectionListener) {
        this.native_addConnectionListener(eMAConnectionListener);
    }

    public void removeConnectionListener(EMAConnectionListener eMAConnectionListener) {
        this.native_removeConnectionListener(eMAConnectionListener);
    }

    public void addMultiDeviceListener(EMAMultiDeviceListener eMAMultiDeviceListener) {
        this.native_addMultiDeviceListener(eMAMultiDeviceListener);
    }

    public boolean sendPing(boolean bl, long l) {
        return this.native_sendPing(bl, l);
    }

    public void disconnect() {
        this.native_disconnect();
    }

    public void reconnect() {
        this.natvie_reconnect();
    }

    public void onNetworkChanged(EMANetwork eMANetwork) {
        this.native_onNetworkChanged(eMANetwork.ordinal());
    }

    public boolean isConnected() {
        return this.native_isConnected();
    }

    public void setPresence(String string) {
        this.native_setPresence(string);
    }

    public String compressLogs(EMAError eMAError) {
        return this.native_compressLogs(eMAError);
    }

    public List<EMADeviceInfo> getLoggedInDevicesFromServer(String string, String string2, EMAError eMAError) {
        return this.nativeGetLoggedInDevicesFromServer(string, string2, eMAError);
    }

    public void kickDevice(String string, String string2, String string3, EMAError eMAError) {
        this.nativeKickDevice(string, string2, string3, eMAError);
    }

    public void kickAllDevices(String string, String string2, EMAError eMAError) {
        this.nativeKickAllDevices(string, string2, eMAError);
    }

    public void check(String string, String string2, CheckResultListener checkResultListener) {
        this.nativeCheck(string, string2, checkResultListener);
    }

    static native long native_create(EMAChatConfig var0);

    native EMAError native_createAccount(String var1, String var2);

    native void native_login(String var1, String var2, boolean var3, boolean var4, EMAError var5);

    native String native_getUserToken(boolean var1, EMAError var2);

    native String native_getUserTokenFromServer(String var1, String var2, EMAError var3);

    native void native_logout();

    native EMAError native_changeAppkey(String var1);

    native long native_getChatManager();

    native long native_getCallManager();

    native long native_getGroupManager();

    native long native_getContactManager();

    native long native_getChatRoomManager();

    native long native_getPushManager();

    native void native_onNetworkChanged(int var1);

    native List<EMADeviceInfo> nativeGetLoggedInDevicesFromServer(String var1, String var2, EMAError var3);

    native void nativeKickDevice(String var1, String var2, String var3, EMAError var4);

    native void nativeKickAllDevices(String var1, String var2, EMAError var3);

    native void native_addConnectionListener(EMAConnectionListener var1);

    native void native_removeConnectionListener(EMAConnectionListener var1);

    native void native_addMultiDeviceListener(EMAMultiDeviceListener var1);

    native void native_removeMultiDeviceListener(EMAMultiDeviceListener var1);

    native boolean native_sendPing(boolean var1, long var2);

    native void native_disconnect();

    native void natvie_reconnect();

    native boolean native_isConnected();

    native void native_setPresence(String var1);

    native String native_compressLogs(EMAError var1);

    native void nativeCheck(String var1, String var2, CheckResultListener var3);

    public static enum EMANetwork {
        NETWORK_NONE,
        NETWORK_CABLE,
        NETWORK_WIFI,
        NETWORK_MOBILE;

    }

    public static class CheckResultListener {
        public void onResult(int n, int n2, String string) {
        }
    }
}

