package com.hyphenate.chat;

/**
 * Created by linan on 17/6/29.
 */


/**
 * \~chinese
 * 创建群组时的属性配置
 *
 * \~english
 * create group related options
 */
public class EMGroupOptions {

    /**
     * \~chinese
     * 群最大成员数。
     *
     * \~english
     * Max group members count.
     */
    public int maxUsers = 200;

    /**
     * \~chinese
     * 群类型，参考 {@link com.hyphenate.chat.EMGroupManager.EMGroupStyle}
     *
     * \~english
     * group style, refer to {@link com.hyphenate.chat.EMGroupManager.EMGroupStyle}
     */
    public EMGroupManager.EMGroupStyle style = EMGroupManager.EMGroupStyle.EMGroupStylePrivateOnlyOwnerInvite;

    /**
     * \~chinese
     * 邀请进群是否需要对方同意。
     * 如果设置为false，直接加被邀请人进群。 在此情况下，被邀请人设置非自动同意进群不起作用。
     * 如果设置为true，被邀请人设置非自动同意其作用，用户可以选择接受邀请进群，也可选择拒绝邀请。
     *
     * \~english
     * This option define whether user will immediately joined the group when receive group invitation.
     * If inviteNeedConfirm is false, and EMOptions.setAutoAcceptGroupInvitation() is invalid, user who received group invitation
     * will auto join the group.
     * If inviteNeedConfirm is true, and EMOptions.isAutoAcceptGroupInvitation() is true,
     * user who received group invitation has option to decide whether join in.
     */
    public boolean inviteNeedConfirm = false;

    /**
     * \~chinese
     * 群详情扩展，可以采用json格式，包含跟多群信息。
     *
     * \~english
     * Group extension field, can be json format, which contains more descriptions
     */
    public String extField;
}