/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMACallManager;
import com.superrtc.sdk.RtcConnection;

import org.json.JSONObject;

/**
 * Contains call related options.
 * Those configure options works like preference which exists in memory, take effect when make call.
 * Call 'SetXXX' method doesn't take effect during call.
 */
public class EMCallOptions {

    EMACallManager emaCallManager = null;

    boolean isUserSetAutoResizing = false;
    boolean isUserSetMaxFrameRate = false;

    boolean userSetAutoResizing = false;
    int userSetMaxFrameRate = -1;

    boolean isChangeVideoResolution = false;
    int changeVideoResolutionWidth = -1;
    int changeVideoResolutionHeight = -1;

    boolean isEnableExternalVideoData = false;

    int rotateAngel = -1;
    int audioSource = 7;
    int maxAudioBitrate = 32;
    long maxVideoKbps = 0;


    EMCallOptions(EMACallManager emaObject) {
        this.emaCallManager = emaObject;
    }

    /**
     *  \~chinese
     *  被叫方不在线时，是否推送来电通知
     *  如果设置为NO，不推送通知，返回EMErrorCallRemoteOffline
     *  默认NO
     *
     *  \~english
     *  When remote is not online, whether to send offline push
     *  default NO
     */
    public void setIsSendPushIfOffline(boolean isSend) {
        emaCallManager.setIsSendPushIfOffline(isSend);
    }

    /**
     * @see setIsSendPushIfOffline
     * @return
     */
    public boolean getIsSendPushIfOffline() {
        return emaCallManager.getIsSendPushIfOffline();
    }

    public long getVideoResolutionWidth() {
        return emaCallManager.getVideoResolutionWidth();
    }

    public long getVideoResolutionHeight() {
        return emaCallManager.getVideoResolutionHeight();
    }

    /**
     *  \~chinese
     *  最大视频码率
     *  范围 50 &#60; videoKbps &#60; 5000, 默认0, 0为自适应
     *  建议设置为0
     *
     *  \~english
     *  Video kbps
     *  range: 50 &#60; videoKbps &#60; 5000. Default value is 0, which is adaptive bitrate streaming.
     *  recommend use default value
     */
    public long getMaxVideoKbps() {
        return maxVideoKbps;
    }

    /**
     * Set camera capture resolution
     * If width and height are both set to 0, SDK will use default resolution configured in console.
     * will auto adjust the encoding bit rate, and use appropriate value for video width and height.
     * @param width
     * @param height
     */
    public void setVideoResolution(int width, int height) {
        RtcConnection rtcConnection = EMClient.getInstance().callManager().mRtcConnection;
        if (rtcConnection != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(RtcConnection.RtcvideowidthLong, width);
                jsonObject.put(RtcConnection.RtcvideoheigthLong, height);
                rtcConnection.setConfigure(jsonObject.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        emaCallManager.setVideoResolution(width, height);
    }

    /**
     * default is 0, which means auto adjust encoding bit rate.
     * This kbps can be viewed as a threshold, help to adjust video bit rate.
     * @param kbps
     */
    public void setMaxVideoKbps(long kbps) {
        RtcConnection rtcConnection = EMClient.getInstance().callManager().mRtcConnection;
        if (rtcConnection != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(RtcConnection.RtcKVMaxVideoKbpsLong, kbps);
                rtcConnection.setConfigure(jsonObject.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.maxVideoKbps = kbps;
        emaCallManager.setVideoKbps(kbps);
    }

    /**
     * \~chinese
     * 开启或关闭自动调节分辨率
     *
     * \~english
     * enable/disable auto adjust resolution
     */
    public void enableFixedVideoResolution(boolean enable) {
        isUserSetAutoResizing = true;
        userSetAutoResizing = enable;
        RtcConnection  rtc = EMClient.getInstance().callManager().mRtcConnection;
        if (rtc != null) {
            rtc.enableFixedVideoResolution(enable);
        }
    }

    /**
     * \~chinese
     * 设置最大的视频帧率
     *
     * \~english
     * config maximum of frame rate
     */
    public void setMaxVideoFrameRate(int frameRate) {
        isUserSetMaxFrameRate = true;
        userSetMaxFrameRate = frameRate;
        RtcConnection  rtc = EMClient.getInstance().callManager().mRtcConnection;
        if (rtc != null) {
            rtc.setMaxVideoFrameRate(frameRate);
        }
    }

    /**
     * \~chinese
     * 设置最小的网络带宽
     *
     * \~english
     * config minimum of bit rate
     */
    public void setMinVideoKbps(int minVideoKbps) {
        RtcConnection.setMinVideoKbps(minVideoKbps);
    }

    /**
     * \~chinese
     * 设置音频采样频率，需要在第一次通话之前设置
     * 参考值8000Hz、11025Hz、22050Hz、16000Hz、44100Hz、48000Hz
     *
     * \~english
     * config audio sample rate
     * optional values: 8000Hz, 11025Hz, 22050Hz, 16000Hz, 44100Hz
     */
    public void setAudioSampleRate(int sampleRate) {
        RtcConnection.setAudioSampleRate(sampleRate);
    }

    /**
     * \~chinese
     * 设置最大音频比特率，取值范围 6 ~ 510
     * @param maxAudioKbps 最大音频码率
     *
     * \~english
     * set audio bitrate, 6 ~ 510
     * @param maxAudioKbps max audio bitrate
     */
    public void setMaxAudioKbps(int maxAudioKbps) {
        if (maxAudioKbps < 6) {
            maxAudioKbps = 6;
        }
        if (maxAudioKbps > 510) {
            maxAudioKbps = 510;
        }
        this.maxAudioBitrate = maxAudioKbps;
        RtcConnection rtcConnection = EMClient.getInstance().callManager().mRtcConnection;
        if (rtcConnection != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(RtcConnection.RtcKVMaxAudioKbpsLong, maxAudioKbps);
                rtcConnection.setConfigure(jsonObject.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        emaCallManager.setMaxAudioKbps(maxAudioKbps);
    }

    /**
     * \~chinese
     * 配置是否通过外面输入视频数据流
     *
     * \~english
     * config video stream come from the external
     */
    public void setEnableExternalVideoData(boolean enable) {
        this.isEnableExternalVideoData = enable;
        RtcConnection  rtc = EMClient.getInstance().callManager().mRtcConnection;
        if (rtc != null) {
            rtc.setEnableExternalVideoData(enable);
        }
    }

    /**
     * \~chinese
     * 设置视频旋转角度，启动前和视频通话中均可设置
     * @param angel angel can be 0, 90, 180, 270
     *
     * \~english
     * set video rotational angel
     * @param angel angel can be 0, 90, 180, 270
     */
    public void setRotation(int angel) {
        rotateAngel = angel;
        RtcConnection  rtc = EMClient.getInstance().callManager().mRtcConnection;
        if (rtc != null && angel >= 0) {
            rtc.setRotation(rotateAngel);
        }
    }

    /**
     * \~chinese
     * 设置音视频通话时音频源
     * 参数表示采集语音时所设置的音频源类型，具体值参考{@link android.media.MediaRecorder.AudioSource}
     * 默认值 VOICE_COMMUNICATION
     *
     * @param source 音频源类型
     *
     * \~english
     * set call audio source
     * The parameter indicates the type of audio source set when collecting voice,
     * the specific value is referenced {@link android.media.MediaRecorder.AudioSource}
     * The default value VOICE_COMMUNICATION
     *
     * @param source audio source
     */
    public void setCallAudioSource(int source){
        audioSource = source;
        RtcConnection  rtc = EMClient.getInstance().callManager().mRtcConnection;
        if (rtc != null) {
            rtc.setCallAudioSource(source);
        }
    }

    /**
     * \~chinese
     * 设置ping 间隔，默认为30s，最小为10s
     * @param interval ping 间隔市场
     *
     * \~english
     * set ping interval, default 30s, min 10s
     * @param interval ping interval
     */
    public void setPingInterval(int interval){
        emaCallManager.setPingInterval(interval);
    }

    /**
     * \~chinese
     * 设置本地视频view镜像，可在通话过程中动态设置
     * @param mirror
     *
     * \~english
     * Set local video view mirror, can be set during a video call.
     * @param mirror
     */
    public void setLocalVideoViewMirror(@EMMirror.MIRROR int mirror) {
        RtcConnection.MIRROR rtcMirror = EMMirror.convert(mirror);
        RtcConnection.setLocalVideoViewMirror(rtcMirror);
        RtcConnection  rtc = EMClient.getInstance().callManager().mRtcConnection;
        if (rtc != null) {
            rtc.updateLocalVideoViewMirror();
        }
    }

    public void setUse2channelsInput(boolean use) {
        RtcConnection.setUse2channels(use);
    }
}
