/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sdk;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.superrtc.RendererCommon;
import com.superrtc.sdk.VideoViewRenderer;

public class VideoView
extends VideoViewRenderer {
    private boolean isGesture = false;
    private boolean isSingle = true;
    private boolean isDouble = false;
    private float focusX = 0.0f;
    private float focusY = 0.0f;
    private int width;
    private int height;
    private float oldZoom;
    private CallViewListener callViewListener;
    private EMCallViewScaleMode aspectMode = EMCallViewScaleMode.EMCallViewScaleModeAspectFit;

    public VideoView(Context context) {
        this(context, null);
    }

    public VideoView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public VideoView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.setScalingTypeInternal();
    }

    public void setCallViewListener(CallViewListener callViewListener) {
        this.callViewListener = callViewListener;
    }

    public synchronized EMCallViewScaleMode getScaleMode() {
        return this.aspectMode;
    }

    public synchronized void setScaleMode(EMCallViewScaleMode eMCallViewScaleMode) {
        if (this.aspectMode != eMCallViewScaleMode) {
            this.aspectMode = eMCallViewScaleMode;
            this.setScalingTypeInternal();
        }
    }

    public void setGestureEnable(boolean bl) {
        this.isGesture = bl;
    }

    @Deprecated
    public VideoViewRenderer getRenderer() {
        return this;
    }

    @Override
    @Deprecated
    public void dispose() {
        super.dispose();
        this.release();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isGesture) {
            return super.onTouchEvent(motionEvent);
        }
        switch (motionEvent.getAction() & 0xFF) {
            case 0: {
                this.isSingle = true;
                break;
            }
            case 5: {
                this.isSingle = false;
                this.isDouble = true;
                this.oldZoom = this.getZoom(motionEvent);
                break;
            }
            case 2: {
                if (this.isSingle || !this.isDouble) break;
                float f2 = this.getZoom(motionEvent);
                int n = (int)Math.abs((f2 - this.oldZoom) / 3.0f);
                if (f2 > this.oldZoom) {
                    this.handleZoom(true, n);
                } else {
                    this.handleZoom(false, n);
                }
                this.oldZoom = f2;
                break;
            }
            case 6: {
                this.isDouble = false;
                break;
            }
            case 1: {
                if (!this.isSingle) break;
                this.focusX = motionEvent.getX();
                this.focusY = motionEvent.getY();
                this.handleFocus();
            }
        }
        return true;
    }

    private void handleFocus() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.callViewListener != null) {
            this.callViewListener.onFocus(this.focusX, this.focusY, this.width, this.height);
        }
    }

    private float getZoom(MotionEvent motionEvent) {
        float f2 = motionEvent.getX(0) - motionEvent.getX(1);
        float f3 = motionEvent.getY(0) - motionEvent.getY(1);
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    private void handleZoom(boolean bl, int n) {
        if (this.callViewListener != null) {
            this.callViewListener.onZoom(bl, n);
        }
    }

    private void setScalingTypeInternal() {
        if (this.aspectMode == EMCallViewScaleMode.EMCallViewScaleModeAspectFill) {
            this.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FILL);
        } else {
            this.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
        }
    }

    public static enum EMCallViewScaleMode {
        EMCallViewScaleModeAspectFit,
        EMCallViewScaleModeAspectFill;

    }

    public static interface CallViewListener {
        public void onFocus(float var1, float var2, int var3, int var4);

        public void onZoom(boolean var1, int var2);
    }
}

