/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.VP8Encoder;
import com.superrtc.VP9Encoder;
import com.superrtc.VideoCodecInfo;
import com.superrtc.VideoEncoder;
import com.superrtc.VideoEncoderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo) {
        if (videoCodecInfo.name.equalsIgnoreCase("VP8")) {
            return new VP8Encoder();
        }
        if (videoCodecInfo.name.equalsIgnoreCase("VP9") && VP9Encoder.nativeIsSupported()) {
            return new VP9Encoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoEncoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (VP9Encoder.nativeIsSupported()) {
            arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
    }
}

