/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.AudioTrack;
import com.superrtc.CalledByNative;
import com.superrtc.JniCommon;
import com.superrtc.Logging;
import com.superrtc.MediaStreamTrack;
import com.superrtc.VideoTrack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MediaStream {
    private static final String TAG = "MediaStream";
    public final List<AudioTrack> audioTracks = new ArrayList<AudioTrack>();
    public final List<VideoTrack> videoTracks = new ArrayList<VideoTrack>();
    public final List<VideoTrack> preservedVideoTracks = new ArrayList<VideoTrack>();
    private long nativeStream;

    @CalledByNative
    public MediaStream(long l) {
        this.nativeStream = l;
    }

    public boolean addTrack(AudioTrack audioTrack) {
        this.checkMediaStreamExists();
        if (MediaStream.nativeAddAudioTrackToNativeStream(this.nativeStream, audioTrack.getNativeAudioTrack())) {
            this.audioTracks.add(audioTrack);
            return true;
        }
        return false;
    }

    public boolean addTrack(VideoTrack videoTrack) {
        this.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(this.nativeStream, videoTrack.getNativeVideoTrack())) {
            this.videoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean addPreservedTrack(VideoTrack videoTrack) {
        this.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(this.nativeStream, videoTrack.getNativeVideoTrack())) {
            this.preservedVideoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean removeTrack(AudioTrack audioTrack) {
        this.checkMediaStreamExists();
        this.audioTracks.remove(audioTrack);
        return MediaStream.nativeRemoveAudioTrack(this.nativeStream, audioTrack.getNativeAudioTrack());
    }

    public boolean removeTrack(VideoTrack videoTrack) {
        this.checkMediaStreamExists();
        this.videoTracks.remove(videoTrack);
        this.preservedVideoTracks.remove(videoTrack);
        return MediaStream.nativeRemoveVideoTrack(this.nativeStream, videoTrack.getNativeVideoTrack());
    }

    @CalledByNative
    public void dispose() {
        MediaStreamTrack mediaStreamTrack;
        this.checkMediaStreamExists();
        while (!this.audioTracks.isEmpty()) {
            mediaStreamTrack = this.audioTracks.get(0);
            this.removeTrack((AudioTrack)mediaStreamTrack);
            mediaStreamTrack.dispose();
        }
        while (!this.videoTracks.isEmpty()) {
            mediaStreamTrack = this.videoTracks.get(0);
            this.removeTrack((VideoTrack)mediaStreamTrack);
            ((VideoTrack)mediaStreamTrack).dispose();
        }
        while (!this.preservedVideoTracks.isEmpty()) {
            this.removeTrack(this.preservedVideoTracks.get(0));
        }
        JniCommon.nativeReleaseRef(this.nativeStream);
        this.nativeStream = 0L;
    }

    public String getId() {
        this.checkMediaStreamExists();
        return MediaStream.nativeGetId(this.nativeStream);
    }

    public String toString() {
        return "[" + this.getId() + ":A=" + this.audioTracks.size() + ":V=" + this.videoTracks.size() + "]";
    }

    @CalledByNative
    void addNativeAudioTrack(long l) {
        this.audioTracks.add(new AudioTrack(l));
    }

    @CalledByNative
    void addNativeVideoTrack(long l) {
        this.videoTracks.add(new VideoTrack(l));
    }

    @CalledByNative
    void removeAudioTrack(long l) {
        MediaStream.removeMediaStreamTrack(this.audioTracks, l);
    }

    @CalledByNative
    void removeVideoTrack(long l) {
        MediaStream.removeMediaStreamTrack(this.videoTracks, l);
    }

    long getNativeMediaStream() {
        this.checkMediaStreamExists();
        return this.nativeStream;
    }

    private void checkMediaStreamExists() {
        if (this.nativeStream == 0L) {
            throw new IllegalStateException("MediaStream has been disposed.");
        }
    }

    private static void removeMediaStreamTrack(List<? extends MediaStreamTrack> list, long l) {
        Iterator<? extends MediaStreamTrack> iterator = list.iterator();
        while (iterator.hasNext()) {
            MediaStreamTrack mediaStreamTrack = iterator.next();
            if (mediaStreamTrack.getNativeMediaStreamTrack() != l) continue;
            mediaStreamTrack.dispose();
            iterator.remove();
            return;
        }
        Logging.e(TAG, "Couldn't not find track");
    }

    private static native boolean nativeAddAudioTrackToNativeStream(long var0, long var2);

    private static native boolean nativeAddVideoTrackToNativeStream(long var0, long var2);

    private static native boolean nativeRemoveAudioTrack(long var0, long var2);

    private static native boolean nativeRemoveVideoTrack(long var0, long var2);

    private static native String nativeGetId(long var0);
}

