/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody.EMADownloadStatus;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;

/**
 * \~chinese
 * 文件类消息的基类
 * 
 * \~english
 * the base class of file type message
 */
public abstract class EMFileMessageBody extends EMMessageBody {
    
    public enum EMDownloadStatus {
        DOWNLOADING,
        SUCCESSED,
        FAILED,
        PENDING
    }
    
	public EMFileMessageBody(String localPath) {
		emaObject = new EMAFileMessageBody(localPath);
	}
	
	EMFileMessageBody(String localPath, int type) {
		switch (type) {
		case EMAMessageBody.EMAMessageBodyType_FILE:			
			emaObject = new EMAFileMessageBody(localPath, type);
			break;
		case EMAMessageBody.EMAMessageBodyType_IMAGE:
			emaObject = new EMAImageMessageBody(localPath, "");
			break;
		case EMAMessageBody.EMAMessageBodyType_VIDEO:
			emaObject = new EMAVideoMessageBody(localPath, "");
			break;
		case EMAMessageBody.EMAMessageBodyType_VOICE:
		    emaObject = new EMAVoiceMessageBody(localPath, 0);
		    break;
		default:
			break;
		}
	}
	
	public EMFileMessageBody(EMAFileMessageBody body) {
		emaObject = body;
	}
	

	/**
	 * \~chinese
	 * 获得文件名
	 * 
	 * @return
	 * 
	 * \~english
	 * get file name
	 * @return
	 */
	public String getFileName() {
		return ((EMAFileMessageBody)emaObject).displayName();
	}

	public void setFileName(String fileName) {
		((EMAFileMessageBody)emaObject).setDisplayName(fileName);
	}

	/**
	 * \~chinese
	 * 本地图片，语音等文件的路径
	 * 
	 * @return
	 * 
	 * \~english
	 * local file path
	 */
	public String getLocalUrl() {
		return ((EMAFileMessageBody)emaObject).getLocalUrl();
	}

	public void setLocalUrl(String localUrl) {
		((EMAFileMessageBody)emaObject).setLocalPath(localUrl);
	}

	/**
	 * \~chinese
	 * 远程图片，声音等的url
	 * 
	 * @return
	 * 
	 * \~english
	 * get file remote url
	 * @return
	 */
	public String getRemoteUrl() {
		return ((EMAFileMessageBody)emaObject).getRemoteUrl();
	}

	public void setRemoteUrl(String remoteUrl) {
		((EMAFileMessageBody)emaObject).setRemotePath(remoteUrl);
	}

	public void setSecret(String secret) {
		((EMAFileMessageBody)emaObject).setSecretKey(secret);
	}

	public String getSecret() {
		return ((EMAFileMessageBody)emaObject).getSecret();
	}
	
	public String displayName() {
		return ((EMAFileMessageBody)emaObject).displayName();
	}
	
	public void setFileLength(long length) {
		((EMAFileMessageBody)emaObject).setFileLength(length);
	}
	
	public EMDownloadStatus downloadStatus() {
	    EMADownloadStatus _status = ((EMAFileMessageBody)emaObject).downloadStatus();
	    switch (_status) {
	    case DOWNLOADING:
	        return EMDownloadStatus.DOWNLOADING;
	    case SUCCESSED:
	        return EMDownloadStatus.SUCCESSED;
	    case FAILED:
	        return EMDownloadStatus.FAILED;
	    case PENDING:
	        return EMDownloadStatus.PENDING;
	    }
	    return EMDownloadStatus.SUCCESSED;
	}
	
	public void setDownloadStatus(EMDownloadStatus status) {
		((EMAFileMessageBody)emaObject).setDownloadStatus(EMADownloadStatus.valueOf(status.name()));
	}

}
