/*
 * Decompiled with CFR 0.152.
 */
package internal.org.apache.http.entity.mime.content;

import internal.org.apache.http.entity.mime.content.ContentBody;

public abstract class AbstractContentBody
implements ContentBody {
    private final String mimeType;
    private final String mediaType;
    private final String subType;

    public AbstractContentBody(String string) {
        if (string == null) {
            throw new IllegalArgumentException("MIME type may not be null");
        }
        this.mimeType = string;
        int n = string.indexOf(47);
        if (n != -1) {
            this.mediaType = string.substring(0, n);
            this.subType = string.substring(n + 1);
        } else {
            this.mediaType = string;
            this.subType = null;
        }
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }
}

