/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.wav;

import android.util.Log;
import com.superrtc.wav.WavFileHeader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WavFileReader {
    private static final String TAG = WavFileReader.class.getSimpleName();
    private DataInputStream mDataInputStream;
    private WavFileHeader mWavFileHeader;

    public boolean openInputStream(InputStream inputStream) throws IOException {
        if (this.mDataInputStream != null) {
            this.closeFile();
        }
        this.mDataInputStream = new DataInputStream(inputStream);
        return this.readHeader();
    }

    public boolean openFile(String string) throws IOException {
        return this.openInputStream(new FileInputStream(string));
    }

    public void closeFile() throws IOException {
        if (this.mDataInputStream != null) {
            this.mDataInputStream.close();
            this.mDataInputStream = null;
        }
    }

    public WavFileHeader getWavFileHeader() {
        return this.mWavFileHeader;
    }

    public void rewind() throws IOException {
        if (this.mDataInputStream != null) {
            this.mDataInputStream.reset();
        }
    }

    public int readData(byte[] byArray, int n, int n2) {
        if (this.mDataInputStream == null || this.mWavFileHeader == null) {
            return -1;
        }
        try {
            int n3 = this.mDataInputStream.read(byArray, n, n2);
            if (n3 == -1) {
                return 0;
            }
            return n3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    private boolean readHeader() {
        if (this.mDataInputStream == null) {
            return false;
        }
        WavFileHeader wavFileHeader = new WavFileHeader();
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[2];
        try {
            wavFileHeader.mChunkID = "" + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte();
            Log.d((String)TAG, (String)("Read file chunkID:" + wavFileHeader.mChunkID));
            this.mDataInputStream.read(byArray);
            wavFileHeader.mChunkSize = WavFileReader.byteArrayToInt(byArray);
            Log.d((String)TAG, (String)("Read file chunkSize:" + wavFileHeader.mChunkSize));
            wavFileHeader.mFormat = "" + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte();
            Log.d((String)TAG, (String)("Read file format:" + wavFileHeader.mFormat));
            wavFileHeader.mSubChunk1ID = "" + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte();
            Log.d((String)TAG, (String)("Read fmt chunkID:" + wavFileHeader.mSubChunk1ID));
            this.mDataInputStream.read(byArray);
            wavFileHeader.mSubChunk1Size = WavFileReader.byteArrayToInt(byArray);
            Log.d((String)TAG, (String)("Read fmt chunkSize:" + wavFileHeader.mSubChunk1Size));
            this.mDataInputStream.read(byArray2);
            wavFileHeader.mAudioFormat = WavFileReader.byteArrayToShort(byArray2);
            Log.d((String)TAG, (String)("Read audioFormat:" + wavFileHeader.mAudioFormat));
            this.mDataInputStream.read(byArray2);
            wavFileHeader.mNumChannel = WavFileReader.byteArrayToShort(byArray2);
            Log.d((String)TAG, (String)("Read channel number:" + wavFileHeader.mNumChannel));
            this.mDataInputStream.read(byArray);
            wavFileHeader.mSampleRate = WavFileReader.byteArrayToInt(byArray);
            Log.d((String)TAG, (String)("Read samplerate:" + wavFileHeader.mSampleRate));
            this.mDataInputStream.read(byArray);
            wavFileHeader.mByteRate = WavFileReader.byteArrayToInt(byArray);
            Log.d((String)TAG, (String)("Read byterate:" + wavFileHeader.mByteRate));
            this.mDataInputStream.read(byArray2);
            wavFileHeader.mBlockAlign = WavFileReader.byteArrayToShort(byArray2);
            Log.d((String)TAG, (String)("Read blockalign:" + wavFileHeader.mBlockAlign));
            this.mDataInputStream.read(byArray2);
            wavFileHeader.mBitsPerSample = WavFileReader.byteArrayToShort(byArray2);
            Log.d((String)TAG, (String)("Read bitspersample:" + wavFileHeader.mBitsPerSample));
            wavFileHeader.mSubChunk2ID = "" + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte() + (char)this.mDataInputStream.readByte();
            Log.d((String)TAG, (String)("Read data chunkID:" + wavFileHeader.mSubChunk2ID));
            this.mDataInputStream.read(byArray);
            wavFileHeader.mSubChunk2Size = WavFileReader.byteArrayToInt(byArray);
            Log.d((String)TAG, (String)("Read data chunkSize:" + wavFileHeader.mSubChunk2Size));
            Log.d((String)TAG, (String)"Read wav file success !");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.mWavFileHeader = wavFileHeader;
        return true;
    }

    private static short byteArrayToShort(byte[] byArray) {
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    private static int byteArrayToInt(byte[] byArray) {
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }
}

