/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.externalaudio;

import android.content.Context;
import android.util.Log;
import com.superrtc.externalaudio.IAudioSource;
import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.wav.WavFileHeader;
import com.superrtc.wav.WavFileReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WavSource
implements IAudioSource {
    private static final String TAG = "WavSource";
    private static IAudioSource.LogListener sLogListener = (n, string) -> Log.i((String)TAG, (String)string);
    private String targetFilename;
    private int targetLoopTimes;
    private int channelCount;
    private int sampleRate;
    private int _10msLength;
    private byte[] _10msBytes;
    private ByteBuffer _10msBuffer;
    private HttpURLConnection httpURLConnection;
    private WavFileReader wavFileReader;
    private Context mContext = EMediaManager.getContext();

    public static void registerLogListener(IAudioSource.LogListener logListener) {
        if (logListener != null) {
            sLogListener = logListener;
        }
    }

    @Override
    public boolean canDecode(String string) {
        return string.endsWith(".wav");
    }

    @Override
    public void create(String string, int n) {
        InputStream inputStream;
        sLogListener.onLog(6, "[WavSource] Try to create wav source: " + string + ", loop times: " + n);
        this.targetFilename = string;
        this.targetLoopTimes = n;
        boolean bl = string.startsWith("/assets/");
        boolean bl2 = string.toLowerCase().startsWith("http");
        if (bl) {
            if (this.mContext == null) {
                sLogListener.onLog(6, "[WavSource] mContext is null, return.");
                return;
            }
            string = string.substring("/assets/".length());
            try {
                inputStream = this.mContext.getAssets().open(string);
            }
            catch (IOException iOException) {
                sLogListener.onLog(6, "[WavSource] Error when creating wav file reader from assets: " + iOException.getMessage());
                iOException.printStackTrace();
                return;
            }
        }
        if (bl2) {
            try {
                HttpURLConnection.setFollowRedirects(false);
                this.httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
                this.httpURLConnection.setConnectTimeout(3000);
                this.httpURLConnection.setReadTimeout(3000);
                this.httpURLConnection.setDoInput(true);
                this.httpURLConnection.connect();
                if (this.httpURLConnection.getResponseCode() != 200) {
                    sLogListener.onLog(6, "[WavSource] Connect to URL : " + string + " return response " + this.httpURLConnection.getResponseCode());
                    return;
                }
                inputStream = this.httpURLConnection.getInputStream();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                sLogListener.onLog(6, "[WavSource] Connect timeout on URL : " + string);
                return;
            }
            catch (IOException iOException) {
                sLogListener.onLog(6, "[WavSource] Connect IOException on URL : " + string);
                return;
            }
        }
        try {
            inputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            sLogListener.onLog(6, "[WavSource] Error when creating wav file reader from sdcard: " + iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
        this.wavFileReader = new WavFileReader();
        try {
            this.wavFileReader.openInputStream(inputStream);
        }
        catch (IOException iOException) {
            sLogListener.onLog(6, "[WavSource] Error when wav reader open input stream: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        WavFileHeader wavFileHeader = this.wavFileReader.getWavFileHeader();
        this.channelCount = wavFileHeader.mNumChannel;
        this.sampleRate = wavFileHeader.mSampleRate;
        int n2 = wavFileHeader.mBitsPerSample / 8;
        this._10msLength = this.sampleRate / 100 * n2 * this.channelCount;
        this._10msBytes = new byte[this._10msLength];
        this._10msBuffer = ByteBuffer.allocateDirect(this._10msLength);
        this._10msBuffer.order(ByteOrder.nativeOrder());
        sLogListener.onLog(6, "[WavSource] WavSource header: " + wavFileHeader.toString() + ", 10ms buffer size: " + this._10msLength);
    }

    @Override
    public void release() {
        this.channelCount = 0;
        this.sampleRate = 0;
        if (this.httpURLConnection != null) {
            this.httpURLConnection.disconnect();
            this.httpURLConnection = null;
        }
        this.targetFilename = null;
        this.targetLoopTimes = 0;
        this._10msBytes = null;
        if (this._10msBuffer != null) {
            this._10msBuffer.clear();
            this._10msBuffer = null;
        }
        if (this.wavFileReader != null) {
            try {
                this.wavFileReader.closeFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.wavFileReader = null;
        }
        sLogListener.onLog(6, "[WavSource] WavSource released.");
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public ByteBuffer getData() {
        if (this.wavFileReader != null) {
            int n = this.wavFileReader.readData(this._10msBytes, 0, this._10msBytes.length);
            if (n == 0) {
                if (this.targetLoopTimes-- != 0) {
                    sLogListener.onLog(6, "[WavSource] decodeFrame, need to rewind WavSource");
                    this.rewind();
                } else {
                    sLogListener.onLog(6, "[WavSource] decodeFrame, need to release WavSource");
                    this.release();
                }
            }
            if (this._10msBuffer != null) {
                this._10msBuffer.clear();
                this._10msBuffer.put(this._10msBytes);
            }
        }
        return this._10msBuffer;
    }

    private void rewind() {
        try {
            this.wavFileReader.rewind();
            sLogListener.onLog(6, "[WavSource] Source restarted by rewind.");
        }
        catch (Exception exception) {
            String string = this.targetFilename;
            int n = this.targetLoopTimes;
            this.release();
            this.create(string, n);
            sLogListener.onLog(6, "[WavSource] Source restarted by recreate.");
        }
    }
}

