/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.externalaudio;

import android.util.Log;
import com.superrtc.externalaudio.DecoderSource;
import com.superrtc.externalaudio.IAudioSource;
import com.superrtc.externalaudio.WavSource;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class ExternalAudioSourceWrapper {
    private static final String TAG = "ExternalAudioSource";
    private static final int DEFAULT_VOLUME = 50;
    private static String sFilePath;
    private static int sLoop;
    private static volatile boolean sNeedStart;
    private static volatile boolean sNeedStop;
    private static int sVolumePercentage;
    private IAudioSource[] sourceDecoders = new IAudioSource[2];
    private IAudioSource currentDecoder;

    public ExternalAudioSourceWrapper() {
        Log.i((String)TAG, (String)"ExternalAudioSourceWrapper: ");
        this.sourceDecoders[0] = new WavSource();
        this.sourceDecoders[1] = new DecoderSource();
        this.currentDecoder = this.sourceDecoders[0];
    }

    public static void registerLogListener(IAudioSource.LogListener logListener) {
        WavSource.registerLogListener(logListener);
        DecoderSource.registerLogListener(logListener);
    }

    public static int startAudioMixing(@Nonnull String string, int n) {
        sFilePath = string;
        sLoop = n;
        sNeedStop = false;
        sNeedStart = true;
        return 0;
    }

    public static int stopAudioMixing() {
        if (sNeedStart) {
            sNeedStart = false;
        } else {
            sNeedStop = true;
        }
        return 0;
    }

    public static int adjustAudioMixingVolume(int n) {
        sVolumePercentage = n;
        return 0;
    }

    public static void reset() {
        Log.i((String)TAG, (String)"reset: ");
        sFilePath = null;
        sLoop = 0;
        sNeedStart = false;
        sNeedStop = true;
        sVolumePercentage = 50;
    }

    public int getChannelCount() {
        return this.currentDecoder.getChannelCount();
    }

    public int getSampleRate() {
        return this.currentDecoder.getSampleRate();
    }

    public int getVolumePercentage() {
        return sVolumePercentage;
    }

    public ByteBuffer getData() {
        this.initCurrentDecoder();
        return this.currentDecoder.getData();
    }

    private void initCurrentDecoder() {
        if (sNeedStart) {
            Log.i((String)TAG, (String)"initCurrentDecoder: need start.");
            sNeedStart = false;
            this.currentDecoder.release();
            for (IAudioSource iAudioSource : this.sourceDecoders) {
                if (!iAudioSource.canDecode(sFilePath)) continue;
                this.currentDecoder = iAudioSource;
                break;
            }
            this.currentDecoder.create(sFilePath, sLoop);
        }
        if (sNeedStop) {
            Log.i((String)TAG, (String)"initCurrentDecoder: need stop.");
            sNeedStop = false;
            this.currentDecoder.release();
        }
    }

    static {
        sVolumePercentage = 50;
    }
}

