/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.externalaudio;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import com.superrtc.externalaudio.IAudioSource;
import com.superrtc.mediamanager.EMediaManager;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class DecoderSource
implements IAudioSource {
    private static final String TAG = "DecoderSource";
    private static final int CACHED_BUFFER_SIZE = 4;
    private static final int MAX_DECODER_RETRY_COUNT = 100;
    private static IAudioSource.LogListener sLogListener = (n, string) -> Log.i((String)TAG, (String)string);
    private Context mContext = null;
    private MediaCodec mMediaCodec = null;
    private MediaExtractor mExtractor = null;
    private MediaFormat mTrackFormat = null;
    private boolean eoInputStream = false;
    private boolean eoOutputStream = false;
    private int mSampleRate = 0;
    private int mChannels = 0;
    private long mFileLength;
    private int mRetryCount = 0;
    private String targetFilename;
    private int targetLoopTimes;
    private int _10msLength = 0;
    private byte[] _10msBytes;
    private ByteBuffer _10msBuffer;
    private ByteBuffer bufferInUse;
    private Thread decodeThread;
    private HttpURLConnection httpURLConnection;
    private LinkedBlockingDeque<Integer> queueForDecode = new LinkedBlockingDeque(4);
    private final ArrayDeque<ByteBuffer> queueForUse = new ArrayDeque(4);
    private boolean needRewind = false;
    private boolean needRelease = false;

    public DecoderSource() {
        this.mContext = EMediaManager.getContext();
    }

    public static void registerLogListener(IAudioSource.LogListener logListener) {
        if (logListener != null) {
            sLogListener = logListener;
        }
    }

    @Override
    public boolean canDecode(String string) {
        return true;
    }

    @Override
    public void create(String string, int n) {
        sLogListener.onLog(6, "[DecoderSource] Try to create decoder source: " + string + ", loop times: " + n);
        this.targetFilename = string;
        this.targetLoopTimes = n;
        try {
            int n2;
            this.mRetryCount = 0;
            boolean bl = string.startsWith("/assets/");
            boolean bl2 = string.toLowerCase().startsWith("http");
            this.mExtractor = new MediaExtractor();
            if (bl) {
                if (this.mContext == null) {
                    sLogListener.onLog(6, "[DecoderSource] mContext is null, return.");
                    return;
                }
                string = string.substring("/assets/".length());
                AssetFileDescriptor assetFileDescriptor = this.mContext.getAssets().openFd(string);
                this.mExtractor.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
            } else if (bl2) {
                try {
                    HttpURLConnection.setFollowRedirects(false);
                    this.httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
                    this.httpURLConnection.setConnectTimeout(3000);
                    this.httpURLConnection.setReadTimeout(3000);
                    this.httpURLConnection.connect();
                    if (this.httpURLConnection.getResponseCode() != 200) {
                        sLogListener.onLog(6, "[DecoderSource] Connect to URL : " + string + " return response " + this.httpURLConnection.getResponseCode());
                        return;
                    }
                    this.mExtractor.setDataSource(string);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    sLogListener.onLog(6, "[DecoderSource] Connect timeout on URL : " + string);
                    return;
                }
                catch (IOException iOException) {
                    sLogListener.onLog(6, "[DecoderSource] Connect IOException on URL : " + string);
                    return;
                }
            } else {
                this.mExtractor.setDataSource(string);
            }
            int n3 = this.mExtractor.getTrackCount();
            for (n2 = 0; n2 < n3; ++n2) {
                this.mExtractor.unselectTrack(n2);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.mTrackFormat = this.mExtractor.getTrackFormat(n2);
                String string2 = this.mTrackFormat.getString("mime");
                if (!string2.contains("audio/")) continue;
                this.mExtractor.selectTrack(n2);
                this.mMediaCodec = MediaCodec.createDecoderByType((String)string2);
                this.mMediaCodec.configure(this.mTrackFormat, null, null, 0);
                break;
            }
            if (this.mMediaCodec != null) {
                this.mMediaCodec.start();
            }
            this.mChannels = this.mTrackFormat.getInteger("channel-count");
            this.mSampleRate = this.mTrackFormat.getInteger("sample-rate");
            this.mFileLength = this.mTrackFormat.getLong("durationUs");
            this._10msLength = this.mSampleRate / 100 * 2 * this.mChannels;
            this._10msBytes = new byte[this._10msLength];
            this._10msBuffer = ByteBuffer.allocateDirect(this._10msLength);
            this._10msBuffer.order(ByteOrder.nativeOrder());
            for (n2 = 0; n2 < 4; ++n2) {
                this.queueForDecode.offerLast(0);
            }
            sLogListener.onLog(6, "[DecoderSource] Decoder header: " + this.mTrackFormat.toString() + ", 10ms buffer size: " + this._10msLength);
        }
        catch (Exception exception) {
            sLogListener.onLog(6, "[DecoderSource] Error when creating audio file decoder, " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
        this.startDecodeFrameInThread();
    }

    @Override
    public void release() {
        if (this.decodeThread != null) {
            this.decodeThread.interrupt();
            this.decodeThread = null;
        }
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
        if (this.mExtractor != null) {
            this.mExtractor.release();
            this.mExtractor = null;
        }
        if (this.httpURLConnection != null) {
            this.httpURLConnection.disconnect();
            this.httpURLConnection = null;
        }
        this.targetFilename = null;
        this.targetLoopTimes = 0;
        this._10msBytes = null;
        if (this._10msBuffer != null) {
            this._10msBuffer.clear();
            this._10msBuffer = null;
        }
        this.queueForDecode.clear();
        this.queueForUse.clear();
        this.bufferInUse = null;
        this.mChannels = 0;
        this.mSampleRate = 0;
        this.eoOutputStream = false;
        this.eoInputStream = false;
        sLogListener.onLog(6, "[DecoderSource] DecoderSource released.");
    }

    @Override
    public int getChannelCount() {
        return this.mChannels;
    }

    @Override
    public int getSampleRate() {
        return this.mSampleRate;
    }

    @Override
    public ByteBuffer getData() {
        if (this.bufferInUse != null && this.bufferInUse.remaining() > 0) {
            int n = Math.min(this._10msLength, this.bufferInUse.remaining());
            this.bufferInUse.get(this._10msBytes, 0, n);
            if (this.bufferInUse.remaining() == 0) {
                this.bufferInUse = this.pollFirstFromQueueForUse();
                if (this.bufferInUse != null && n < this._10msLength) {
                    int n2 = Math.min(this._10msLength - n, this.bufferInUse.remaining());
                    this.bufferInUse.get(this._10msBytes, n, n2);
                }
            }
            this._10msBuffer.clear();
            this._10msBuffer.put(this._10msBytes);
            return this._10msBuffer;
        }
        this.bufferInUse = this.pollFirstFromQueueForUse();
        return null;
    }

    public long getFileLength() {
        return this.mFileLength;
    }

    public long getCurrentFilePosition() {
        return this.mExtractor.getSampleTime();
    }

    public void setCurrentFilePosition(long l) {
        this.mExtractor.seekTo(l, 2);
    }

    private void rewind() {
        try {
            this.mExtractor.seekTo(0L, 1);
            this.mMediaCodec.flush();
            this.eoInputStream = false;
            this.eoOutputStream = false;
            sLogListener.onLog(6, "[DecoderSource] Source restarted by rewind.");
        }
        catch (Exception exception) {
            String string = this.targetFilename;
            int n = this.targetLoopTimes;
            this.release();
            this.create(string, n);
            sLogListener.onLog(6, "[DecoderSource] Source restarted by recreate.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer pollFirstFromQueueForUse() {
        ByteBuffer byteBuffer;
        ArrayDeque<ByteBuffer> arrayDeque = this.queueForUse;
        synchronized (arrayDeque) {
            byteBuffer = this.queueForUse.pollFirst();
        }
        if (byteBuffer != null) {
            this.queueForDecode.offerLast(0);
        }
        return byteBuffer;
    }

    private void startDecodeFrameInThread() {
        sLogListener.onLog(6, "[DecoderSource] Start audio frame decode thread.");
        if (this.decodeThread != null) {
            sLogListener.onLog(6, "[DecoderSource] Audio frame decode thread already started, return.");
            return;
        }
        this.decodeThread = new Thread(() -> {
            while (true) {
                try {
                    this.queueForDecode.takeFirst();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                try {
                    this.decodeFrame();
                }
                catch (Exception exception) {
                    sLogListener.onLog(6, "[DecoderSource] Error when decoding audio file stream: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }, "audio-data-decode");
        this.decodeThread.start();
    }

    private void decodeFrame() {
        if (!this.eoInputStream) {
            int n = this.mMediaCodec.dequeueInputBuffer(1000L);
            while (n < 0) {
                ++this.mRetryCount;
                if (this.mRetryCount >= 100) {
                    sLogListener.onLog(6, "[DecoderSource] dequeueInputBuffer failed after 100 times retry.");
                    this.eoOutputStream = true;
                    break;
                }
                n = this.mMediaCodec.dequeueInputBuffer(1000L);
            }
            if (n >= 0) {
                ByteBuffer byteBuffer;
                if (Build.VERSION.SDK_INT >= 21) {
                    byteBuffer = this.mMediaCodec.getInputBuffer(n);
                } else {
                    ByteBuffer[] byteBufferArray = this.mMediaCodec.getInputBuffers();
                    byteBuffer = byteBufferArray[n];
                }
                int n2 = this.mExtractor.readSampleData(byteBuffer, 0);
                if (n2 <= 0) {
                    n2 = 0;
                    sLogListener.onLog(6, "[DecoderSource] Touch the end of the input stream, current loop times: " + this.targetLoopTimes);
                    if (this.targetLoopTimes-- != 0) {
                        this.needRewind = true;
                    } else {
                        this.eoInputStream = true;
                    }
                }
                long l = this.mExtractor.getSampleTime();
                int n3 = this.mExtractor.getSampleFlags();
                if (this.eoInputStream) {
                    n3 |= 4;
                }
                this.mMediaCodec.queueInputBuffer(n, 0, n2, l, n3);
                this.mExtractor.advance();
            }
        }
        this.mRetryCount = 0;
        if (!this.eoOutputStream) {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 1000L);
            while (n < 0) {
                ++this.mRetryCount;
                if (this.mRetryCount >= 100) {
                    sLogListener.onLog(6, "[DecoderSource] dequeueOutputBuffer failed after 100 times retry.");
                    this.queueForDecode.offerLast(0);
                    break;
                }
                n = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 1000L);
            }
            if (n >= 0) {
                this.mRetryCount = 0;
                if ((bufferInfo.flags & 4) == 4) {
                    sLogListener.onLog(6, "[DecoderSource] Touch the end of the output stream");
                    boolean bl = this.needRelease = !this.needRewind;
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    ByteBuffer byteBuffer = this.mMediaCodec.getOutputBuffer(n);
                    this.cloneByteBuffer(byteBuffer);
                } else {
                    ByteBuffer[] byteBufferArray = this.mMediaCodec.getOutputBuffers();
                    ByteBuffer byteBuffer = byteBufferArray[n];
                    this.cloneByteBufferByLength(byteBuffer, bufferInfo.size);
                }
                this.mMediaCodec.releaseOutputBuffer(n, false);
            }
        }
        if (this.needRelease) {
            sLogListener.onLog(6, "[DecoderSource] decodeFrame, need to release DecoderSource");
            this.needRelease = false;
            this.release();
        }
        if (this.needRewind) {
            sLogListener.onLog(6, "[DecoderSource] decodeFrame, need to rewind DecoderSource");
            this.needRewind = false;
            this.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneByteBuffer(ByteBuffer byteBuffer) {
        try {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.limit());
            byteBuffer2.put(byteBuffer);
            byteBuffer2.position(0);
            ArrayDeque<ByteBuffer> arrayDeque = this.queueForUse;
            synchronized (arrayDeque) {
                this.queueForUse.offerLast(byteBuffer2);
            }
        }
        catch (Exception exception) {
            sLogListener.onLog(6, "[DecoderSource] Error when clone byte buffer: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneByteBufferByLength(ByteBuffer byteBuffer, int n) {
        try {
            byteBuffer.limit(n);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.position(0);
            ArrayDeque<ByteBuffer> arrayDeque = this.queueForUse;
            synchronized (arrayDeque) {
                this.queueForUse.offerLast(byteBuffer2);
            }
        }
        catch (Exception exception) {
            sLogListener.onLog(6, "[DecoderSource] Error when clone byte buffer: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

