/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.audio;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import com.superrtc.CalledByNative;
import com.superrtc.Logging;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class MediaCodecAudioDecoder1 {
    private static final String TAG = "MediaCodecAudioDecoder";
    private static int MAX_DECODER_RETRY_COUNT = 100;
    private static int HTTP_REQUEST_TIMEOUT = 3000;
    private static final int LENG_DECODE = 882;
    public static Context mContext = null;
    private MediaCodec mMediaCodec = null;
    private MediaExtractor mExtractor = null;
    private MediaFormat mTrackFormat = null;
    private boolean mDecodedDataReady = false;
    private boolean eoInputStream = false;
    private boolean eoOutputStream = false;
    private int mSampleRate = 44100;
    private int mChannels = 2;
    private long mFileLength;
    private int mRetryCount = 0;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private ByteBuffer mDecodedRAWBuffer;
    private MediaCodec mAACDecoder = null;
    private ByteBuffer mAACOutputBuffer = ByteBuffer.allocateDirect(4096);
    private BlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>(2);

    @CalledByNative
    public MediaCodecAudioDecoder1() {
        Log.i((String)TAG, (String)"MediaCodecAudioDecoder constructor");
    }

    @CalledByNative
    public boolean createStreaming(String string) {
        string = "/assets/audio.mp3";
        try {
            int n;
            HttpURLConnection httpURLConnection;
            Logging.d(TAG, "Try to decode audio file : " + string);
            this.mRetryCount = 0;
            String string2 = "/assets/";
            boolean bl = string.startsWith(string2);
            boolean bl2 = string.toLowerCase().startsWith("http");
            this.mExtractor = new MediaExtractor();
            if (bl) {
                if (mContext == null) {
                    return false;
                }
                httpURLConnection = mContext.getAssets().openFd(string.substring(string2.length()));
                this.mExtractor.setDataSource(httpURLConnection.getFileDescriptor(), httpURLConnection.getStartOffset(), httpURLConnection.getLength());
            } else if (bl2) {
                try {
                    HttpURLConnection.setFollowRedirects(false);
                    httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
                    httpURLConnection.setConnectTimeout(HTTP_REQUEST_TIMEOUT);
                    httpURLConnection.setReadTimeout(HTTP_REQUEST_TIMEOUT);
                    httpURLConnection.connect();
                    if (httpURLConnection.getResponseCode() != 200) {
                        return false;
                    }
                    this.mExtractor.setDataSource(string);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Logging.e(TAG, "Connect timeout on URL : " + string);
                    return false;
                }
                catch (IOException iOException) {
                    Logging.e(TAG, "Connect IOException on URL : " + string);
                    return false;
                }
            } else {
                this.mExtractor.setDataSource(string);
            }
            int n2 = this.mExtractor.getTrackCount();
            for (n = 0; n < n2; ++n) {
                this.mExtractor.unselectTrack(n);
            }
            for (n = 0; n < n2; ++n) {
                this.mTrackFormat = this.mExtractor.getTrackFormat(n);
                String string3 = this.mTrackFormat.getString("mime");
                if (!string3.contains("audio/")) continue;
                this.mExtractor.selectTrack(n);
                this.mMediaCodec = MediaCodec.createDecoderByType((String)string3);
                this.mMediaCodec.configure(this.mTrackFormat, null, null, 0);
                break;
            }
            if (this.mMediaCodec != null) {
                this.mMediaCodec.start();
            }
            this.mChannels = this.mTrackFormat.getInteger("channel-count");
            this.mSampleRate = this.mTrackFormat.getInteger("sample-rate");
            this.mFileLength = this.mTrackFormat.getLong("durationUs");
            Log.i((String)TAG, (String)("createStreaming: mChannels: " + this.mChannels + ", mSampleRate: " + this.mSampleRate + ", mFileLength: " + this.mFileLength));
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error when creating aac audio file decoder");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @CalledByNative
    public int getChannelCount() {
        return this.mChannels;
    }

    @CalledByNative
    public int getSampleRate() {
        return this.mSampleRate;
    }

    @CalledByNative
    public ByteBuffer getDecodedRAWBuffer() {
        return this.mDecodedRAWBuffer;
    }

    @CalledByNative
    public long getFileLength() {
        return this.mFileLength;
    }

    @CalledByNative
    public long getCurrentFilePosition() {
        return this.mExtractor.getSampleTime();
    }

    @CalledByNative
    public void setCurrentFilePosition(long l) {
        this.mExtractor.seekTo(l, 2);
    }

    @CalledByNative
    public boolean getDecodeDataReadyFlag() {
        return this.mDecodedDataReady;
    }

    @CalledByNative
    public void releaseStreaming() {
        try {
            if (this.mMediaCodec != null) {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            if (this.mExtractor != null) {
                this.mExtractor.release();
                this.mExtractor = null;
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "Error when releasing audio file stream");
            exception.printStackTrace();
        }
        this.eoOutputStream = false;
        this.eoInputStream = false;
    }

    @CalledByNative
    public void rewindStreaming() {
        try {
            this.mExtractor.seekTo(0L, 1);
            this.mMediaCodec.flush();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Error when rewinding audio file stream");
            exception.printStackTrace();
        }
        this.eoInputStream = false;
        this.eoOutputStream = false;
        this.mDecodedDataReady = false;
    }

    @CalledByNative
    public boolean decodeFrame() {
        Log.i((String)TAG, (String)"decodeFrame: ");
        try {
            int n;
            if (!this.eoInputStream && (n = this.mMediaCodec.dequeueInputBuffer(0L)) >= 0) {
                ByteBuffer byteBuffer;
                if (Build.VERSION.SDK_INT >= 21) {
                    byteBuffer = this.mMediaCodec.getInputBuffer(n);
                } else {
                    this.mInputBuffers = this.mMediaCodec.getInputBuffers();
                    byteBuffer = this.mInputBuffers[n];
                }
                Log.i((String)TAG, (String)("decodeFrame: " + byteBuffer.limit()));
                int n2 = this.mExtractor.readSampleData(byteBuffer, 0);
                if (n2 <= 0) {
                    n2 = 0;
                    this.eoInputStream = true;
                }
                Log.i((String)TAG, (String)("decodeFrame: sampleSize " + n2));
                long l = this.mExtractor.getSampleTime();
                int n3 = this.mExtractor.getSampleFlags();
                if (this.eoInputStream) {
                    n3 |= 4;
                }
                this.mMediaCodec.queueInputBuffer(n, 0, n2, l, n3);
                this.mExtractor.advance();
            }
            if (!this.eoOutputStream) {
                MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                int n4 = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
                this.mDecodedDataReady = false;
                if (n4 == -1) {
                    ++this.mRetryCount;
                    if (this.mRetryCount >= MAX_DECODER_RETRY_COUNT && (Build.BRAND.toLowerCase().contains("meizu") || Build.MANUFACTURER.toLowerCase().contains("meizu"))) {
                        Log.e((String)TAG, (String)("EAGAIN count=" + this.mRetryCount + " presentationTimeUs=" + bufferInfo.presentationTimeUs + " totalUs=" + this.mFileLength + " Force EOS"));
                        this.eoOutputStream = true;
                    }
                } else {
                    this.mRetryCount = 0;
                    if (n4 >= 0) {
                        ByteBuffer byteBuffer;
                        if ((bufferInfo.flags & 4) == 4) {
                            this.eoOutputStream = true;
                        }
                        if (Build.VERSION.SDK_INT >= 21) {
                            byteBuffer = this.mMediaCodec.getOutputBuffer(n4);
                            this.cloneByteBuffer(byteBuffer);
                        } else {
                            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                            byteBuffer = this.mOutputBuffers[n4];
                            this.cloneByteBufferByLength(byteBuffer, bufferInfo.size);
                        }
                        Log.i((String)TAG, (String)("decodeFrame: decode buffer length: " + byteBuffer.limit()));
                        this.mMediaCodec.releaseOutputBuffer(n4, false);
                        this.mDecodedDataReady = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "Error when decoding audio file stream");
            exception.printStackTrace();
        }
        return this.eoOutputStream;
    }

    private void cloneByteBuffer(ByteBuffer byteBuffer) {
        try {
            if (this.mDecodedRAWBuffer == null || this.mDecodedRAWBuffer.limit() != byteBuffer.limit()) {
                if (this.mDecodedRAWBuffer != null) {
                    this.mDecodedRAWBuffer.clear();
                    this.mDecodedRAWBuffer = null;
                }
                this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(byteBuffer.limit());
            }
            this.mDecodedRAWBuffer.position(0);
            this.mDecodedRAWBuffer.put(byteBuffer);
            this.push();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void cloneByteBufferByLength(ByteBuffer byteBuffer, int n) {
        try {
            if (this.mDecodedRAWBuffer == null || this.mDecodedRAWBuffer.capacity() < n) {
                if (this.mDecodedRAWBuffer != null) {
                    this.mDecodedRAWBuffer.clear();
                    this.mDecodedRAWBuffer = null;
                }
                this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(n);
            }
            this.mDecodedRAWBuffer.position(0);
            byteBuffer.limit(n);
            this.mDecodedRAWBuffer.put(byteBuffer);
            this.push();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void push() {
    }
}

