/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.audio;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import com.superrtc.CalledByNative;
import com.superrtc.Logging;
import java.nio.ByteBuffer;

public class MediaCodecAudioDecoder {
    private static final String TAG = "AssetsFileReader";
    public static Context mContext = null;
    private MediaExtractor mExtractor = null;
    private MediaFormat mTrackFormat = null;
    private boolean mDecodedDataReady = false;
    private boolean eoOutputStream = false;
    private int mSampleRate = 44100;
    private int mChannels = 2;
    private long mFileLength;
    private int lengthRead = 0;
    private ByteBuffer mDecodedRAWBuffer;

    @CalledByNative
    public MediaCodecAudioDecoder() {
        Log.i((String)TAG, (String)"MediaCodecAudioDecoder constructor");
    }

    @CalledByNative
    public boolean createStreaming(String string) {
        string = "/assets/audio.wav";
        try {
            int n;
            Logging.d(TAG, "Try to decode audio file : " + string);
            this.mExtractor = new MediaExtractor();
            if (mContext == null) {
                return false;
            }
            AssetFileDescriptor assetFileDescriptor = mContext.getAssets().openFd("audio.wav");
            this.mExtractor.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
            int n2 = this.mExtractor.getTrackCount();
            for (n = 0; n < n2; ++n) {
                this.mExtractor.unselectTrack(n);
            }
            for (n = 0; n < n2; ++n) {
                this.mTrackFormat = this.mExtractor.getTrackFormat(n);
                String string2 = this.mTrackFormat.getString("mime");
                if (!string2.contains("audio/")) continue;
                this.mExtractor.selectTrack(n);
                break;
            }
            this.mChannels = this.mTrackFormat.getInteger("channel-count");
            this.mSampleRate = this.mTrackFormat.getInteger("sample-rate");
            this.mFileLength = this.mTrackFormat.getLong("durationUs");
            this.lengthRead = this.mSampleRate / 100 * this.mChannels;
            Log.i((String)TAG, (String)("createStreaming: mChannels: " + this.mChannels + ", mSampleRate: " + this.mSampleRate + ", lengthRead: " + this.lengthRead));
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error when creating aac audio file decoder");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @CalledByNative
    public int getChannelCount() {
        return this.mChannels;
    }

    @CalledByNative
    public int getSampleRate() {
        return this.mSampleRate;
    }

    @CalledByNative
    public ByteBuffer getDecodedRAWBuffer() {
        return this.mDecodedRAWBuffer;
    }

    @CalledByNative
    public long getFileLength() {
        return this.mFileLength;
    }

    @CalledByNative
    public long getCurrentFilePosition() {
        return this.mExtractor.getSampleTime();
    }

    @CalledByNative
    public void setCurrentFilePosition(long l) {
        this.mExtractor.seekTo(l, 2);
    }

    @CalledByNative
    public boolean getDecodeDataReadyFlag() {
        return this.mDecodedDataReady;
    }

    @CalledByNative
    public void releaseStreaming() {
        try {
            if (this.mExtractor != null) {
                this.mExtractor.release();
                this.mExtractor = null;
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "Error when releasing audio file stream");
            exception.printStackTrace();
        }
        this.eoOutputStream = false;
    }

    @CalledByNative
    public void rewindStreaming() {
        try {
            this.mExtractor.seekTo(0L, 1);
        }
        catch (Exception exception) {
            Logging.e(TAG, "Error when rewinding audio file stream");
            exception.printStackTrace();
        }
        this.eoOutputStream = false;
        this.mDecodedDataReady = false;
    }

    @CalledByNative
    public boolean decodeFrame() {
        Log.i((String)TAG, (String)"decodeFrame: ");
        if (this.mDecodedRAWBuffer != null) {
            this.mDecodedRAWBuffer.clear();
            this.mDecodedRAWBuffer = null;
        }
        Log.i((String)TAG, (String)"decodeFrame: 1");
        this.mDecodedRAWBuffer = ByteBuffer.allocate(this.lengthRead);
        Log.i((String)TAG, (String)"decodeFrame: 2");
        int n = this.mExtractor.readSampleData(this.mDecodedRAWBuffer, 0);
        Log.i((String)TAG, (String)"decodeFrame: 3");
        this.mDecodedRAWBuffer.position(0);
        this.mExtractor.advance();
        Log.i((String)TAG, (String)("decodeFrame: " + n));
        if (n <= 0) {
            this.rewindStreaming();
        }
        return this.eoOutputStream;
    }

    private void cloneByteBuffer(ByteBuffer byteBuffer) {
        try {
            if (this.mDecodedRAWBuffer == null || this.mDecodedRAWBuffer.limit() != byteBuffer.limit()) {
                if (this.mDecodedRAWBuffer != null) {
                    this.mDecodedRAWBuffer.clear();
                    this.mDecodedRAWBuffer = null;
                }
                this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(byteBuffer.limit());
            }
            this.mDecodedRAWBuffer.position(0);
            this.mDecodedRAWBuffer.put(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void cloneByteBufferByLength(ByteBuffer byteBuffer, int n) {
        try {
            if (this.mDecodedRAWBuffer == null || this.mDecodedRAWBuffer.capacity() < n) {
                if (this.mDecodedRAWBuffer != null) {
                    this.mDecodedRAWBuffer.clear();
                    this.mDecodedRAWBuffer = null;
                }
                this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(n);
            }
            this.mDecodedRAWBuffer.position(0);
            byteBuffer.limit(n);
            this.mDecodedRAWBuffer.put(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

