/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.MediaStreamTrack;
import com.superrtc.VideoSink;
import java.util.IdentityHashMap;

public class VideoTrack
extends MediaStreamTrack {
    private final IdentityHashMap<VideoSink, Long> sinks = new IdentityHashMap();

    public VideoTrack(long l) {
        super(l);
    }

    public void addSink(VideoSink videoSink) {
        if (videoSink == null) {
            throw new IllegalArgumentException("The VideoSink is not allowed to be null");
        }
        if (!this.sinks.containsKey(videoSink)) {
            long l = VideoTrack.nativeWrapSink(videoSink);
            this.sinks.put(videoSink, l);
            VideoTrack.nativeAddSink(this.getNativeMediaStreamTrack(), l);
        }
    }

    public void removeSink(VideoSink videoSink) {
        Long l = this.sinks.remove(videoSink);
        if (l != null) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), l);
            VideoTrack.nativeFreeSink(l);
        }
    }

    @Override
    public void dispose() {
        for (long l : this.sinks.values()) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), l);
            VideoTrack.nativeFreeSink(l);
        }
        this.sinks.clear();
        super.dispose();
    }

    long getNativeVideoTrack() {
        return this.getNativeMediaStreamTrack();
    }

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(VideoSink var0);

    private static native void nativeFreeSink(long var0);
}

