/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.CalledByNative;
import com.superrtc.DtmfSender;
import com.superrtc.FrameEncryptor;
import com.superrtc.JniCommon;
import com.superrtc.MediaStreamTrack;
import com.superrtc.RtpParameters;
import javax.annotation.Nullable;

public class RtpSender {
    private long nativeRtpSender;
    @Nullable
    private MediaStreamTrack cachedTrack;
    private boolean ownsTrack = true;
    @Nullable
    private final DtmfSender dtmfSender;

    @CalledByNative
    public RtpSender(long l) {
        this.nativeRtpSender = l;
        long l2 = RtpSender.nativeGetTrack(l);
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(l2);
        long l3 = RtpSender.nativeGetDtmfSender(l);
        this.dtmfSender = l3 != 0L ? new DtmfSender(l3) : null;
    }

    public boolean setTrack(@Nullable MediaStreamTrack mediaStreamTrack, boolean bl) {
        this.checkRtpSenderExists();
        if (!RtpSender.nativeSetTrack(this.nativeRtpSender, mediaStreamTrack == null ? 0L : mediaStreamTrack.getNativeMediaStreamTrack())) {
            return false;
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        this.cachedTrack = mediaStreamTrack;
        this.ownsTrack = bl;
        return true;
    }

    @Nullable
    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public boolean setParameters(RtpParameters rtpParameters) {
        this.checkRtpSenderExists();
        return RtpSender.nativeSetParameters(this.nativeRtpSender, rtpParameters);
    }

    public RtpParameters getParameters() {
        this.checkRtpSenderExists();
        return RtpSender.nativeGetParameters(this.nativeRtpSender);
    }

    public String id() {
        this.checkRtpSenderExists();
        return RtpSender.nativeGetId(this.nativeRtpSender);
    }

    @Nullable
    public DtmfSender dtmf() {
        return this.dtmfSender;
    }

    public void setFrameEncryptor(FrameEncryptor frameEncryptor) {
        this.checkRtpSenderExists();
        RtpSender.nativeSetFrameEncryptor(this.nativeRtpSender, frameEncryptor.getNativeFrameEncryptor());
    }

    public void dispose() {
        this.checkRtpSenderExists();
        if (this.dtmfSender != null) {
            this.dtmfSender.dispose();
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        JniCommon.nativeReleaseRef(this.nativeRtpSender);
        this.nativeRtpSender = 0L;
    }

    long getNativeRtpSender() {
        this.checkRtpSenderExists();
        return this.nativeRtpSender;
    }

    private void checkRtpSenderExists() {
        if (this.nativeRtpSender == 0L) {
            throw new IllegalStateException("RtpSender has been disposed.");
        }
    }

    private static native boolean nativeSetTrack(long var0, long var2);

    private static native long nativeGetTrack(long var0);

    private static native long nativeGetDtmfSender(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);

    private static native void nativeSetFrameEncryptor(long var0, long var2);
}

