/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.content.Context;
import android.util.Log;
import com.superrtc.AudioProcessingFactory;
import com.superrtc.AudioSource;
import com.superrtc.AudioTrack;
import com.superrtc.CalledByNative;
import com.superrtc.ContextUtils;
import com.superrtc.FecControllerFactoryFactoryInterface;
import com.superrtc.JNILogging;
import com.superrtc.Loggable;
import com.superrtc.Logging;
import com.superrtc.MediaCodecVideoDecoder;
import com.superrtc.MediaCodecVideoEncoder;
import com.superrtc.MediaConstraints;
import com.superrtc.MediaStream;
import com.superrtc.NativeLibrary;
import com.superrtc.NativeLibraryLoader;
import com.superrtc.PeerConnection;
import com.superrtc.PeerConnectionDependencies;
import com.superrtc.SSLCertificateVerifier;
import com.superrtc.VideoDecoderFactory;
import com.superrtc.VideoEncoderFactory;
import com.superrtc.VideoSource;
import com.superrtc.VideoTrack;
import com.superrtc.audio.AudioDeviceModule;
import com.superrtc.audio.LegacyAudioDeviceModule;
import java.util.List;
import javax.annotation.Nullable;

public class PeerConnectionFactory {
    public static final String TRIAL_ENABLED = "Enabled";
    @Deprecated
    public static final String VIDEO_FRAME_EMIT_TRIAL = "VideoFrameEmit";
    private static final String TAG = "PeerConnectionFactory";
    private static final String VIDEO_CAPTURER_THREAD_NAME = "VideoCapturerThread";
    private long nativeFactory;
    private static volatile boolean internalTracerInitialized;
    @Nullable
    private static Thread networkThread;
    @Nullable
    private static Thread workerThread;
    @Nullable
    private static Thread signalingThread;

    public static Builder builder() {
        return new Builder();
    }

    public static void initialize(InitializationOptions initializationOptions) {
        ContextUtils.initialize(initializationOptions.applicationContext);
        NativeLibrary.initialize(initializationOptions.nativeLibraryLoader, initializationOptions.nativeLibraryName);
        PeerConnectionFactory.nativeInitializeAndroidGlobals();
        PeerConnectionFactory.nativeInitializeFieldTrials(initializationOptions.fieldTrials);
        if (initializationOptions.enableInternalTracer && !internalTracerInitialized) {
            PeerConnectionFactory.initializeInternalTracer();
        }
        if (initializationOptions.loggable != null) {
            Logging.injectLoggable(initializationOptions.loggable, initializationOptions.loggableSeverity);
            PeerConnectionFactory.nativeInjectLoggable(new JNILogging(initializationOptions.loggable), initializationOptions.loggableSeverity.ordinal());
        } else {
            Logging.d(TAG, "PeerConnectionFactory was initialized without an injected Loggable. Any existing Loggable will be deleted.");
            Logging.deleteInjectedLoggable();
            PeerConnectionFactory.nativeDeleteLoggable();
        }
    }

    protected void finalize() throws Throwable {
        Log.i((String)TAG, (String)"finalize: ");
        super.finalize();
        PeerConnectionFactory.nativeFreeFactory(this.nativeFactory);
    }

    private void checkInitializeHasBeenCalled() {
        if (!NativeLibrary.isLoaded() || ContextUtils.getApplicationContext() == null) {
            throw new IllegalStateException("PeerConnectionFactory.initialize was not called before creating a PeerConnectionFactory.");
        }
    }

    private static void initializeInternalTracer() {
        internalTracerInitialized = true;
        PeerConnectionFactory.nativeInitializeInternalTracer();
    }

    public static void shutdownInternalTracer() {
        internalTracerInitialized = false;
        PeerConnectionFactory.nativeShutdownInternalTracer();
    }

    @Deprecated
    public static void initializeFieldTrials(String string) {
        PeerConnectionFactory.nativeInitializeFieldTrials(string);
    }

    public static String fieldTrialsFindFullName(String string) {
        return NativeLibrary.isLoaded() ? PeerConnectionFactory.nativeFindFieldTrialsFullName(string) : "";
    }

    public static boolean startInternalTracingCapture(String string) {
        return PeerConnectionFactory.nativeStartInternalTracingCapture(string);
    }

    public static void stopInternalTracingCapture() {
        PeerConnectionFactory.nativeStopInternalTracingCapture();
    }

    private PeerConnectionFactory(Options options, @Nullable AudioDeviceModule audioDeviceModule, @Nullable VideoEncoderFactory videoEncoderFactory, @Nullable VideoDecoderFactory videoDecoderFactory, @Nullable AudioProcessingFactory audioProcessingFactory, @Nullable FecControllerFactoryFactoryInterface fecControllerFactoryFactoryInterface) {
        this.checkInitializeHasBeenCalled();
        this.nativeFactory = PeerConnectionFactory.nativeCreatePeerConnectionFactory(ContextUtils.getApplicationContext(), options, audioDeviceModule == null ? 0L : audioDeviceModule.getNativeAudioDeviceModulePointer(), videoEncoderFactory, videoDecoderFactory, audioProcessingFactory == null ? 0L : audioProcessingFactory.createNative(), fecControllerFactoryFactoryInterface == null ? 0L : fecControllerFactoryFactoryInterface.createNative());
        if (this.nativeFactory == 0L) {
            throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
        }
    }

    @CalledByNative
    PeerConnectionFactory(long l) {
        this.checkInitializeHasBeenCalled();
        if (l == 0L) {
            throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
        }
        this.nativeFactory = l;
    }

    @Nullable
    PeerConnection createPeerConnectionInternal(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer, SSLCertificateVerifier sSLCertificateVerifier) {
        this.checkPeerConnectionFactoryExists();
        long l = PeerConnection.createNativePeerConnectionObserver(observer);
        if (l == 0L) {
            return null;
        }
        long l2 = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, rTCConfiguration, mediaConstraints, l, sSLCertificateVerifier);
        if (l2 == 0L) {
            return null;
        }
        return new PeerConnection(l2);
    }

    @Nullable
    @Deprecated
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        return this.createPeerConnectionInternal(rTCConfiguration, mediaConstraints, observer, null);
    }

    @Nullable
    @Deprecated
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        PeerConnection.RTCConfiguration rTCConfiguration = new PeerConnection.RTCConfiguration(list);
        return this.createPeerConnection(rTCConfiguration, mediaConstraints, observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, PeerConnection.Observer observer) {
        PeerConnection.RTCConfiguration rTCConfiguration = new PeerConnection.RTCConfiguration(list);
        return this.createPeerConnection(rTCConfiguration, observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, PeerConnection.Observer observer) {
        return this.createPeerConnection(rTCConfiguration, null, observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, PeerConnectionDependencies peerConnectionDependencies) {
        return this.createPeerConnectionInternal(rTCConfiguration, null, peerConnectionDependencies.getObserver(), peerConnectionDependencies.getSSLCertificateVerifier());
    }

    public MediaStream createLocalMediaStream(String string) {
        this.checkPeerConnectionFactoryExists();
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, string));
    }

    public VideoSource createVideoSource(boolean bl) {
        this.checkPeerConnectionFactoryExists();
        return new VideoSource(PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, bl));
    }

    public VideoTrack createVideoTrack(String string, VideoSource videoSource) {
        this.checkPeerConnectionFactoryExists();
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, string, videoSource.getNativeVideoTrackSource()));
    }

    public AudioSource createAudioSource(MediaConstraints mediaConstraints) {
        this.checkPeerConnectionFactoryExists();
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, mediaConstraints));
    }

    public AudioTrack createAudioTrack(String string, AudioSource audioSource) {
        this.checkPeerConnectionFactoryExists();
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, string, audioSource.getNativeAudioSource()));
    }

    public boolean startAecDump(int n, int n2) {
        this.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeStartAecDump(this.nativeFactory, n, n2);
    }

    public void stopAecDump() {
        this.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeStopAecDump(this.nativeFactory);
    }

    public void dispose() {
        this.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeFreeFactory(this.nativeFactory);
        networkThread = null;
        workerThread = null;
        signalingThread = null;
        MediaCodecVideoEncoder.disposeEglContext();
        MediaCodecVideoDecoder.disposeEglContext();
        this.nativeFactory = 0L;
    }

    public void threadsCallbacks() {
        this.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeInvokeThreadsCallbacks(this.nativeFactory);
    }

    public long getNativePeerConnectionFactory() {
        this.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeGetNativePeerConnectionFactory(this.nativeFactory);
    }

    public long getNativeOwnedFactoryAndThreads() {
        this.checkPeerConnectionFactoryExists();
        return this.nativeFactory;
    }

    private void checkPeerConnectionFactoryExists() {
        if (this.nativeFactory == 0L) {
            throw new IllegalStateException("PeerConnectionFactory has been disposed.");
        }
    }

    private static void printStackTrace(@Nullable Thread thread, String string) {
        StackTraceElement[] stackTraceElementArray;
        if (thread != null && (stackTraceElementArray = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, string + " stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(networkThread, "Network thread");
        PeerConnectionFactory.printStackTrace(workerThread, "Worker thread");
        PeerConnectionFactory.printStackTrace(signalingThread, "Signaling thread");
    }

    @CalledByNative
    private static void onNetworkThreadReady() {
        networkThread = Thread.currentThread();
        Logging.d(TAG, "onNetworkThreadReady");
    }

    @CalledByNative
    private static void onWorkerThreadReady() {
        workerThread = Thread.currentThread();
        Logging.d(TAG, "onWorkerThreadReady");
    }

    @CalledByNative
    private static void onSignalingThreadReady() {
        signalingThread = Thread.currentThread();
        Logging.d(TAG, "onSignalingThreadReady");
    }

    private static native void nativeInitializeAndroidGlobals();

    private static native void nativeInitializeFieldTrials(String var0);

    private static native String nativeFindFieldTrialsFullName(String var0);

    private static native void nativeInitializeInternalTracer();

    private static native void nativeShutdownInternalTracer();

    private static native boolean nativeStartInternalTracingCapture(String var0);

    private static native void nativeStopInternalTracingCapture();

    private static native long nativeCreatePeerConnectionFactory(Context var0, Options var1, long var2, VideoEncoderFactory var4, VideoDecoderFactory var5, long var6, long var8);

    private static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4, SSLCertificateVerifier var6);

    private static native long nativeCreateLocalMediaStream(long var0, String var2);

    private static native long nativeCreateVideoSource(long var0, boolean var2);

    private static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    private static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    private static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    private static native boolean nativeStartAecDump(long var0, int var2, int var3);

    private static native void nativeStopAecDump(long var0);

    private static native void nativeInvokeThreadsCallbacks(long var0);

    private static native void nativeFreeFactory(long var0);

    private static native long nativeGetNativePeerConnectionFactory(long var0);

    private static native void nativeInjectLoggable(JNILogging var0, int var1);

    private static native void nativeDeleteLoggable();

    public static class Builder {
        @Nullable
        private Options options;
        @Nullable
        private AudioDeviceModule audioDeviceModule = new LegacyAudioDeviceModule();
        @Nullable
        private VideoEncoderFactory encoderFactory;
        @Nullable
        private VideoDecoderFactory decoderFactory;
        @Nullable
        private AudioProcessingFactory audioProcessingFactory;
        @Nullable
        private FecControllerFactoryFactoryInterface fecControllerFactoryFactory;

        private Builder() {
        }

        public Builder setOptions(Options options) {
            this.options = options;
            return this;
        }

        public Builder setAudioDeviceModule(AudioDeviceModule audioDeviceModule) {
            this.audioDeviceModule = audioDeviceModule;
            return this;
        }

        public Builder setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
            this.encoderFactory = videoEncoderFactory;
            return this;
        }

        public Builder setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
            this.decoderFactory = videoDecoderFactory;
            return this;
        }

        public Builder setAudioProcessingFactory(AudioProcessingFactory audioProcessingFactory) {
            if (audioProcessingFactory == null) {
                throw new NullPointerException("PeerConnectionFactory builder does not accept a null AudioProcessingFactory.");
            }
            this.audioProcessingFactory = audioProcessingFactory;
            return this;
        }

        public Builder setFecControllerFactoryFactoryInterface(FecControllerFactoryFactoryInterface fecControllerFactoryFactoryInterface) {
            this.fecControllerFactoryFactory = fecControllerFactoryFactoryInterface;
            return this;
        }

        public PeerConnectionFactory createPeerConnectionFactory() {
            return new PeerConnectionFactory(this.options, this.audioDeviceModule, this.encoderFactory, this.decoderFactory, this.audioProcessingFactory, this.fecControllerFactoryFactory);
        }
    }

    public static class Options {
        static final int ADAPTER_TYPE_UNKNOWN = 0;
        static final int ADAPTER_TYPE_ETHERNET = 1;
        static final int ADAPTER_TYPE_WIFI = 2;
        static final int ADAPTER_TYPE_CELLULAR = 4;
        static final int ADAPTER_TYPE_VPN = 8;
        static final int ADAPTER_TYPE_LOOPBACK = 16;
        static final int ADAPTER_TYPE_ANY = 32;
        public int networkIgnoreMask;
        public boolean disableEncryption;
        public boolean disableNetworkMonitor;
        public boolean enableAes128Sha1_32CryptoCipher;
        public boolean enableGcmCryptoSuites;

        @CalledByNative(value="Options")
        int getNetworkIgnoreMask() {
            return this.networkIgnoreMask;
        }

        @CalledByNative(value="Options")
        boolean getDisableEncryption() {
            return this.disableEncryption;
        }

        @CalledByNative(value="Options")
        boolean getDisableNetworkMonitor() {
            return this.disableNetworkMonitor;
        }

        @CalledByNative(value="Options")
        boolean getEnableAes128Sha1_32CryptoCipher() {
            return this.enableAes128Sha1_32CryptoCipher;
        }

        @CalledByNative(value="Options")
        boolean getEnableGcmCryptoSuites() {
            return this.enableGcmCryptoSuites;
        }
    }

    public static class InitializationOptions {
        final Context applicationContext;
        final String fieldTrials;
        final boolean enableInternalTracer;
        final NativeLibraryLoader nativeLibraryLoader;
        final String nativeLibraryName;
        @Nullable
        Loggable loggable;
        @Nullable
        Logging.Severity loggableSeverity;

        private InitializationOptions(Context context, String string, boolean bl, NativeLibraryLoader nativeLibraryLoader, String string2, @Nullable Loggable loggable, @Nullable Logging.Severity severity) {
            this.applicationContext = context;
            this.fieldTrials = string;
            this.enableInternalTracer = bl;
            this.nativeLibraryLoader = nativeLibraryLoader;
            this.nativeLibraryName = string2;
            this.loggable = loggable;
            this.loggableSeverity = severity;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public static class Builder {
            private final Context applicationContext;
            private String fieldTrials = "";
            private boolean enableInternalTracer;
            private NativeLibraryLoader nativeLibraryLoader = new NativeLibrary.DefaultLoader();
            private String nativeLibraryName = "hyphenate_av";
            @Nullable
            private Loggable loggable;
            @Nullable
            private Logging.Severity loggableSeverity;

            Builder(Context context) {
                this.applicationContext = context;
            }

            public Builder setFieldTrials(String string) {
                this.fieldTrials = string;
                return this;
            }

            public Builder setEnableInternalTracer(boolean bl) {
                this.enableInternalTracer = bl;
                return this;
            }

            public Builder setNativeLibraryLoader(NativeLibraryLoader nativeLibraryLoader) {
                this.nativeLibraryLoader = nativeLibraryLoader;
                return this;
            }

            public Builder setNativeLibraryName(String string) {
                this.nativeLibraryName = string;
                return this;
            }

            public Builder setInjectableLogger(Loggable loggable, Logging.Severity severity) {
                this.loggable = loggable;
                this.loggableSeverity = severity;
                return this;
            }

            public InitializationOptions createInitializationOptions() {
                return new InitializationOptions(this.applicationContext, this.fieldTrials, this.enableInternalTracer, this.nativeLibraryLoader, this.nativeLibraryName, this.loggable, this.loggableSeverity);
            }
        }
    }
}

