/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.view.Surface;
import com.superrtc.CalledByNative;
import com.superrtc.CalledByNativeUnchecked;
import com.superrtc.DefaultVideoDecoderFactory;
import com.superrtc.EglBase;
import com.superrtc.H264Utils;
import com.superrtc.Logging;
import com.superrtc.MediaCodecVideoEncoder;
import com.superrtc.PeerConnectionFactory;
import com.superrtc.SurfaceTextureHelper;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoCodecInfo;
import com.superrtc.VideoDecoder;
import com.superrtc.VideoDecoderFactory;
import com.superrtc.VideoFrame;
import com.superrtc.VideoSink;
import com.superrtc.WrappedNativeVideoDecoder;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Deprecated
public class MediaCodecVideoDecoder {
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final long MAX_DECODE_TIME_MS = 200L;
    private static final String FORMAT_KEY_STRIDE = "stride";
    private static final String FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    @Nullable
    private static MediaCodecVideoDecoder runningInstance;
    @Nullable
    private static MediaCodecVideoDecoderErrorCallback errorCallback;
    private static int codecErrors;
    private static Set<String> hwDecoderDisabledTypes;
    @Nullable
    private static EglBase eglBase;
    @Nullable
    private Thread mediaCodecThread;
    @Nullable
    private MediaCodec mediaCodec;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String[] supportedVp9HwCodecPrefixes;
    private static final String supportedQcomH264HighProfileHwCodecPrefix = "OMX.qcom.";
    private static final String supportedExynosH264HighProfileHwCodecPrefix = "OMX.Exynos.";
    private static final String supportedMediaTekH264HighProfileHwCodecPrefix = "OMX.MTK.";
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList;
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private final Queue<TimeStamps> decodeStartTimeMs = new ArrayDeque<TimeStamps>();
    @Nullable
    private TextureListener textureListener;
    private int droppedFrames;
    @Nullable
    private Surface surface;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new ArrayDeque<DecodedOutputBuffer>();

    public static VideoDecoderFactory createFactory() {
        return new DefaultVideoDecoderFactory(new HwDecoderFactory());
    }

    private static final String[] supportedVp8HwCodecPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Nvidia.");
        arrayList.add(supportedExynosH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Intel.");
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekVP8").equals("Enabled") && Build.VERSION.SDK_INT >= 24) {
            arrayList.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static final String[] supportedH264HwCodecPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Intel.");
        arrayList.add(supportedExynosH264HighProfileHwCodecPrefix);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled") && Build.VERSION.SDK_INT >= 27) {
            arrayList.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void setEglContext(EglBase.Context context) {
        if (eglBase != null) {
            Logging.w(TAG, "Egl context already set.");
            eglBase.release();
        }
        eglBase = EglBase.create(context);
    }

    public static void disposeEglContext() {
        if (eglBase != null) {
            eglBase.release();
            eglBase = null;
        }
    }

    static boolean useSurface() {
        return eglBase != null;
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes()) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, MediaCodecVideoDecoder.supportedH264HwCodecPrefixes()) != null;
    }

    public static boolean isH264HighProfileHwSupported() {
        if (hwDecoderDisabledTypes.contains(H264_MIME_TYPE)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedQcomH264HighProfileHwCodecPrefix}) != null) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedExynosH264HighProfileHwCodecPrefix}) != null) {
            return true;
        }
        return PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled") && Build.VERSION.SDK_INT >= 27 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedMediaTekH264HighProfileHwCodecPrefix}) != null;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoDecoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoDecoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    @Nullable
    private static DecoderProperties findDecoder(String string, String[] codecCapabilities) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Logging.d(TAG, "Trying to find HW decoder for mime " + string);
        for (int k = 0; k < MediaCodecList.getCodecCount(); ++k) {
            MediaCodecInfo.CodecCapabilities codecCapabilities2;
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)k);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
            String string2 = null;
            for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                if (!string3.equals(string)) continue;
                string2 = mediaCodecInfo.getName();
                break;
            }
            if (string2 == null) continue;
            Logging.d(TAG, "Found candidate decoder " + string2);
            boolean bl = false;
            for (String string4 : codecCapabilities) {
                if (!string2.startsWith(string4)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            try {
                codecCapabilities2 = mediaCodecInfo.getCapabilitiesForType(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder capabilities", illegalArgumentException);
                continue;
            }
            for (int n : codecCapabilities2.colorFormats) {
                Logging.v(TAG, "   Color: 0x" + Integer.toHexString(n));
            }
            Object object = supportedColorList.iterator();
            while (object.hasNext()) {
                int n;
                int n2 = (Integer)object.next();
                int[] nArray = codecCapabilities2.colorFormats;
                n = nArray.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    int n3 = nArray[i2];
                    if (n3 != n2) continue;
                    Logging.d(TAG, "Found target decoder " + string2 + ". Color: 0x" + Integer.toHexString(n3));
                    return new DecoderProperties(string2, n3);
                }
            }
        }
        Logging.d(TAG, "No HW decoder found for mime " + string);
        return null;
    }

    @CalledByNative
    MediaCodecVideoDecoder() {
    }

    private void checkOnMediaCodecThread() throws IllegalStateException {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    @CalledByNativeUnchecked
    private boolean initDecode(VideoCodecType videoCodecType, int n, int n2) {
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        String string = null;
        String[] stringArray = null;
        if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
            string = VP8_MIME_TYPE;
            stringArray = MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes();
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP9) {
            string = VP9_MIME_TYPE;
            stringArray = supportedVp9HwCodecPrefixes;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H264) {
            string = H264_MIME_TYPE;
            stringArray = MediaCodecVideoDecoder.supportedH264HwCodecPrefixes();
        } else {
            throw new RuntimeException("initDecode: Non-supported codec " + (Object)((Object)videoCodecType));
        }
        DecoderProperties decoderProperties = MediaCodecVideoDecoder.findDecoder(string, stringArray);
        if (decoderProperties == null) {
            throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
        }
        Logging.d(TAG, "Java initDecode: " + (Object)((Object)videoCodecType) + " : " + n + " x " + n2 + ". Color: 0x" + Integer.toHexString(decoderProperties.colorFormat) + ". Use Surface: " + MediaCodecVideoDecoder.useSurface());
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            SurfaceTextureHelper surfaceTextureHelper;
            this.width = n;
            this.height = n2;
            this.stride = n;
            this.sliceHeight = n2;
            if (MediaCodecVideoDecoder.useSurface() && (surfaceTextureHelper = SurfaceTextureHelper.create("Decoder SurfaceTextureHelper", eglBase.getEglBaseContext())) != null) {
                this.textureListener = new TextureListener(surfaceTextureHelper);
                this.textureListener.setSize(n, n2);
                this.surface = new Surface(surfaceTextureHelper.getSurfaceTexture());
            }
            surfaceTextureHelper = MediaFormat.createVideoFormat((String)string, (int)n, (int)n2);
            if (!MediaCodecVideoDecoder.useSurface()) {
                surfaceTextureHelper.setInteger("color-format", decoderProperties.colorFormat);
            }
            Logging.d(TAG, "  Format: " + surfaceTextureHelper);
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            this.mediaCodec.configure((MediaFormat)surfaceTextureHelper, this.surface, null, 0);
            this.mediaCodec.start();
            this.colorFormat = decoderProperties.colorFormat;
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            this.inputBuffers = this.mediaCodec.getInputBuffers();
            this.decodeStartTimeMs.clear();
            this.hasDecodedFirstFrame = false;
            this.dequeuedSurfaceOutputBuffers.clear();
            this.droppedFrames = 0;
            Logging.d(TAG, "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    private void reset(int n, int n2) {
        if (this.mediaCodecThread == null || this.mediaCodec == null) {
            throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
        }
        Logging.d(TAG, "Java reset: " + n + " x " + n2);
        this.mediaCodec.flush();
        this.width = n;
        this.height = n2;
        if (this.textureListener != null) {
            this.textureListener.setSize(n, n2);
        }
        this.decodeStartTimeMs.clear();
        this.dequeuedSurfaceOutputBuffers.clear();
        this.hasDecodedFirstFrame = false;
        this.droppedFrames = 0;
    }

    @CalledByNativeUnchecked
    private void release() {
        Logging.d(TAG, "Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames);
        this.checkOnMediaCodecThread();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    MediaCodecVideoDecoder.this.mediaCodec.stop();
                    MediaCodecVideoDecoder.this.mediaCodec.release();
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", exception);
                }
                countDownLatch.countDown();
            }
        };
        new Thread(runnable).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        if (MediaCodecVideoDecoder.useSurface()) {
            this.surface.release();
            this.surface = null;
            this.textureListener.release();
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    @CalledByNativeUnchecked
    private int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    @CalledByNativeUnchecked
    private boolean queueInputBuffer(int n, int n2, long l, long l2, long l3) {
        this.checkOnMediaCodecThread();
        try {
            this.inputBuffers[n].position(0);
            this.inputBuffers[n].limit(n2);
            this.decodeStartTimeMs.add(new TimeStamps(SystemClock.elapsedRealtime(), l2, l3));
            this.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "decode failed", illegalStateException);
            return false;
        }
    }

    @Nullable
    @CalledByNativeUnchecked
    private DecodedOutputBuffer dequeueOutputBuffer(int n) {
        int n2;
        this.checkOnMediaCodecThread();
        if (this.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            n2 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(n));
            switch (n2) {
                case -3: {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    Logging.d(TAG, "Decoder output buffers changed: " + this.outputBuffers.length);
                    if (!this.hasDecodedFirstFrame) continue block5;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: {
                    int n3;
                    int n4;
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    Logging.d(TAG, "Decoder format changed: " + mediaFormat.toString());
                    if (mediaFormat.containsKey(FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(FORMAT_KEY_CROP_TOP)) {
                        n4 = 1 + mediaFormat.getInteger(FORMAT_KEY_CROP_RIGHT) - mediaFormat.getInteger(FORMAT_KEY_CROP_LEFT);
                        n3 = 1 + mediaFormat.getInteger(FORMAT_KEY_CROP_BOTTOM) - mediaFormat.getInteger(FORMAT_KEY_CROP_TOP);
                    } else {
                        n4 = mediaFormat.getInteger("width");
                        n3 = mediaFormat.getInteger("height");
                    }
                    if (this.hasDecodedFirstFrame && (n4 != this.width || n3 != this.height)) {
                        throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n4 + "*" + n3);
                    }
                    this.width = n4;
                    this.height = n3;
                    if (this.textureListener != null) {
                        this.textureListener.setSize(this.width, this.height);
                    }
                    if (!MediaCodecVideoDecoder.useSurface() && mediaFormat.containsKey("color-format")) {
                        this.colorFormat = mediaFormat.getInteger("color-format");
                        Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
                        if (!supportedColorList.contains(this.colorFormat)) {
                            throw new IllegalStateException("Non supported color format: " + this.colorFormat);
                        }
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_STRIDE)) {
                        this.stride = mediaFormat.getInteger(FORMAT_KEY_STRIDE);
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_SLICE_HEIGHT)) {
                        this.sliceHeight = mediaFormat.getInteger(FORMAT_KEY_SLICE_HEIGHT);
                    }
                    Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
                    this.stride = Math.max(this.width, this.stride);
                    this.sliceHeight = Math.max(this.height, this.sliceHeight);
                    continue block5;
                }
                case -1: {
                    return null;
                }
            }
            break;
        }
        this.hasDecodedFirstFrame = true;
        TimeStamps timeStamps = this.decodeStartTimeMs.remove();
        long l = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
        if (l > 200L) {
            Logging.e(TAG, "Very high decode time: " + l + "ms. Q size: " + this.decodeStartTimeMs.size() + ". Might be caused by resuming H264 decoding after a pause.");
            l = 200L;
        }
        return new DecodedOutputBuffer(n2, bufferInfo.offset, bufferInfo.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, l, SystemClock.elapsedRealtime());
    }

    @Nullable
    @CalledByNativeUnchecked
    private DecodedTextureBuffer dequeueTextureBuffer(int n) {
        this.checkOnMediaCodecThread();
        if (!MediaCodecVideoDecoder.useSurface()) {
            throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeueOutputBuffer(n);
        if (decodedOutputBuffer != null) {
            this.dequeuedSurfaceOutputBuffers.add(decodedOutputBuffer);
        }
        this.MaybeRenderDecodedTextureBuffer();
        DecodedTextureBuffer decodedTextureBuffer = this.textureListener.dequeueTextureBuffer(n);
        if (decodedTextureBuffer != null) {
            this.MaybeRenderDecodedTextureBuffer();
            return decodedTextureBuffer;
        }
        if (this.dequeuedSurfaceOutputBuffers.size() >= Math.min(3, this.outputBuffers.length) || n > 0 && !this.dequeuedSurfaceOutputBuffers.isEmpty()) {
            ++this.droppedFrames;
            DecodedOutputBuffer decodedOutputBuffer2 = this.dequeuedSurfaceOutputBuffers.remove();
            if (n > 0) {
                Logging.w(TAG, "Draining decoder. Dropping frame with TS: " + decodedOutputBuffer2.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            } else {
                Logging.w(TAG, "Too many output buffers " + this.dequeuedSurfaceOutputBuffers.size() + ". Dropping frame with TS: " + decodedOutputBuffer2.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            }
            this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer2.index, false);
            return new DecodedTextureBuffer(null, decodedOutputBuffer2.presentationTimeStampMs, decodedOutputBuffer2.timeStampMs, decodedOutputBuffer2.ntpTimeStampMs, decodedOutputBuffer2.decodeTimeMs, SystemClock.elapsedRealtime() - decodedOutputBuffer2.endDecodeTimeMs);
        }
        return null;
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (this.dequeuedSurfaceOutputBuffers.isEmpty() || this.textureListener.isWaitingForTexture()) {
            return;
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeuedSurfaceOutputBuffers.remove();
        this.textureListener.addBufferToRender(decodedOutputBuffer);
        this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
    }

    @CalledByNativeUnchecked
    private void returnDecodedOutputBuffer(int n) throws IllegalStateException, MediaCodec.CodecException {
        this.checkOnMediaCodecThread();
        if (MediaCodecVideoDecoder.useSurface()) {
            throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
        }
        this.mediaCodec.releaseOutputBuffer(n, false);
    }

    @CalledByNative
    ByteBuffer[] getInputBuffers() {
        return this.inputBuffers;
    }

    @CalledByNative
    ByteBuffer[] getOutputBuffers() {
        return this.outputBuffers;
    }

    @CalledByNative
    int getColorFormat() {
        return this.colorFormat;
    }

    @CalledByNative
    int getWidth() {
        return this.width;
    }

    @CalledByNative
    int getHeight() {
        return this.height;
    }

    @CalledByNative
    int getStride() {
        return this.stride;
    }

    @CalledByNative
    int getSliceHeight() {
        return this.sliceHeight;
    }

    private static native long nativeCreateDecoder(String var0, boolean var1);

    static {
        hwDecoderDisabledTypes = new HashSet<String>();
        supportedVp9HwCodecPrefixes = new String[]{supportedQcomH264HighProfileHwCodecPrefix, supportedExynosH264HighProfileHwCodecPrefix};
        supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    }

    private class TextureListener
    implements VideoSink {
        private final SurfaceTextureHelper surfaceTextureHelper;
        private final Object newFrameLock = new Object();
        @Nullable
        private DecodedOutputBuffer bufferToRender;
        @Nullable
        private DecodedTextureBuffer renderedBuffer;

        public TextureListener(SurfaceTextureHelper surfaceTextureHelper) {
            this.surfaceTextureHelper = surfaceTextureHelper;
            surfaceTextureHelper.startListening(this);
        }

        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            if (this.bufferToRender != null) {
                Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected addBufferToRender() called while waiting for a texture.");
                throw new IllegalStateException("Waiting for a texture.");
            }
            this.bufferToRender = decodedOutputBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWaitingForTexture() {
            Object object = this.newFrameLock;
            synchronized (object) {
                return this.bufferToRender != null;
            }
        }

        public void setSize(int n, int n2) {
            this.surfaceTextureHelper.setTextureSize(n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrame(VideoFrame videoFrame) {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected onFrame() called while already holding a texture.");
                    throw new IllegalStateException("Already holding a texture.");
                }
                VideoFrame.Buffer buffer = videoFrame.getBuffer();
                buffer.retain();
                this.renderedBuffer = new DecodedTextureBuffer(buffer, this.bufferToRender.presentationTimeStampMs, this.bufferToRender.timeStampMs, this.bufferToRender.ntpTimeStampMs, this.bufferToRender.decodeTimeMs, SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs);
                this.bufferToRender = null;
                this.newFrameLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public DecodedTextureBuffer dequeueTextureBuffer(int n) {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer == null && n > 0 && this.isWaitingForTexture()) {
                    try {
                        this.newFrameLock.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                DecodedTextureBuffer decodedTextureBuffer = this.renderedBuffer;
                this.renderedBuffer = null;
                return decodedTextureBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.surfaceTextureHelper.stopListening();
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    this.renderedBuffer.getVideoFrameBuffer().release();
                    this.renderedBuffer = null;
                }
            }
            this.surfaceTextureHelper.dispose();
        }
    }

    private static class DecodedTextureBuffer {
        private final VideoFrame.Buffer videoFrameBuffer;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;

        public DecodedTextureBuffer(VideoFrame.Buffer buffer, long l, long l2, long l3, long l4, long l5) {
            this.videoFrameBuffer = buffer;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.frameDelayMs = l5;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        VideoFrame.Buffer getVideoFrameBuffer() {
            return this.videoFrameBuffer;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getTimeStampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getFrameDelayMs() {
            return this.frameDelayMs;
        }
    }

    private static class DecodedOutputBuffer {
        private final int index;
        private final int offset;
        private final int size;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;

        public DecodedOutputBuffer(int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
            this.index = n;
            this.offset = n2;
            this.size = n3;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.endDecodeTimeMs = l5;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getIndex() {
            return this.index;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getOffset() {
            return this.offset;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getSize() {
            return this.size;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getTimestampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;

        public TimeStamps(long l, long l2, long l3) {
            this.decodeStartTimeMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string, int n) {
            this.codecName = string;
            this.colorFormat = n;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_UNKNOWN,
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;


        @CalledByNative(value="VideoCodecType")
        static VideoCodecType fromNativeIndex(int n) {
            return VideoCodecType.values()[n];
        }
    }

    static class HwDecoderFactory
    implements VideoDecoderFactory {
        private final VideoCodecInfo[] supportedHardwareCodecs = HwDecoderFactory.getSupportedHardwareCodecs();

        HwDecoderFactory() {
        }

        private static boolean isSameCodec(VideoCodecInfo videoCodecInfo, VideoCodecInfo videoCodecInfo2) {
            if (!videoCodecInfo.name.equalsIgnoreCase(videoCodecInfo2.name)) {
                return false;
            }
            return videoCodecInfo.name.equalsIgnoreCase("H264") ? H264Utils.isSameH264Profile(videoCodecInfo.params, videoCodecInfo2.params) : true;
        }

        private static boolean isCodecSupported(VideoCodecInfo[] videoCodecInfoArray, VideoCodecInfo videoCodecInfo) {
            for (VideoCodecInfo videoCodecInfo2 : videoCodecInfoArray) {
                if (!HwDecoderFactory.isSameCodec(videoCodecInfo2, videoCodecInfo)) continue;
                return true;
            }
            return false;
        }

        private static VideoCodecInfo[] getSupportedHardwareCodecs() {
            ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
            if (MediaCodecVideoDecoder.isVp8HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "VP8 HW Decoder supported.");
                arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isVp9HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "VP9 HW Decoder supported.");
                arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isH264HighProfileHwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 High Profile HW Decoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_HIGH_PROFILE_CODEC);
            }
            if (MediaCodecVideoDecoder.isH264HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 HW Decoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
            }
            return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
        }

        @Override
        public VideoCodecInfo[] getSupportedCodecs() {
            return this.supportedHardwareCodecs;
        }

        @Override
        @Nullable
        public VideoDecoder createDecoder(final VideoCodecInfo videoCodecInfo) {
            if (!HwDecoderFactory.isCodecSupported(this.supportedHardwareCodecs, videoCodecInfo)) {
                Logging.d(MediaCodecVideoDecoder.TAG, "No HW video decoder for codec " + videoCodecInfo.name);
                return null;
            }
            Logging.d(MediaCodecVideoDecoder.TAG, "Create HW video decoder for " + videoCodecInfo.name);
            return new WrappedNativeVideoDecoder(){

                @Override
                public long createNativeVideoDecoder() {
                    return MediaCodecVideoDecoder.nativeCreateDecoder(videoCodecInfo.name, MediaCodecVideoDecoder.useSurface());
                }
            };
        }
    }
}

