/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

/**
 * Error code should be same with native EMError's error code.
 * @author linan
 *
 */
public class EMAError extends EMABase {
	
    public final static int EM_NO_ERROR = 0;

	public final static int GENERAL_ERROR = 1;
	public final static int NETWORK_ERROR = 2;
	
	public final static int INVALID_APP_KEY = 100;
	public final static int INVALID_USER_NAME = 101;
	public final static int INVALID_PASSWORD = 102;
	public final static int INVALID_URL = 103;
	
	public final static int USER_ALREADY_LOGIN = 200;           
	public final static int USER_NOT_LOGIN = 201;
	public final static int USER_AUTHENTICATION_FAILED = 202;         
	public final static int USER_ALREADY_EXIST = 203;                 
	public final static int USER_NOT_FOUND = 204;                     
	public final static int USER_ILLEGAL_ARGUMENT = 205;
	public final static int USER_LOGIN_ANOTHER_DEVICE = 206;          
	public final static int USER_REMOVED = 207;
	public final static int USER_REG_FAILED = 208;
    public final static int USER_UPDATEINFO_FAILED = 209;
    public final static int USER_BINDDEVICETOKEN_FAILED = 210;
    public final static int USER_UNBIND_DEVICETOKEN_FAILED = 211;

	public final static int SERVER_NOT_REACHABLE = 300;
	public final static int SERVER_TIMEOUT = 301;
	public final static int SERVER_BUSY = 302;
	public final static int SERVER_UNKNOWN_ERROR = 303;
	public final static int SERVER_GET_DNSLIST_FAILED = 304;
	public final static int SERVER_SERVICE_RESTRICTED = 305;
	
	public final static int FILE_NOT_FOUND = 400;
	public final static int FILE_INVALID = 401;
	public final static int FILE_UPLOAD_FAILED = 402;                 
	public final static int FILE_DOWNLOAD_FAILED = 403;               
	
	public final static int MESSAGE_INVALID = 500;
	public final static int MESSAGE_INCLUDE_ILLEGAL_CONTENT = 501;     
	
	public final static int GROUP_INVALID_ID = 600;             
	public final static int GROUP_ALREADY_JOINED = 601;
	public final static int GROUP_NOT_JOINED = 602;
	public final static int GROUP_PERMISSION_DENIED = 603;            
	public final static int GROUP_MEMBERS_FULL = 604;
	public final static int GROUP_NOT_EXIST = 605;
	
	
	public final static int CHATROOM_INVALID_ID = 700;
	public final static int CHATROOM_ALREADY_JOINED = 701;
	public final static int CHATROOM_NOT_JOINED = 702;
	public final static int CHATROOM_PERMISSION_DENIED = 703;
	public final static int CHATROOM_MEMBERS_FULL = 704;
	public final static int CHATROOM_NOT_EXIST = 705;
	
	public final static int CALL_INVALID_ID = 800;
	public final static int CALL_BUSY = 801;
	public final static int CALL_REMOTE_OFFLINE = 802;
	public final static int CALL_CONNECTION_FAILED = 803;

	public final static int CALL_CONFERENCE_CREATE_FAILED = 804;
	public final static int CALL_CONFERENCE_CANCEL = 805;
	public final static int CALL_ALREADY_JOIN = 806;
	public final static int CALL_ALREADY_PUB = 807;
	public final static int CALL_ALREADY_SUB = 808;
	public final static int CALL_NO_SESSION = 809;
	public final static int CALL_NO_PUBLISH = 810;
	public final static int CALL_NO_SUBSCRIBE = 811;
	public final static int CALL_NO_STREAM = 812;
	public final static int CALL_TICKET_INVALID = 813;
	public final static int CALL_TICKET_EXPIRED = 814;
	public final static int CALL_SESSION_EXPIRED = 815;
	public final static int CALL_CONFERENCE_NO_EXIST = 816;
	public final static int CALL_INVALID_CAMERA_INDEX = 817;
	public final static int CALL_INVALID_PARAMS = 818;
	public final static int CALL_CONNECTION_TIMEOUT = 819;
	public final static int CALL_JOIN_TIMEOUT = 820;
	public final static int CALL_OTHER_DEVICE = 821;
	public final static int CALL_CONFERENCE_DISMISS = 822;

    public int errCode() {
    	return nativeErrCode();
    }
    
    public String errMsg() {
    	return nativeErrMsg();
    }
    
	public EMAError() {
		nativeInit();
	}
	
	native int nativeErrCode();
	
	native String nativeErrMsg();
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();
	native void nativeFinalize();
}
