/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.push.EMPushConfig;

/**
 * \~chinese
 * EMChatOptions 提供环信sdk聊天相关的设置。用户可以用来配置SDK的各种参数，选项 比如，发送消息加密，受到消息是否播放提示音
 * 
 * \~english
 * chat options for IM
 * enable/disable delivery ack, enable/disable server ack, enable/disable hyphenate friend management, etc..
 */
public class EMOptions {

	/**
	 * \~chinese
	 * 是否自动接受加好友邀请
	 *
	 * \~english
	 * whether accept friend invitation for user automatically
	 */
	private boolean acceptInvitationAlways = true;
	
	/**
	 * \~chinese
	 * 是否自动接受群组邀请
	 *
	 * \~english
	 * whether accept group invitation automatically
	 */
	private boolean autoAcceptGroupInvitation = true;
	
	/**
	 * \~chinese
	 * 是否对发送消息进行加密
	 *
	 * \~english
	 * whether encrypt the messages
	 */
	private boolean useEncryption = false;

	/**
	 * \~chinese
	 * 是否需要消息接受方已读确认，缺省true
	 *
	 * \~english
	 * whether receive message read by receiving user event
	 */
	private boolean requireReadAck = true;
	
	/**
	 * \~chinese
	 * 是否需要消息接收方送达确认，缺省false
	 *
	 * \~english
	 * whether receive message delivered to server event
	 */
	private boolean requireDeliveryAck = false;
	
	private boolean deleteMessagesAsExitGroup = true;
	
	private boolean isChatroomOwnerLeaveAllowed = true;
	
	private String appkey = "";
	
	private EMChatConfigPrivate config = null;
	
	private boolean enableAutoLogin = true;
	
	private String fcmNumber = null;
	private boolean useFCM = true;
	private EMChatConfigPrivate.EMMipushConfig mipushConfig = null;

	private boolean enableDNSConfig = true;
	
	private boolean sortMessageByServerTime = true;

	private boolean useHttps = false;
	private String dnsUrl = "";

	private String restServer;
	private String imServer;
	private int imPort;

	private boolean usingHttpsOnly = false;
	private boolean serverTransfer = true;
	private boolean isAutodownload = true;

	private EMPushConfig pushConfig;
	/**
	 * \~chinese
	 * 获取已读确认设置，缺省 true 如果设为true，会要求消息的接受方发送已读回执。 UI 可以通过注册 下面的intent receiver
	 * 接收此回执
	 * @return 是否要求消息的接收方发送已读回执
	 * 
	 * \~english
	 * get whether read ack is required for the message receiver.
	 * @return whether read ack is required
	 */
	public boolean getRequireAck() {
		
		if(config == null){
			return requireReadAck;
		}
	
		return  config.getRequireReadAck();
	}

	/**
	 * \~chinese
	 * 设置是否需要接受方已读确认
	 * @param requireAck 是否需要已读回执
	 * 
	 * \~english
	 * enable/disable the read ack of receipt
	 * @param requireAck
	 */
	public void setRequireAck(boolean requireAck) {
		this.requireReadAck = requireAck;

		if (config == null) {
			return;
		}
		config.setRequireReadAck(requireAck);
	}
	
	/**
	 * \~chinese
	 * 获取送达确认设置，缺省 false, 如果设为true，会要求消息的接受方发送送达回执。 UI 可以通过注册 下面的intent receiver
	 * 接收此回执
	 * 
	 * <pre>
	 * IntentFilter readAckIntentFilter = new IntentFilter(EMChatManager.getInstance().getAckMessageBroadcastAction());
	 * </pre>
	 * 
	 * @return 是否需要送达回执
	 * 
	 * \~english
	 * get if delivery ack is required
	 * @return if delivery ack is required
	 */
	public boolean getRequireDeliveryAck() {
		if (config == null) {
			return requireDeliveryAck;
		}
		return config.getRequireDeliveryAck();
	}

	/**
	 * \~chinese
	 * 设置是否需要接受方送达确认,默认false
	 * @param requireDeliveryAck 是否需要送达确认
	 * 
	 * \~english
	 * enable/disable deliver ack
	 * @param requireDeliveryAck
	 */
	public void setRequireDeliveryAck(boolean requireDeliveryAck) {
		this.requireDeliveryAck = requireDeliveryAck;
		
		if (config == null) {
			return;
		}
		config.setRequireDeliveryAck(requireDeliveryAck);
	}

	/**
	 * \~chinese
	 * 获取是否自动接受加好友邀请。缺省true
	 * 
	 * @return
	 * 
	 * \~english
	 * get if accept the other's invitation to be your friend automatically
	 * @return if accept invitation automatically
	 */
	public boolean getAcceptInvitationAlways() {
		if (config == null) {
			return acceptInvitationAlways;
		}
		return config.getAutoAccept();
	}

	/**
	 * \~chinese
	 * 设置是否自动接受加好友邀请。缺省true
	 * @param value
	 * 
	 * \~english
	 * enable/disable accept the friend invitation automatically
	 * @param value
	 */
	public void setAcceptInvitationAlways(boolean value) {
		if (config == null) {
			acceptInvitationAlways = value;
			return;
		}
		config.setAutoAccept(value);
	}

	/**
	 * \~chinese
     * 设置退出(主动和被动退出)群组时是否删除聊天消息
     * @param delete true为删除群组相关消息，默认为true
     * 
     * \~english
	 * enable/disable deleting the group message after existing the group
     * @param delete true--delete the messages, default is true
     */
    public void setDeleteMessagesAsExitGroup(boolean delete){
		if (config == null) {
			deleteMessagesAsExitGroup = delete;
			return;
		}
		
		config.setDeleteMessageAsExitGroup(delete);
    }
    
    /**
	 * \~chinese
     * 获取退出(主动和被动退出)群组时是否删除聊天消息
     * @return  true为删除群组相关消息
     * 
     * \~english
	 * get if deleting the group message after existing the group
     * @return true--delete the messages
     */
    public boolean isDeleteMessagesAsExitGroup() {
		if (config == null) {
			return deleteMessagesAsExitGroup;
		}
		
		return config.getDeleteMessageAsExitGroup();

    }
    
    /**
     * \~chinese
     * 设置是否自动接受加群邀请
     * @param value
     * 
     * \~english
     * set if accept group invitation automatically
     * @param value
     */
    public void setAutoAcceptGroupInvitation(boolean value) {
        if (config == null) {
            autoAcceptGroupInvitation = value;
            return;
        }
        config.setAutoAcceptGroupInvitation(value);
    }
    
    /**
     * \~chinese
     * 获取是否自动接受加群邀请
     * @return 
     * 
     * \~english
     * get if accept group invitation automatically
     * @return
     */
    public boolean isAutoAcceptGroupInvitation() {
        if (config == null) {
            return autoAcceptGroupInvitation;
        }
        return config.isAutoAcceptGroupInvitation();
    }

	/**
	 * \~chinese
	 * 设置是否允许聊天室owner离开并删除会话记录，意味着owner再不会受到任何消息
	 * @param allowed 是否允许聊天室owner离开
	 * 
	 * \~english
	 * enable/disable allowing chat room owner to leave the chat room
	 * @param allowed if allow the owner of chat room leave
	 */
    public void allowChatroomOwnerLeave(boolean allowed){
		if (config == null) {
			this.isChatroomOwnerLeaveAllowed = allowed;
			return;
		}
		
		config.setIsChatroomOwnerLeaveAllowed(allowed);
	}
	
	/**
	 * \~chinese
	 * 是否允许聊天室owner离开
	 * @return true 离开并不保留会话记录，否者为 false
	 * 
	 * \~english
	 * if allow owner of chat room leave
	 * @return true--do not keep conversation when leave
	 */
	public boolean isChatroomOwnerLeaveAllowed(){
		if (config == null) {
			return isChatroomOwnerLeaveAllowed;
		}
		return config.getIsChatroomOwnerLeaveAllowed();
	}
	
	 
	/**
	 * \~chinese
	 * 是否按照server收到时间进行排序 默认是false
	 * @return
	 * 
	 * \~english
	 * whether sort messages by server received time, default value is false
	 */
    public boolean isSortMessageByServerTime() {
        if (config == null) {
            return sortMessageByServerTime;
        }
        return config.getSortMessageByServerTime();
    }
    
    public void setSortMessageByServerTime(boolean sortByServerTime) {
        if (config == null) {
            this.sortMessageByServerTime = sortByServerTime;
            return;
        }
        
        config.setSortMessageByServerTime(sortByServerTime);
    }
	
	/**
	 * \~chinese
	 * 设置appkey
	 * @param appkey
	 * 
	 * \~english
	 * set app key
	 * @param appkey
	 */
	void updatePath(String appkey){
		if(config != null) {
            config.updatePath(appkey);
		}
	}

	/**
	 * \~chinese
	 * 设置appkey
	 * @param appkey
	 *
	 * \~english
	 * set app key
	 * @param appkey
	 */
	public void setAppKey(String appkey) {
		this.appkey = appkey;
		updatePath(appkey);
	}
	
	/**
	 * \~chinese
	 * 获取appkey
	 *
	 * \~english
	 * get app key
	 */
	public String getAppKey(){
		if(config == null){
			return appkey;
		}
		
		return config.getAppKey();
	}

	/**
	 * \~chinese
	 * 设置im server地址
	 * @param imServer
	 *
	 * \~english
	 * set the custom im server
	 * @param imServer
     */
	public void setIMServer(String imServer){
		if(imServer == null){
			return;
		}

		this.imServer = imServer;
		if(config == null){
			return;
		}
		config.setChatServer(imServer);
	}

	/**
	 * \~chinese
	 * 设置im server 端口号，默认443
	 * @param imPort
	 *
	 * \~english
	 * set the custom im server port, default is 443
	 * @param imPort
     */
	public void setImPort(int imPort){
		this.imPort = imPort;
		if(config == null){
			return;
		}
		config.setChatPort(imPort);
	}

	/**
	 * \~chinese
	 * 设置rest server地址
	 * @param restServer
	 *
	 * \~english
	 * set the custom rest server
	 * @param restServer
	 */
	public void setRestServer(String restServer){
		if(restServer == null)
			return;

		this.restServer = restServer;
		if(config == null){
			return;
		}
		config.setRestServer(restServer);
	}

	/**
	 * \~chinese
	 * 获取设置的rest server
	 * @return
	 *
	 * \~english
	 * get the rest server
	 * @return
     */
	public String getRestServer(){
		return restServer;
	}

	/**
	 * \~chinese
	 * 获取设置的im server
	 * @return
	 *
	 * \~english
	 * get the im server
	 * @return
	 */
	public String getImServer(){
		return imServer;
	}
	/**
	 * \~chinese
	 * 获取设置的im server端口号
	 * @return
	 *
	 * \~english
	 * get the im server port
	 * @return
	 */
	public int getImPort(){
		return imPort;
	}

	/**
	 * \~chinese
	 * 设置自动登录
	 * @param autoLogin
	 * 
	 * \~english
	 * set login automatically
	 * @param autoLogin
	 */
	public void setAutoLogin(boolean autoLogin){
		enableAutoLogin = autoLogin;
	}
	
	/**
	 * \~chinese
	 * 获取是否自动登录
	 * @return 
	 * 
	 * \~english
	 * get login automatically
	 * @return 
	 */
	public boolean getAutoLogin(){
		return enableAutoLogin;
	}

	/**
	 * \~chinese
	 * 获取FCM（GCM升级版->FCM）推送id
	 * <p>
	 * \~english
	 * get FCM sender id
	 *
	 * @Deprecated Use {@link EMPushConfig#getFcmSenderId()} for instead.
	 */
	@Deprecated
	public String getFCMNumber() {
		return fcmNumber;
	}

	/**
	 * \~chinese
	 * 设置FCM（GCM升级版->FCM）推送id
	 *
	 * @param number FCM sender id
	 *               <p>
	 *               \~english
	 *               set FCM sender id
	 * @param number -- FCM sender id
	 *
	 * @Deprecated Use {@link EMPushConfig.Builder#enableFCM(String)} for instead.
	 */
	@Deprecated
	public void setFCMNumber(String number) {
		fcmNumber = number;
	}

	/**
	 * \~chinese
	 * 是否使用谷歌FCM推送
	 * <p>
	 * \~english
	 * Whether to use Google FCM push
	 */
	public boolean isUseFCM() {
		return useFCM;
	}

	/**
	 * \~chinese
	 * 设置是否开启谷歌FCM推送
	 *
	 * @param useFCM 谷歌FCM推送开关
	 *               <p>
	 *               \~english
	 *               Enable or disable Google FCM push
	 * @param useFCM -- Google FCM push switch
	 */
	public void setUseFCM(boolean useFCM) {
		this.useFCM = useFCM;
	}
	
	/**
	 * \~chinese
     * 设置用于小米推送的appid和appkey
     * @param mipushAppid
     * @param mipushAppkey
     * 
     * \~english
     * set the appid and appkey for Xiaomi Push
     * @param mipushAppid
     * @param mipushAppkey
	 *
	 * @Deprecated Use {@link EMPushConfig.Builder#enableMiPush(String, String)} for instead.
     */
	@Deprecated
    public void setMipushConfig(String mipushAppid, String mipushAppkey){
		mipushConfig = new EMChatConfigPrivate.EMMipushConfig(mipushAppid, mipushAppkey);
    }
    
    /**
	 * \~chinese
     * 获取用于小米推送的appid和appkey
     *
     * \~english
     * get the appid and appkey for Xiaomi Push
	 *
	 * @Deprecated Use {@link EMPushConfig#getMiAppId()} and {@link EMPushConfig#getMiAppKey()} for instead.
     */
    @Deprecated
	public EMChatConfigPrivate.EMMipushConfig getMipushConfig() {
		return mipushConfig;
	}
    
	void setConfig(EMChatConfigPrivate config){
		this.config = config;
	}
	
	public void enableDNSConfig(boolean enable) {
		enableDNSConfig = enable;
        if (config == null) {
            return;
        }
	    config.enableDnsConfig(enable);
	}
	
	public boolean getEnableDNSConfig() {
	    return enableDNSConfig;
	}

	/**
	 * @deprecated
	 * \~chinese
	 * 允许使用https，默认值是true
	 * @param _useHttps
	 *
	 * \~english
	 * allow use https for rest operation, default value is true
	 */
    @Deprecated
	public void setUseHttps(boolean _useHttps) {
		useHttps = _useHttps;
		if (config == null) {
			return;
		}
		config.setUseHttps(_useHttps);
	}

	/**
	 * \~chinese
	 * 只使用https进行REST操作，默认值是false。
	 * @param _usingHttpsOnly
	 *
	 * \~english
	 * Only use https for rest operation, default value is false
	 *
	 * @param _usingHttpsOnly
	 */
	public void setUsingHttpsOnly(boolean _usingHttpsOnly) {
        usingHttpsOnly = _usingHttpsOnly;
		if (config == null) {
			return;
		}
		config.setUsingHttpsOnly(_usingHttpsOnly);
	}

	/**
	 * \~chinese
	 * 只使用https进行REST操作，默认值是false。
	 *
	 * @return

	 * \~english
	 * Only use https for rest operation, default value is false
	 *
	 * @return
	 */
	public boolean getUsingHttpsOnly() {
		if (config != null) {
			return config.getUsingHttpsOnly();
		}
		return usingHttpsOnly;
	}
	/**
	 * \~chinese
	 * 是否自动将消息附件上传到环信服务器，默认为True是使用环信服务器上传下载。
	 * @param transfer
	 *
	 * \~english
	 * Whether the message attachment is automatically uploaded to the Hyphenate server,
	 * default value is true, the default way to upload and download by Easemob.
	 *
	 * @param transfer
	 */
	public void setAutoTransferMessageAttachments(boolean transfer) {
		if (config == null) {
			serverTransfer = transfer;
			return;
		}
		config.setAutoTransferMessageAttachments(transfer);
	}
	/**
	 * \~chinese
	 * 获取是否使用环信服务器进行上传下载，默认值是true。
	 *
	 * \~english
	 * Use Easemob sever to upload and download, default value is true.
	 *
	 */

	public boolean getAutoTransferMessageAttachments() {
		if (config == null) {
			return serverTransfer;
		}
		return config.getAutoTransferMessageAttachments();
	}
	/**
	 * \~chinese
	 * 是否自动下载缩略图，默认是true为自动下载。
	 * @param autodownload
	 *
	 * \~english
	 * Set Whether auto download thumbnail, default value is true.
	 *
	 * @param autodownload
	 */
	public void setAutoDownloadThumbnail(boolean autodownload) {
		if (config == null) {
			isAutodownload = autodownload;
			return;
		}
		config.setAutodownloadThumbnail(autodownload);
	}
	/**
	 * \~chinese
	 * 是否自动下载缩略图，默认为true。
	 *
	 * \~english
	 * is Auto download thumbnail, default value is true.
	 *
	 */
	public boolean getAutodownloadThumbnail() {
		if (config == null) {
			return isAutodownload;
		}
		return config.getAutodownloadThumbnail();
	}


	public String getVersion() {
		return config.getVersion();
	}

	public String getAccessToken() {
		return config.getAccessToken();
	}

	public String getAccessToken(boolean b) {
		return config.getAccessToken(b);
	}

	public void setDnsUrl(String dnsUrl) {
		this.dnsUrl = dnsUrl;
		if (config == null) {
			return;
		}
		config.setDnsUrl(dnsUrl);
	}

	public String getDnsUrl() {
		if (config != null) {
			return config.getDnsUrl();
		}
		return dnsUrl;
	}

	public EMPushConfig getPushConfig() {
		return pushConfig;
	}

	public void setPushConfig(EMPushConfig pushConfig) {
		this.pushConfig = pushConfig;
	}
}
