/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.content.Context;
import android.util.Log;
import com.superrtc.call.NetworkMonitorAutoDetect;
import com.superrtc.mediamanager.XClientBridger;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class XReachability {
    private static final String TAG = "XReachability";
    public static final int kShouldPrintReachabilityFlags = 0;
    private NetworkMonitorAutoDetect.ConnectionType currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;
    private NetworkMonitorAutoDetect autoDetector;
    private final Context applicationContext;
    private final ArrayList<NetworkObserver> networkObservers = new ArrayList();
    private static XReachability instance;
    private static XClientBridger.Logcallbackfunc logcallback;
    public static final String kXReachabilityChangedNotification = "kNetworkReachabilityChangedNotification";
    public boolean connectionRequired;

    public static XReachability init(Context context) {
        if (!XReachability.isInitialized()) {
            instance = new XReachability(context);
        }
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static XReachability getInstance() {
        return instance;
    }

    public XReachability(Context context) {
        this.applicationContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
    }

    public void addNetworkObserver(NetworkObserver networkObserver) {
        this.networkObservers.add(networkObserver);
    }

    public void startMonitoring() {
        this.setAutoDetectConnectivityStateInternal(true);
    }

    public void stopMonitoring() {
        this.setAutoDetectConnectivityStateInternal(false);
    }

    private void setAutoDetectConnectivityStateInternal(boolean bl) {
        if (!bl) {
            this.destroyAutoDetector();
            return;
        }
        if (this.autoDetector == null) {
            this.autoDetector = new NetworkMonitorAutoDetect(new NetworkMonitorAutoDetect.Observer(){

                @Override
                public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType connectionType) {
                    XReachability.this.updateCurrentConnectionType(connectionType);
                }

                @Override
                public void onNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
                    XReachability.this.notifyObserversOfNetworkConnect(networkInformation);
                }

                @Override
                public void onNetworkDisconnect(int n) {
                    XReachability.this.notifyObserversOfNetworkDisconnect(n);
                }
            }, this.applicationContext);
            NetworkMonitorAutoDetect.NetworkState networkState = this.autoDetector.getCurrentNetworkState();
            this.updateCurrentConnectionType(NetworkMonitorAutoDetect.getConnectionType(networkState));
            this.updateActiveNetworkList();
        }
    }

    private void destroyAutoDetector() {
        if (this.autoDetector != null) {
            this.autoDetector.destroy();
            this.autoDetector = null;
        }
    }

    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        this.currentConnectionType = connectionType;
        this.notifyObserversOfConnectionTypeChange(connectionType);
    }

    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        for (NetworkObserver networkObserver : this.networkObservers) {
            networkObserver.onConnectionTypeChanged(connectionType);
        }
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
        for (NetworkObserver networkObserver : this.networkObservers) {
        }
    }

    private void notifyObserversOfNetworkDisconnect(int n) {
        for (NetworkObserver networkObserver : this.networkObservers) {
        }
    }

    private void updateActiveNetworkList() {
        List<NetworkMonitorAutoDetect.NetworkInformation> list = this.autoDetector.getActiveNetworkList();
        if (list == null || list.size() == 0) {
            return;
        }
        NetworkMonitorAutoDetect.NetworkInformation[] networkInformationArray = new NetworkMonitorAutoDetect.NetworkInformation[list.size()];
        networkInformationArray = list.toArray(networkInformationArray);
        for (NetworkObserver networkObserver : this.networkObservers) {
        }
    }

    public static boolean isOnline() {
        NetworkMonitorAutoDetect.ConnectionType connectionType = XReachability.getInstance().getCurrentConnectionType();
        return connectionType != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN && connectionType != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE;
    }

    private NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    public static void PrintReachabilityFlags(NetworkMonitorAutoDetect.ConnectionType connectionType, String string) {
    }

    public static void reachabilityWithHostName(String string) {
    }

    public static void reachabilityWithAddress(Socket socket) {
    }

    public static void reachabilityForInternetConnection() {
    }

    public boolean startNotifier() {
        return false;
    }

    public void stopNotifier() {
    }

    public XNetworkStatus currentReachabilityStatus(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        switch (connectionType) {
            case CONNECTION_WIFI: 
            case CONNECTION_BLUETOOTH: {
                return XNetworkStatus.XReachableViaWiFi;
            }
            case CONNECTION_ETHERNET: 
            case CONNECTION_4G: 
            case CONNECTION_3G: 
            case CONNECTION_2G: {
                return XNetworkStatus.XReachableViaWWAN;
            }
            case CONNECTION_NONE: {
                return XNetworkStatus.XNotReachable;
            }
        }
        return XNetworkStatus.XNotReachable;
    }

    static {
        logcallback = new XClientBridger.Logcallbackfunc(){

            @Override
            public void onLog(int n, String string) {
                Log.i((String)XReachability.TAG, (String)string);
            }
        };
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);
    }

    public static enum XNetworkStatus {
        XNotReachable,
        XReachableViaWiFi,
        XReachableViaWWAN;

    }
}

