/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.os.Handler;
import android.os.SystemClock;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    public static void executeUninterruptibly(BlockingOperation blockingOperation) {
        boolean bl = false;
        while (true) {
            try {
                blockingOperation.run();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean joinUninterruptibly(Thread thread, long l) {
        long l2 = SystemClock.elapsedRealtime();
        long l3 = l;
        boolean bl = false;
        while (l3 > 0L) {
            try {
                thread.join(l3);
                break;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                long l4 = SystemClock.elapsedRealtime() - l2;
                l3 = l - l4;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return !thread.isAlive();
    }

    public static void joinUninterruptibly(final Thread thread) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                thread.join();
            }
        });
    }

    public static void awaitUninterruptibly(final CountDownLatch countDownLatch) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                countDownLatch.await();
            }
        });
    }

    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, long l) {
        long l2 = SystemClock.elapsedRealtime();
        long l3 = l;
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            try {
                bl2 = countDownLatch.await(l3, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                long l4;
                bl = true;
                if ((l3 = l - (l4 = SystemClock.elapsedRealtime() - l2)) > 0L) continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return bl2;
    }

    public static <V> V invokeUninterruptibly(Handler handler, final Callable<V> callable) {
        class Result {
            public V value;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        handler.post(new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    result.value = callable.call();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Callable threw exception: " + exception);
                }
                countDownLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        return result.value;
    }

    public static void invokeUninterruptibly(Handler handler, final Runnable runnable) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        handler.post(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                countDownLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
    }

    public static interface BlockingOperation {
        public void run() throws InterruptedException;
    }

    public static class ThreadChecker {
        private Thread thread = Thread.currentThread();

        public void checkIsOnValidThread() {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() != this.thread) {
                throw new IllegalStateException("Wrong thread");
            }
        }

        public void detachThread() {
            this.thread = null;
        }
    }
}

