/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.graphics.Point;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.superrtc.call.VideoRenderer;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class RendererCommon {
    private static float BALANCED_VISIBLE_FRACTION = 0.5625f;

    public static final float[] identityMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static final float[] verticalFlipMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    public static final float[] horizontalFlipMatrix() {
        return new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] rotateTextureMatrix(float[] fArray, float f2) {
        float[] fArray2 = new float[16];
        Matrix.setRotateM((float[])fArray2, (int)0, (float)f2, (float)0.0f, (float)0.0f, (float)1.0f);
        RendererCommon.adjustOrigin(fArray2);
        return RendererCommon.multiplyMatrices(fArray, fArray2);
    }

    public static float[] multiplyMatrices(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[16];
        Matrix.multiplyMM((float[])fArray3, (int)0, (float[])fArray, (int)0, (float[])fArray2, (int)0);
        return fArray3;
    }

    public static float[] getLayoutMatrix(boolean bl, float f2, float f3) {
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (f3 > f2) {
            f5 = f2 / f3;
        } else {
            f4 = f3 / f2;
        }
        if (bl) {
            f4 *= -1.0f;
        }
        float[] fArray = new float[16];
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)f4, (float)f5, (float)1.0f);
        RendererCommon.adjustOrigin(fArray);
        return fArray;
    }

    public static Point getDisplaySize(ScalingType scalingType, float f2, int n, int n2) {
        return RendererCommon.getDisplaySize(RendererCommon.convertScalingTypeToVisibleFraction(scalingType), f2, n, n2);
    }

    private static void adjustOrigin(float[] fArray) {
        fArray[12] = fArray[12] - 0.5f * (fArray[0] + fArray[4]);
        fArray[13] = fArray[13] - 0.5f * (fArray[1] + fArray[5]);
        fArray[12] = fArray[12] + 0.5f;
        fArray[13] = fArray[13] + 0.5f;
    }

    private static float convertScalingTypeToVisibleFraction(ScalingType scalingType) {
        switch (scalingType) {
            case SCALE_ASPECT_FIT: {
                return 1.0f;
            }
            case SCALE_ASPECT_FILL: {
                return 0.0f;
            }
            case SCALE_ASPECT_BALANCED: {
                return BALANCED_VISIBLE_FRACTION;
            }
        }
        throw new IllegalArgumentException();
    }

    private static Point getDisplaySize(float f2, float f3, int n, int n2) {
        if (f2 == 0.0f || f3 == 0.0f) {
            return new Point(n, n2);
        }
        int n3 = Math.min(n, Math.round((float)n2 / f2 * f3));
        int n4 = Math.min(n2, Math.round((float)n / f2 / f3));
        return new Point(n3, n4);
    }

    public static enum ScalingType {
        SCALE_ASPECT_FIT,
        SCALE_ASPECT_FILL,
        SCALE_ASPECT_BALANCED;

    }

    public static class YuvUploader {
        private ByteBuffer copyBuffer;

        public void uploadYuvData(int[] nArray, int n, int n2, int[] nArray2, ByteBuffer[] byteBufferArray) {
            int n3;
            int[] nArray3 = new int[]{n, n / 2, n / 2};
            int[] nArray4 = new int[]{n2, n2 / 2, n2 / 2};
            int n4 = 0;
            for (n3 = 0; n3 < 3; ++n3) {
                if (nArray2[n3] <= nArray3[n3]) continue;
                n4 = Math.max(n4, nArray3[n3] * nArray4[n3]);
            }
            if (n4 > 0 && (this.copyBuffer == null || this.copyBuffer.capacity() < n4)) {
                this.copyBuffer = ByteBuffer.allocateDirect(n4);
            }
            for (n3 = 0; n3 < 3; ++n3) {
                ByteBuffer byteBuffer;
                GLES20.glActiveTexture((int)(33984 + n3));
                GLES20.glBindTexture((int)3553, (int)nArray[n3]);
                if (nArray2[n3] == nArray3[n3]) {
                    byteBuffer = byteBufferArray[n3];
                } else {
                    VideoRenderer.nativeCopyPlane(byteBufferArray[n3], nArray3[n3], nArray4[n3], nArray2[n3], this.copyBuffer, nArray3[n3]);
                    byteBuffer = this.copyBuffer;
                }
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)nArray3[n3], (int)nArray4[n3], (int)0, (int)6409, (int)5121, (Buffer)byteBuffer);
            }
        }
    }

    public static interface GlDrawer {
        public void drawOes(int var1, float[] var2, int var3, int var4, int var5, int var6);

        public void drawRgb(int var1, float[] var2, int var3, int var4, int var5, int var6);

        public void drawYuv(int[] var1, float[] var2, int var3, int var4, int var5, int var6);

        public void release();
    }

    public static interface RendererEvents {
        public void onFirstFrameRendered();

        public void onFrameResolutionChanged(int var1, int var2, int var3);
    }
}

