/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import java.nio.ByteBuffer;

public class DataChannel {
    private final long nativeDataChannel;
    private long nativeObserver;

    public DataChannel(long l) {
        this.nativeDataChannel = l;
    }

    public void registerObserver(Observer observer) {
        if (this.nativeObserver != 0L) {
            this.unregisterObserverNative(this.nativeObserver);
        }
        this.nativeObserver = this.registerObserverNative(observer);
    }

    private native long registerObserverNative(Observer var1);

    public void unregisterObserver() {
        this.unregisterObserverNative(this.nativeObserver);
    }

    private native void unregisterObserverNative(long var1);

    public native String label();

    public native State state();

    public native long bufferedAmount();

    public native void close();

    public boolean send(Buffer buffer) {
        byte[] byArray = new byte[buffer.data.remaining()];
        buffer.data.get(byArray);
        return this.sendNative(byArray, buffer.binary);
    }

    private native boolean sendNative(byte[] var1, boolean var2);

    public native void dispose();

    public static enum State {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }

    public static interface Observer {
        public void onBufferedAmountChange(long var1);

        public void onStateChange();

        public void onMessage(Buffer var1);
    }

    public static class Buffer {
        public final ByteBuffer data;
        public final boolean binary;

        public Buffer(ByteBuffer byteBuffer, boolean bl) {
            this.data = byteBuffer;
            this.binary = bl;
        }
    }

    public static class Init {
        public boolean ordered = true;
        public int maxRetransmitTimeMs = -1;
        public int maxRetransmits = -1;
        public String protocol = "";
        public boolean negotiated = false;
        public int id = -1;

        public Init() {
        }

        private Init(boolean bl, int n, int n2, String string, boolean bl2, int n3) {
            this.ordered = bl;
            this.maxRetransmitTimeMs = n;
            this.maxRetransmits = n2;
            this.protocol = string;
            this.negotiated = bl2;
            this.id = n3;
        }
    }
}

