/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.annotation.SuppressLint;
import com.hyphenate.util.TimeInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    private static final long INTERVAL_IN_MILLISECONDS = 30000L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getTimestampString(Date date) {
        String string = null;
        String string2 = Locale.getDefault().getLanguage();
        boolean bl = string2.startsWith("zh");
        long l = date.getTime();
        if (DateUtils.isSameDay(l)) {
            string = bl ? "aa hh:mm" : "hh:mm aa";
        } else if (DateUtils.isYesterday(l)) {
            if (!bl) return "Yesterday " + new SimpleDateFormat("hh:mm aa", Locale.ENGLISH).format(date);
            string = "\u6628\u5929aa hh:mm";
        } else {
            string = bl ? "M\u6708d\u65e5aa hh:mm" : "MMM dd hh:mm aa";
        }
        if (!bl) return new SimpleDateFormat(string, Locale.ENGLISH).format(date);
        return new SimpleDateFormat(string, Locale.CHINESE).format(date);
    }

    public static boolean isCloseEnough(long l, long l2) {
        long l3 = l - l2;
        if (l3 < 0L) {
            l3 = -l3;
        }
        return l3 < 30000L;
    }

    private static boolean isSameDay(long l) {
        TimeInfo timeInfo = DateUtils.getTodayStartAndEndTime();
        return l > timeInfo.getStartTime() && l < timeInfo.getEndTime();
    }

    private static boolean isYesterday(long l) {
        TimeInfo timeInfo = DateUtils.getYesterdayStartAndEndTime();
        return l > timeInfo.getStartTime() && l < timeInfo.getEndTime();
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static Date StringToDate(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return date;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String toTime(int n) {
        int n2 = (n /= 1000) / 60;
        int n3 = 0;
        if (n2 >= 60) {
            n3 = n2 / 60;
            n2 %= 60;
        }
        int n4 = n % 60;
        return String.format("%02d:%02d", n2, n4);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String toTimeBySecond(int n) {
        int n2 = n / 60;
        int n3 = 0;
        if (n2 >= 60) {
            n3 = n2 / 60;
            n2 %= 60;
        }
        int n4 = n % 60;
        return String.format("%02d:%02d", n2, n4);
    }

    public static TimeInfo getYesterdayStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l = date.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(5, -1);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        Date date2 = calendar2.getTime();
        long l2 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static TimeInfo getTodayStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l = date.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        Date date2 = calendar2.getTime();
        long l2 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static TimeInfo getBeforeYesterdayStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l = date.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(5, -2);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        Date date2 = calendar2.getTime();
        long l2 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static TimeInfo getCurrentMonthStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l = date.getTime();
        Calendar calendar2 = Calendar.getInstance();
        Date date2 = calendar2.getTime();
        long l2 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static TimeInfo getLastMonthStartAndEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        long l = date.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, -1);
        calendar2.set(5, 1);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        calendar2.roll(5, -1);
        Date date2 = calendar2.getTime();
        long l2 = date2.getTime();
        TimeInfo timeInfo = new TimeInfo();
        timeInfo.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static String getTimestampStr() {
        return Long.toString(System.currentTimeMillis());
    }
}

