/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Environment;

import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;

import java.io.File;


@SuppressWarnings("ALL")
public class EMAdvanceDebugManager {
    private static final String TAG = "EMAdvanceDebugManager";
    private static String IPC_ACTION = null;
    
    private static EMAdvanceDebugManager instance = null;
    private BroadcastReceiver cmdBroadCast = null;
    private Context context;
    private EMChatConfigPrivate config = null;
    
    private EMAdvanceDebugManager(){
        context = EMClient.getInstance().getContext();
        IPC_ACTION = context.getPackageName() + ".debug.ipc.cmd";
    }
    
    public synchronized static EMAdvanceDebugManager getInstance(){
        if(instance == null){
            instance = new EMAdvanceDebugManager();
        }
        return instance;
    }
    
    private void registerReceiver(){
    
    	if(cmdBroadCast == null){
    		cmdBroadCast = new BroadcastReceiver() {
                
                @Override
                public void onReceive(Context context, Intent intent) {
                    if(intent.getAction().equals(IPC_ACTION)){
                       String cmdAction = intent.getStringExtra("action");
                       Type type = null;
                       try {
                           type = Type.valueOf(cmdAction);
                       } catch (Exception e) {
                       }
                       if(type == null){
                           EMLog.e(TAG, "unknow cmd action");
                           return;
                       }
                       EMMessage message = EMMessage.createReceiveMessage(EMMessage.Type.CMD);
                       if(intent.getStringExtra("appkey") != null)
                           message.setAttribute("appkey", intent.getStringExtra("appkey"));
                       if(intent.getStringExtra("im_server") != null)
                           message.setAttribute("im_server", intent.getStringExtra("im_server"));
                       if(intent.getStringExtra("rest_server") != null)
                           message.setAttribute("rest_server", intent.getStringExtra("rest_server"));
                       
                       if(intent.getBooleanExtra("enable_dns", false)){
                    	   message.setAttribute("enable_dns", true);
                       }
                       
                       handleDebugMessage(message, type);
                    }
                }
            };
            
            context.registerReceiver(cmdBroadCast, new IntentFilter(IPC_ACTION));
    	}
    }
    
    /**
     * handle cmd debug message
     * @param message
     * @param type 
     */
    public void handleDebugMessage(EMMessage message, Type type){
        switch (type) {
        case em_retrieve_dns:
            new Thread(new Runnable() {
                public void run() {
                    EMLog.d(TAG, "retrieve_dns");
                    config.retrieveDNSConfig();
                }
            }).start();
            break;
        case em_upload_dns:
            EMLog.d(TAG, "upload dns");
            // jni TODO:
//            EMDNSConfig dnsConfig = EMDNSManager.getInstance().getDnsConfig();
            break;
        case em_start_debug:
            setDebugMode(true);
            EMClient.getInstance().setDebugMode(true);
            EMLog.d(TAG, "debugmode set to true");
            break;
        case em_stop_debug:
            setDebugMode(false);
            EMLog.d(TAG, "debugmode set to false");
            EMClient.getInstance().setDebugMode(false);
            break;
        case em_upload_log:
        	config.uploadLog(new EMCallBack() {
                
                @Override
                public void onSuccess() {
                    EMLog.d(TAG, "upload log success");
                }
                @Override
                public void onError(int code, String message) {
                    EMLog.d(TAG, "upload log fail, error: " + message);
                }
                @Override
                public void onProgress(int progress, String status) {}
                
            });
            break;
        case em_print_user:
            boolean debugMode = EMLog.debugMode;
            if(!debugMode){
            	EMLog.debugMode = true;
            }
            
            final String kRN = "\r\n";
            
            EMLog.d(TAG, " usename : " + EMClient.getInstance().getCurrentUser() + kRN
                       + " appkey  : " + config.getAppKey() + kRN
                       + " SDK     : " + config.getVersion());
            
            
            EMLog.debugMode = debugMode;
            
            break;
        case em_change_appkey:
            String appkey = message.getStringAttribute("appkey", null);
            EMLog.d(TAG, "received change appkey cmd, appkey: " + appkey);
            if(appkey != null){
                setDebugAppkey(appkey);
//                EMClient.getInstance().getChatConfig().setAppKey(appkey);
                //send broadcast to notify app logout
                Intent intent = new Intent(context.getPackageName() + ".em_internal_debug");
                intent.putExtra("debug_action", "change_appkey");
                context.sendBroadcast(intent);
                
            }
            break;
        case em_change_servers:
            String im = message.getStringAttribute("im_server", null);
            String rest = message.getStringAttribute("rest_server", null);
            boolean enable_dns = message.getBooleanAttribute("enable_dns",false);
            
            if(enable_dns){
            	if(config.isEnableDnsConfig()){
            		return;
            	}
            	
            	config.enableDnsConfig(true);
            	setDebugServer(null,null);
            	
            }else{
            	EMLog.d(TAG, "change servers to " + im + " and " + rest);
                if(im != null && rest != null){
                	config.enableDnsConfig(false);
                	config.setChatServer(im);
                	config.setRestServer(rest);
                    setDebugServer(im, rest);
                    
                    if(im.contains(":")){
                        config.setChatServer(im.split(":")[0]);
                        config.setChatPort(Integer.valueOf(im.split(":")[1]));
                    }
                }
            }
            
            //send broadcast to notify app logout
            Intent intent = new Intent(context.getPackageName() + ".em_internal_debug");
            intent.putExtra("debug_action", "change_servers");
            context.sendBroadcast(intent);
            break;
        case em_dump_db:
        {
            File file = context.getFilesDir();
            String workDir = file.getAbsolutePath();

            File sdPath = Environment.getExternalStorageDirectory();
            
            if(!sdPath.exists()){
            	return;
            }
            
            EasyUtils.copyFolder(workDir+"/easemobDB",sdPath + "/easemobDB");
            break;
        }
        default:
            break;
        }
    }
    
    
    public void setDebugServer(String imAddress, String restAddress){
        EMPreferenceUtils.getInstance().setDebugServer(imAddress, restAddress);
    }
    
    public String getDebugIMAddress(){
        return EMPreferenceUtils.getInstance().getDebugIMAddress();
    }
    
    public String getDebugRestAddress(){
       return EMPreferenceUtils.getInstance().getDebugRestAddress();
    }
    
    public void setDebugAppkey(String appkey){
        EMPreferenceUtils.getInstance().setDebugAppkey(appkey);
    }
    
    public String getDebugAppkey(){
        return EMPreferenceUtils.getInstance().getDebugAppkey();
    }
    
    public void setDebugMode(boolean debugMode){
        EMPreferenceUtils.getInstance().setDebugMode(debugMode);
    }
    
    public String getDebugMode(){
        return EMPreferenceUtils.getInstance().getDebugMode();
    }
    
    
    public enum Type{
        em_retrieve_dns,
        em_upload_dns,
        em_start_debug,
        em_stop_debug,
        em_upload_log,
        em_print_user,
        em_change_appkey,
        em_change_servers,
        em_dump_db
    }

	public void onInit(EMChatConfigPrivate config) {
		this.config = config;
		registerReceiver();
	}

	public void onDestroy() {
//		cnnMgr = null;
	}
}
