/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

/**
 * \~chinese
 * 加解密接口类
 * SDK 内置了基于AES的加密算法
 * 用户可以实现EncryptProvider，提供自己的加解密算法，对消息和附件进行加密/解密
 * 
 * 设置消息加密：
 * <pre>
 *       EaseMobChat.getInstance().setEncryptionMode(true);
 *       EaseMobChat.getInstance().setEncryptProvider(new MyEncryptProvider());
 *       
 * </pre>
 * 发送消息时：如果设置了消息加密系统会在发送消息前，调用用户设置的EncryptProvider来加密
 * 收到消息时：如果是加密消息，SDK 会调用用户设置的 EncryptProvider来解密
 *
 * \~english
 */
interface EMEncryptProvider {
    
    /**
     * \~chinese
     * 加密函数
     * @param input 输入未加密的byte array
     * @param toUserName 消息接收方的用户名
     * @return 返回加密后的byte array
     * 
     * \~english
     * encrypt method
     */
    byte[] encrypt(byte[] input, String toUserName);
    
    /**
     * \~chinese
     * 解密函数
     * @param input 输入已加密的byte array
     * @param fromUserName 消息发送方的用户名
     * @return 返回解密后的byte array
     * 
     * \~english
     * decrpyt method
     */
    byte[] decrypt(byte[] input, String fromUserName);
    
}
