/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.superrtc.sdk.VideoView;
import com.superrtc.sdk.VideoViewRenderer;

public class VideoViewWrapper
extends FrameLayout {
    private static final String TAG = "VideoViewWrapper";
    private VideoView videoView;
    private ImageView imageView;
    private Bitmap cover;

    public VideoViewWrapper(Context context) {
        super(context);
        this.init();
    }

    public VideoViewWrapper(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public VideoViewWrapper(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    public void setVisibility(int n) {
        this.videoView.setVisibility(n);
        this.imageView.setVisibility(n);
        super.setVisibility(n);
    }

    public void setZOrderMediaOverlay(boolean bl) {
        this.videoView.setZOrderMediaOverlay(bl);
    }

    public void setZOrderOnTop(boolean bl) {
        this.videoView.setZOrderOnTop(bl);
    }

    public void requestRender() {
        this.videoView.requestRender();
    }

    public synchronized VideoView.EMCallViewScaleMode getScaleMode() {
        return this.videoView.getScaleMode();
    }

    public synchronized void setScaleMode(VideoView.EMCallViewScaleMode eMCallViewScaleMode) {
        this.videoView.setScaleMode(eMCallViewScaleMode);
    }

    public VideoView getSurfaceView() {
        return this.videoView;
    }

    public VideoViewRenderer getRenderer() {
        return this.videoView.getRenderer();
    }

    public void release() {
        this.videoView.release();
    }

    public void setGestureEnable(boolean bl) {
        this.videoView.setGestureEnable(bl);
    }

    public void setCallViewListener(VideoView.CallViewListener callViewListener) {
        this.videoView.setCallViewListener(callViewListener);
    }

    public void setCoverImage(Bitmap bitmap) {
        this.cover = bitmap;
    }

    public boolean hasCover() {
        return this.cover != null;
    }

    void showCover(final boolean bl) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    VideoViewWrapper.this.imageView.setImageBitmap(VideoViewWrapper.this.cover);
                } else {
                    VideoViewWrapper.this.imageView.setImageBitmap(null);
                }
            }
        });
    }

    private void init() {
        this.videoView = new VideoView(this.getContext());
        this.videoView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addView((View)this.videoView);
        this.videoView.init(this);
        this.imageView = new ImageView(this.getContext());
        this.imageView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.addView((View)this.imageView);
    }
}

