/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */
package internal.org.apache.http.entity.mime.content;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayBody extends AbstractContentBody {
	private final byte[] data;
	private final String filename;

	public ByteArrayBody(byte[] data, String mimeType, String filename) {
		super(mimeType);
		if (data == null) {
			throw new IllegalArgumentException("byte[] may not be null");
		}
		this.data = data;
		this.filename = filename;
	}

	public ByteArrayBody(byte[] data, String filename) {
		this(data, "application/octet-stream", filename);
	}

	public String getFilename() {
		return this.filename;
	}

	public void writeTo(OutputStream out) throws IOException {
		out.write(this.data);
	}

	public String getCharset() {
		return null;
	}

	public String getTransferEncoding() {
		return "binary";
	}

	public long getContentLength() {
		return this.data.length;
	}

}
