/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import com.superrtc.call.DataChannel;
import com.superrtc.call.IceCandidate;
import com.superrtc.call.MediaConstraints;
import com.superrtc.call.MediaStream;
import com.superrtc.call.MediaStreamTrack;
import com.superrtc.call.RtpReceiver;
import com.superrtc.call.RtpSender;
import com.superrtc.call.SdpObserver;
import com.superrtc.call.SessionDescription;
import com.superrtc.call.StatsObserver;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PeerConnection {
    private final List<MediaStream> localStreams;
    private final long nativePeerConnection;
    private final long nativeObserver;
    private List<RtpSender> senders;
    private List<RtpReceiver> receivers;

    PeerConnection(long l, long l2) {
        this.nativePeerConnection = l;
        this.nativeObserver = l2;
        this.localStreams = new LinkedList<MediaStream>();
        this.senders = new LinkedList<RtpSender>();
        this.receivers = new LinkedList<RtpReceiver>();
    }

    public void SetMaxSendBandwidth(int n) {
        this.nativeSetMaxSendBandwidth(n);
    }

    public boolean TakePicture(String string) {
        return this.nativeTakePicture(string);
    }

    public void SetVideoResolution(int n, int n2, boolean bl) {
        this.nativeSetVideoResolution(n, n2, bl);
    }

    public native SessionDescription getLocalDescription();

    public native SessionDescription getRemoteDescription();

    public native DataChannel createDataChannel(String var1, DataChannel.Init var2);

    public native void createOffer(SdpObserver var1, MediaConstraints var2);

    public native void createAnswer(SdpObserver var1, MediaConstraints var2);

    public native void setLocalDescription(SdpObserver var1, SessionDescription var2);

    public native void setRemoteDescription(SdpObserver var1, SessionDescription var2);

    public native boolean setConfiguration(RTCConfiguration var1);

    public native void setdisableResize(boolean var1);

    public native void setconfigminbitrate(int var1);

    public boolean addIceCandidate(IceCandidate iceCandidate) {
        return this.nativeAddIceCandidate(iceCandidate.sdpMid, iceCandidate.sdpMLineIndex, iceCandidate.sdp);
    }

    public boolean addStream(MediaStream mediaStream) {
        boolean bl = this.nativeAddLocalStream(mediaStream.nativeStream);
        if (!bl) {
            return false;
        }
        this.localStreams.add(mediaStream);
        return true;
    }

    public void removeStream(MediaStream mediaStream) {
        this.nativeRemoveLocalStream(mediaStream.nativeStream);
        this.localStreams.remove(mediaStream);
    }

    public RtpSender createSender(String string, String string2) {
        RtpSender rtpSender = this.nativeCreateSender(string, string2);
        if (rtpSender != null) {
            this.senders.add(rtpSender);
        }
        return rtpSender;
    }

    public List<RtpSender> getSenders() {
        for (RtpSender rtpSender : this.senders) {
            rtpSender.dispose();
        }
        this.senders = this.nativeGetSenders();
        return Collections.unmodifiableList(this.senders);
    }

    public List<RtpReceiver> getReceivers() {
        for (RtpReceiver rtpReceiver : this.receivers) {
            rtpReceiver.dispose();
        }
        this.receivers = this.nativeGetReceivers();
        return Collections.unmodifiableList(this.receivers);
    }

    public boolean getStats(StatsObserver statsObserver, MediaStreamTrack mediaStreamTrack) {
        return this.nativeGetStats(statsObserver, mediaStreamTrack == null ? 0L : mediaStreamTrack.nativeTrack);
    }

    public native SignalingState signalingState();

    public native IceConnectionState iceConnectionState();

    public native IceGatheringState iceGatheringState();

    public native void close();

    public void dispose() {
        this.close();
        for (MediaStream object : this.localStreams) {
            this.nativeRemoveLocalStream(object.nativeStream);
            object.dispose();
        }
        this.localStreams.clear();
        for (RtpSender rtpSender : this.senders) {
            rtpSender.dispose();
        }
        this.senders.clear();
        for (RtpReceiver rtpReceiver : this.receivers) {
            rtpReceiver.dispose();
        }
        this.receivers.clear();
        PeerConnection.freePeerConnection(this.nativePeerConnection);
        PeerConnection.freeObserver(this.nativeObserver);
    }

    private static native void freePeerConnection(long var0);

    private static native void freeObserver(long var0);

    private native boolean nativeAddIceCandidate(String var1, int var2, String var3);

    private native boolean nativeAddLocalStream(long var1);

    private native void nativeRemoveLocalStream(long var1);

    private native boolean nativeGetStats(StatsObserver var1, long var2);

    private native RtpSender nativeCreateSender(String var1, String var2);

    private native List<RtpSender> nativeGetSenders();

    private native List<RtpReceiver> nativeGetReceivers();

    private native boolean nativeSetMaxSendBandwidth(int var1);

    private native boolean nativeTakePicture(String var1);

    private native void nativeSetVideoResolution(int var1, int var2, boolean var3);

    public static String getVersion() {
        return "test1";
    }

    private static native String nativeGetVersion();

    public long[][] getAudioLevel() {
        return this.nativeGetAudioLevel();
    }

    private native long[][] nativeGetAudioLevel();

    public static int setDocDiretory(String string) {
        return PeerConnection.nativeSetDocDiretory(string);
    }

    public static native int nativeSetDocDiretory(String var0);

    static {
        System.loadLibrary("hyphenate_av");
    }

    public static class RTCConfiguration {
        public IceTransportsType iceTransportsType = IceTransportsType.ALL;
        public List<IceServer> iceServers;
        public BundlePolicy bundlePolicy = BundlePolicy.BALANCED;
        public RtcpMuxPolicy rtcpMuxPolicy = RtcpMuxPolicy.NEGOTIATE;
        public TcpCandidatePolicy tcpCandidatePolicy = TcpCandidatePolicy.ENABLED;
        public int audioJitterBufferMaxPackets;
        public boolean audioJitterBufferFastAccelerate;
        public int iceConnectionReceivingTimeout;
        public int iceBackupCandidatePairPingInterval;
        public KeyType keyType;
        public ContinualGatheringPolicy continualGatheringPolicy;

        public RTCConfiguration(List<IceServer> list) {
            this.iceServers = list;
            this.audioJitterBufferMaxPackets = 50;
            this.audioJitterBufferFastAccelerate = false;
            this.iceConnectionReceivingTimeout = -1;
            this.iceBackupCandidatePairPingInterval = -1;
            this.keyType = KeyType.ECDSA;
            this.continualGatheringPolicy = ContinualGatheringPolicy.GATHER_ONCE;
        }
    }

    public static enum ContinualGatheringPolicy {
        GATHER_ONCE,
        GATHER_CONTINUALLY;

    }

    public static enum KeyType {
        RSA,
        ECDSA;

    }

    public static enum TcpCandidatePolicy {
        ENABLED,
        DISABLED;

    }

    public static enum RtcpMuxPolicy {
        NEGOTIATE,
        REQUIRE;

    }

    public static enum BundlePolicy {
        BALANCED,
        MAXBUNDLE,
        MAXCOMPAT;

    }

    public static enum IceTransportsType {
        NONE,
        RELAY,
        NOHOST,
        ALL;

    }

    public static class IceServer {
        public final String uri;
        public final String username;
        public final String password;

        public IceServer(String string) {
            this(string, "", "");
        }

        public IceServer(String string, String string2, String string3) {
            this.uri = string;
            this.username = string2;
            this.password = string3;
        }

        public String toString() {
            return this.uri + "[" + this.username + ":" + this.password + "]";
        }
    }

    public static interface Observer {
        public void onSignalingChange(SignalingState var1);

        public void onIceConnectionChange(IceConnectionState var1);

        public void onIceConnectionReceivingChange(boolean var1);

        public void onIceGatheringChange(IceGatheringState var1);

        public void onIceCandidate(IceCandidate var1);

        public void onAddStream(MediaStream var1);

        public void onRemoveStream(MediaStream var1);

        public void onDataChannel(DataChannel var1);

        public void onRenegotiationNeeded();
    }

    public static enum SignalingState {
        STABLE,
        HAVE_LOCAL_OFFER,
        HAVE_LOCAL_PRANSWER,
        HAVE_REMOTE_OFFER,
        HAVE_REMOTE_PRANSWER,
        CLOSED;

    }

    public static enum IceConnectionState {
        NEW,
        CHECKING,
        CONNECTED,
        COMPLETED,
        FAILED,
        DISCONNECTED,
        CLOSED;

    }

    public static enum IceGatheringState {
        NEW,
        GATHERING,
        COMPLETE;

    }
}

